/*
 * $Id$
 *
 * Copyright (C) INRIA, 2008-2009
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

//package test.com.acme.dona.dep;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotNull;
import static org.testng.Assert.assertNull;
import static org.testng.Assert.assertTrue;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Configuration;
import org.testng.annotations.Test;
//import org.testng.annotations.*;

import fr.inrialpes.exmo.ontosim.string.StringDistances;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;

/**
 * These tests corresponds to the README file in the main directory
 */

public class StringDistanceTest {

    @Test(groups = { "full", "noling" })
    public void tokenizeTest() throws Exception {
	Vector<String> res = StringDistances.tokenize( "ComputerScience" );
	// [Computer, Science]
	assertEquals( res.size(), 2 );
	assertEquals( res.get(1), "Science" );
	res = StringDistances.tokenize( "FullProfessor in ComputerScience" );
	// [FullProfessor, in, ComputerScience]
	assertEquals( res.size(), 3 );
	assertEquals( res.get(1), "in" );
	res = StringDistances.tokenize( "USofAmerica" );
	// [USof, America]
	assertEquals( res.size(), 2 );
	assertEquals( res.get(1), "America" );
	res = StringDistances.tokenize( "SpiritofAmerica" );
	// [Spiritof, America]
	assertEquals( res.size(), 2 );
	assertEquals( res.get(1), "America" );
	res = StringDistances.tokenize( "SpiritOfAmerica" );
	// [Spirit, Of, America]
	assertEquals( res.size(), 3 );
	assertEquals( res.get(1), "Of" );
	res = StringDistances.tokenize( "ProtoDL" );
	// [Proto, DL]
	assertEquals( res.size(), 2 );
	assertEquals( res.get(1), "DL" );
	res = StringDistances.tokenize( "And/or" );
	// [And, or]
	assertEquals( res.size(), 2 );
	assertEquals( res.get(1), "or" );
	res = StringDistances.tokenize( "title: FullProfessor" );
	// [title, FullProfessor]
	assertEquals( res.size(), 2 );
	assertEquals( res.get(1), "FullProfessor" );
    }
}
