package fr.inrialpes.exmo.ontosim.extractor.matching;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;




public class BasicMatching<O> implements Matching<O> {

    /*private List<O> src;
    private List<O> trg;*/
    
    private HashMap<O,Set<O>> entries;
    private List<Entry<O>> entriesList;
    
    public BasicMatching() {
	entries=new HashMap<O,Set<O>>();
	entriesList=new LinkedList<Entry<O>>();
    }
    
    public boolean add(O s, O t) {
	Set<O> sTrg = entries.get(s);
	if (sTrg==null) {
	    sTrg=new HashSet<O>();
	    entries.put(s, sTrg);
	}
	if (sTrg.add(t)) {
	    entriesList.add(new Entry<O>(s,t));
	    return true;
	}
	return false;
    }

    public void clear() {
	entries.clear();
	entriesList.clear();
    }

   

    /**
     * To be modified
     */
    public Matching<O> transposeView() {
	return new BasicMatching<O>() {
	    public boolean add(O s, O t) {
		return BasicMatching.this.add(t, s);
	    }
	};
    }

    public int size() {
	return entriesList.size();
    }

    public boolean contains(O s, O t) {
	return entries.containsKey(s) && entries.get(s).contains(t);
    }

    public Iterator<Matching.Entry<O>> iterator() {
	return entriesList.iterator();
    }




}
