package fr.inrialpes.exmo.ontosim.entity.model;



import fr.inrialpes.exmo.ontowrap.HeavyLoadedOntology;


public abstract class HLEntityImpl<E> extends EntityImpl<E> implements HLEntity<E> {

    //public final static Map<Object,Reference<HLEntity<?>>> ENTITY_CACHE=new WeakHashMap<Object,Reference<HLEntity<?>>>();
    protected HeavyLoadedOntology<E> onto;

    protected HLEntityFactory<E> fact;
    
    protected HLEntityImpl(HeavyLoadedOntology<E> ont, E e) {
	super(ont, e);
	onto=ont;
	fact=HLEntityFactory.getInstance(ont);
	//ENTITY_CACHE.put(e, new SoftReference<HLEntity<?>>(this));
    }
    
    /* Capability methods */
    public boolean getCapabilities( int direct, int asserted, int named ) {
	return onto.getCapabilities(direct, asserted, named);
    }

   /*protected Set<? extends HLEntity<E>> getFrom(Set<E> entities) {
	Set<HLEntity<E>> s = new HashSet<HLEntity<E>>();
	for (E e : entities) {
	    Reference<HLEntity<?>> hle = ENTITY_CACHE.get(e);
	    if (hle == null || hle.get()==null)
		s.add(HLEntityFactory.createHLEntity(onto,e));
	    else {
		s.add((HLEntity<E>)hle.get());
	    }
		
	}
	return s;
    }*/
    
    protected final int getIdx(int local, int asserted, int named ) {
	int idx = 1<<local+1<<asserted+1<<named-1;
	return idx;
    }

    public HeavyLoadedOntology<E> getOntology() {
	return onto;
    }
}
