/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontowrap.owlapi30;

import fr.inrialpes.exmo.ontowrap.HeavyLoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntologyCache;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import fr.inrialpes.exmo.ontowrap.owlapi30.OWLAPI3Ontology;
import java.net.URI;
import java.net.URISyntaxException;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyDocumentAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OWLAPI3OntologyFactory
extends OntologyFactory {
    private URI formalismUri = null;
    private String formalismId = "OWL2.0";
    private OWLOntologyManager manager;
    private static OntologyCache<OWLAPI3Ontology> cache = null;

    public OWLAPI3OntologyFactory() {
        cache = new OntologyCache();
        try {
            this.formalismUri = new URI("http://www.w3.org/2002/07/owl#");
            this.manager = OWLManager.createOWLOntologyManager();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    @Override
    public OWLAPI3Ontology newOntology(Object object) throws OntowrapException {
        if (object instanceof OWLOntology) {
            OWLAPI3Ontology oWLAPI3Ontology = new OWLAPI3Ontology();
            oWLAPI3Ontology.setFormalism(this.formalismId);
            oWLAPI3Ontology.setFormURI(this.formalismUri);
            oWLAPI3Ontology.setOntology((OWLOntology)object);
            oWLAPI3Ontology.setURI(((OWLOntology)object).getOntologyID().getOntologyIRI().toURI());
            cache.recordOntology(oWLAPI3Ontology.getURI(), oWLAPI3Ontology);
            cache.recordOntology(((OWLOntology)object).getOntologyID().getOntologyIRI().toURI(), oWLAPI3Ontology);
            return oWLAPI3Ontology;
        }
        throw new OntowrapException("Argument is not an OWLOntology: " + object);
    }

    @Override
    public HeavyLoadedOntology loadOntology(URI uRI) throws OntowrapException {
        OWLOntology oWLOntology;
        OWLAPI3Ontology oWLAPI3Ontology = null;
        oWLAPI3Ontology = cache.getOntologyFromURI(uRI);
        if (oWLAPI3Ontology != null) {
            return oWLAPI3Ontology;
        }
        oWLAPI3Ontology = cache.getOntology(uRI);
        if (oWLAPI3Ontology != null) {
            return oWLAPI3Ontology;
        }
        try {
            oWLOntology = this.manager.loadOntology(IRI.create((URI)uRI));
        }
        catch (OWLOntologyDocumentAlreadyExistsException oWLOntologyDocumentAlreadyExistsException) {
            throw new OntowrapException("Already loaded [cache failure] " + uRI, (Exception)((Object)oWLOntologyDocumentAlreadyExistsException));
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            oWLOntologyCreationException.printStackTrace();
            throw new OntowrapException("Cannot load " + uRI, (Exception)((Object)oWLOntologyCreationException));
        }
        oWLAPI3Ontology = new OWLAPI3Ontology();
        oWLAPI3Ontology.setFormalism(this.formalismId);
        oWLAPI3Ontology.setFormURI(this.formalismUri);
        oWLAPI3Ontology.setOntology(oWLOntology);
        oWLAPI3Ontology.setFile(uRI);
        oWLAPI3Ontology.setURI(oWLOntology.getOntologyID().getOntologyIRI().toURI());
        cache.recordOntology(uRI, oWLAPI3Ontology);
        return oWLAPI3Ontology;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    @Override
    public void clearCache() {
        cache.clear();
    }
}

