/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontowrap.owlapi10;

import fr.inrialpes.exmo.ontowrap.OntologyCache;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import fr.inrialpes.exmo.ontowrap.owlapi10.OWLAPIOntology;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;

public class OWLAPIOntologyFactory
extends OntologyFactory {
    private static URI formalismUri = null;
    private static String formalismId = "OWL1.0";
    private static OntologyCache<OWLAPIOntology> cache = null;

    public OWLAPIOntologyFactory() {
        cache = new OntologyCache();
        try {
            formalismUri = new URI("http://www.w3.org/2002/07/owl#");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    @Override
    public void clearCache() {
        cache.clear();
    }

    @Override
    public OWLAPIOntology newOntology(Object object) throws OntowrapException {
        if (object instanceof OWLOntology) {
            OWLAPIOntology oWLAPIOntology = new OWLAPIOntology();
            oWLAPIOntology.setFormalism(formalismId);
            oWLAPIOntology.setFormURI(formalismUri);
            oWLAPIOntology.setOntology((OWLOntology)object);
            try {
                oWLAPIOntology.setURI(((OWLOntology)object).getLogicalURI());
            }
            catch (OWLException oWLException) {
                oWLException.printStackTrace();
            }
            return oWLAPIOntology;
        }
        throw new OntowrapException("Argument is not an OWLOntology: " + object);
    }

    @Override
    public OWLAPIOntology loadOntology(URI uRI) throws OntowrapException {
        OWLAPIOntology oWLAPIOntology = null;
        oWLAPIOntology = cache.getOntologyFromURI(uRI);
        if (oWLAPIOntology != null) {
            return oWLAPIOntology;
        }
        oWLAPIOntology = cache.getOntology(uRI);
        if (oWLAPIOntology != null) {
            return oWLAPIOntology;
        }
        OWLConnection oWLConnection = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWL_CONNECTION", "org.semanticweb.owl.impl.model.OWLConnectionImpl");
        try {
            oWLConnection = OWLManager.getOWLConnection(hashMap);
            Level level = Logger.getLogger((String)"org.semanticweb.owl").getLevel();
            Logger.getLogger((String)"org.semanticweb.owl").setLevel(Level.ERROR);
            OWLOntology oWLOntology = oWLConnection.loadOntologyPhysical(uRI);
            Logger.getLogger((String)"org.semanticweb.owl").setLevel(level);
            oWLAPIOntology = new OWLAPIOntology();
            oWLAPIOntology.setFormalism(formalismId);
            oWLAPIOntology.setFormURI(formalismUri);
            oWLAPIOntology.setOntology(oWLOntology);
            oWLAPIOntology.setFile(uRI);
            try {
                oWLAPIOntology.setURI(oWLOntology.getLogicalURI());
            }
            catch (OWLException oWLException) {
                oWLException.printStackTrace();
            }
            cache.recordOntology(uRI, oWLAPIOntology);
            return oWLAPIOntology;
        }
        catch (OWLException oWLException) {
            throw new OntowrapException("Cannot load " + uRI, (Exception)((Object)oWLException));
        }
    }
}

