/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontowrap.owlapi10;

import fr.inrialpes.exmo.ontowrap.BasicOntology;
import fr.inrialpes.exmo.ontowrap.HeavyLoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import fr.inrialpes.exmo.ontowrap.owlapi10.OWLAPIAnnotIt;
import fr.inrialpes.exmo.ontowrap.util.EntityFilter;
import java.net.URI;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.io.vocabulary.RDFSVocabularyAdapter;
import org.semanticweb.owl.model.OWLCardinalityRestriction;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNaryBooleanDescription;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLRestriction;
import org.semanticweb.owl.model.helper.OWLEntityCollector;

public class OWLAPIOntology
extends BasicOntology<OWLOntology>
implements HeavyLoadedOntology<OWLOntology> {
    private int nbentities = -1;
    private int nbclasses = -1;
    private int nbproperties = -1;
    private int nbobjectproperties = -1;
    private int nbdataproperties = -1;
    private int nbindividuals = -1;

    public OWLAPIOntology() {
        this.setFormalism("OWL1.0");
        try {
            this.setFormURI(new URI("http://www.w3.org/2002/07/owl#"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public OWLOntology getOntology() {
        return (OWLOntology)this.onto;
    }

    @Override
    public void setOntology(OWLOntology oWLOntology) {
        this.onto = oWLOntology;
    }

    @Override
    public Object getEntity(URI uRI) throws OntowrapException {
        try {
            OWLClass oWLClass = ((OWLOntology)this.onto).getClass(uRI);
            if (oWLClass == null) {
                oWLClass = ((OWLOntology)this.onto).getDataProperty(uRI);
            }
            if (oWLClass == null) {
                oWLClass = ((OWLOntology)this.onto).getObjectProperty(uRI);
            }
            if (oWLClass == null) {
                oWLClass = ((OWLOntology)this.onto).getIndividual(uRI);
            }
            return oWLClass;
        }
        catch (OWLException oWLException) {
            throw new OntowrapException("Cannot dereference URI : " + uRI);
        }
    }

    @Override
    public URI getEntityURI(Object object) throws OntowrapException {
        try {
            return ((OWLEntity)object).getURI();
        }
        catch (OWLException oWLException) {
            throw new OntowrapException("Cannot get URI ", (Exception)((Object)oWLException));
        }
    }

    @Override
    public String getEntityName(Object object) throws OntowrapException {
        try {
            URI uRI = ((OWLEntity)object).getURI();
            if (uRI != null) {
                return uRI.getFragment();
            }
            return "";
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public String getEntityName(Object object, String string) throws OntowrapException {
        return this.getEntityName(object);
    }

    @Override
    public Set<String> getEntityNames(Object object, String string) throws OntowrapException {
        try {
            OWLEntity oWLEntity = (OWLEntity)object;
            return this.getAnnotations(oWLEntity, string, RDFSVocabularyAdapter.INSTANCE.getLabel());
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public Set<String> getEntityNames(Object object) throws OntowrapException {
        try {
            OWLEntity oWLEntity = (OWLEntity)object;
            return this.getAnnotations(oWLEntity, null, RDFSVocabularyAdapter.INSTANCE.getLabel());
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public Set<String> getEntityComments(Object object, String string) throws OntowrapException {
        try {
            OWLEntity oWLEntity = (OWLEntity)object;
            return this.getAnnotations(oWLEntity, string, RDFSVocabularyAdapter.INSTANCE.getComment());
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public Set<String> getEntityComments(Object object) throws OntowrapException {
        try {
            OWLEntity oWLEntity = (OWLEntity)object;
            return this.getAnnotations(oWLEntity, null, RDFSVocabularyAdapter.INSTANCE.getComment());
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    protected Set<String> getAnnotations(final OWLEntity oWLEntity, final String string, final String string2) throws OWLException {
        final OWLOntology oWLOntology = (OWLOntology)this.onto;
        return new AbstractSet<String>(){
            int size = -1;

            @Override
            public Iterator<String> iterator() {
                try {
                    return new OWLAPIAnnotIt(oWLOntology, oWLEntity, string, string2);
                }
                catch (OWLException oWLException) {
                    oWLException.printStackTrace();
                    return null;
                }
            }

            @Override
            public int size() {
                if (this.size == -1) {
                    for (String string3 : this) {
                        ++this.size;
                    }
                    ++this.size;
                }
                return this.size;
            }
        };
    }

    @Override
    public Set<String> getEntityAnnotations(Object object) throws OntowrapException {
        try {
            return this.getAnnotations((OWLEntity)object, null, null);
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public Set<String> getEntityAnnotations(Object object, String string) throws OntowrapException {
        try {
            return this.getAnnotations((OWLEntity)object, string, null);
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public boolean isEntity(Object object) {
        return object instanceof OWLEntity;
    }

    @Override
    public boolean isClass(Object object) {
        return object instanceof OWLClass;
    }

    @Override
    public boolean isProperty(Object object) {
        return object instanceof OWLProperty;
    }

    @Override
    public boolean isDataProperty(Object object) {
        return object instanceof OWLDataProperty;
    }

    @Override
    public boolean isObjectProperty(Object object) {
        return object instanceof OWLObjectProperty;
    }

    @Override
    public boolean isIndividual(Object object) {
        return object instanceof OWLIndividual;
    }

    protected Set<?> getEntities(Class<? extends OWLEntity> clazz) throws OWLException {
        OWLEntityCollector oWLEntityCollector = new OWLEntityCollector();
        ((OWLOntology)this.onto).accept((OWLObjectVisitor)oWLEntityCollector);
        return new EntityFilter(oWLEntityCollector.entities(), this);
    }

    @Override
    public Set<?> getEntities() {
        try {
            return this.getEntities(OWLEntity.class);
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public Set<?> getClasses() {
        try {
            return this.getEntities(OWLClass.class);
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public Set<?> getProperties() {
        try {
            return this.getEntities(OWLProperty.class);
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public Set<?> getDataProperties() {
        try {
            return this.getEntities(OWLDataProperty.class);
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public Set<?> getObjectProperties() {
        try {
            return this.getEntities(OWLObjectProperty.class);
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public Set<?> getIndividuals() {
        try {
            return this.getEntities(OWLIndividual.class);
        }
        catch (OWLException oWLException) {
            return null;
        }
    }

    @Override
    public int nbEntities() {
        if (this.nbentities != -1) {
            return this.nbentities;
        }
        this.nbentities = this.getEntities().size();
        return this.nbentities;
    }

    @Override
    public int nbClasses() {
        if (this.nbclasses != -1) {
            return this.nbclasses;
        }
        this.nbclasses = this.getClasses().size();
        return this.nbclasses;
    }

    @Override
    public int nbProperties() {
        if (this.nbproperties != -1) {
            return this.nbproperties;
        }
        this.nbproperties = this.nbObjectProperties() + this.nbDataProperties();
        return this.nbproperties;
    }

    @Override
    public int nbObjectProperties() {
        if (this.nbobjectproperties != -1) {
            return this.nbobjectproperties;
        }
        this.nbobjectproperties = this.getObjectProperties().size();
        return this.nbobjectproperties;
    }

    @Override
    public int nbDataProperties() {
        if (this.nbdataproperties != -1) {
            return this.nbdataproperties;
        }
        this.nbdataproperties = this.getDataProperties().size();
        return this.nbdataproperties;
    }

    @Override
    public int nbIndividuals() {
        if (this.nbindividuals != -1) {
            return this.nbindividuals;
        }
        this.nbindividuals = this.getIndividuals().size();
        return this.nbindividuals;
    }

    @Override
    public void unload() {
        try {
            ((OWLOntology)this.onto).getOWLConnection().notifyOntologyDeleted((OWLOntology)this.onto);
        }
        catch (OWLException oWLException) {
            System.err.println((Object)oWLException);
        }
    }

    @Override
    public boolean getCapabilities(int n, int n2, int n3) {
        return true;
    }

    @Override
    public Set<Object> getSubClasses(Object object, int n, int n2, int n3) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object obj : this.getClasses()) {
            if (!this.getSuperClasses((OWLClass)obj, n, n2, n3).contains(object)) continue;
            hashSet.add(obj);
        }
        return hashSet;
    }

    @Override
    public Set<Object> getSuperClasses(Object object, int n, int n2, int n3) {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (n2 == OntologyFactory.ASSERTED) {
            try {
                for (Object e : ((OWLClass)object).getSuperClasses(this.getOntology())) {
                    if (!(e instanceof OWLClass)) continue;
                    hashSet.add(e);
                }
            }
            catch (OWLException oWLException) {}
        } else {
            try {
                HashSet hashSet2 = new HashSet();
                for (Object e : ((OWLClass)object).getSuperClasses(this.getOntology())) {
                    if (!(e instanceof OWLClass)) continue;
                    hashSet.add(e);
                    hashSet2.add(e);
                }
            }
            catch (OWLException oWLException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    @Override
    public Set<Object> getProperties(Object object, int n, int n2, int n3) {
        HashSet<Object> hashSet = new HashSet();
        if (n2 == OntologyFactory.ASSERTED && n == OntologyFactory.LOCAL) {
            try {
                for (Object e : ((OWLClass)object).getSuperClasses(this.getOntology())) {
                    if (!(e instanceof OWLRestriction)) continue;
                    hashSet.add(((OWLRestriction)e).getProperty());
                }
            }
            catch (OWLException oWLException) {
                oWLException.printStackTrace();
            }
        } else {
            hashSet = this.getInheritedProperties((OWLClass)object);
        }
        return hashSet;
    }

    @Override
    public Set<Object> getDataProperties(Object object, int n, int n2, int n3) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object2 : this.getProperties(object, n, n2, n3)) {
            if (!(object2 instanceof OWLDataProperty)) continue;
            hashSet.add(object2);
        }
        return hashSet;
    }

    @Override
    public Set<Object> getObjectProperties(Object object, int n, int n2, int n3) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object2 : this.getProperties(object, n, n2, n3)) {
            if (!(object2 instanceof OWLObjectProperty)) continue;
            hashSet.add(object2);
        }
        return hashSet;
    }

    @Override
    public Set<Object> getInstances(Object object, int n, int n2, int n3) {
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            for (Object obj : this.getIndividuals()) {
                if (!((OWLIndividual)obj).getTypes(this.getOntology()).contains(object)) continue;
                hashSet.add(obj);
            }
        }
        catch (OWLException oWLException) {
            // empty catch block
        }
        return hashSet;
    }

    @Override
    public Set<Object> getSubProperties(Object object, int n, int n2, int n3) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object obj : this.getProperties()) {
            if (!this.getSuperProperties((OWLProperty)obj, n, n2, n3).contains(object)) continue;
            hashSet.add(obj);
        }
        return hashSet;
    }

    @Override
    public Set<Object> getSuperProperties(Object object, int n, int n2, int n3) {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (n2 == OntologyFactory.ASSERTED) {
            try {
                for (Object e : ((OWLProperty)object).getSuperProperties(this.getOntology())) {
                    if (!(e instanceof OWLProperty)) continue;
                    hashSet.add(e);
                }
            }
            catch (OWLException oWLException) {}
        } else {
            try {
                HashSet hashSet2 = new HashSet();
                for (Object e : ((OWLProperty)object).getSuperProperties(this.getOntology())) {
                    if (!(e instanceof OWLProperty)) continue;
                    hashSet2.add(e);
                    hashSet.add(e);
                }
            }
            catch (OWLException oWLException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    @Override
    public Set<Object> getRange(Object object, int n) {
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            for (Object e : ((OWLProperty)object).getRanges(this.getOntology())) {
                if (!(e instanceof OWLClass) && !(e instanceof OWLDataType)) continue;
                hashSet.add(e);
            }
        }
        catch (OWLException oWLException) {
            // empty catch block
        }
        return hashSet;
    }

    @Override
    public Set<Object> getDomain(Object object, int n) {
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            for (Object e : ((OWLProperty)object).getDomains(this.getOntology())) {
                if (!(e instanceof OWLClass)) continue;
                hashSet.add(e);
            }
        }
        catch (OWLException oWLException) {
            // empty catch block
        }
        return hashSet;
    }

    @Override
    public Set<Object> getClasses(Object object, int n, int n2, int n3) {
        Set set = null;
        try {
            set = ((OWLIndividual)object).getTypes(this.getOntology());
        }
        catch (OWLException oWLException) {
            // empty catch block
        }
        if (n == OntologyFactory.LOCAL) {
            return set;
        }
        return set;
    }

    public Set<Object> getCardinalityRestrictions(Object object) {
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            for (Object e : ((OWLClass)object).getSuperClasses(this.getOntology())) {
                if (!(e instanceof OWLCardinalityRestriction)) continue;
                hashSet.add(e);
            }
        }
        catch (OWLException oWLException) {
            // empty catch block
        }
        return hashSet;
    }

    private Set<Object> getInheritedProperties(OWLClass oWLClass) {
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            this.getProperties(oWLClass, hashSet);
        }
        catch (OWLException oWLException) {
            // empty catch block
        }
        return hashSet;
    }

    public void getProperties(OWLDescription oWLDescription, Set<Object> set) throws OWLException {
        if (oWLDescription instanceof OWLRestriction) {
            set.add(((OWLRestriction)oWLDescription).getProperty());
        } else if (oWLDescription instanceof OWLClass) {
            this.getProperties((OWLClass)oWLDescription, set);
        } else if (oWLDescription instanceof OWLNaryBooleanDescription) {
            for (Object e : ((OWLNaryBooleanDescription)oWLDescription).getOperands()) {
                this.getProperties((OWLDescription)e, set);
            }
        }
    }

    public void getProperties(OWLRestriction oWLRestriction, Set<Object> set) throws OWLException {
        set.add(oWLRestriction.getProperty());
    }

    public void getProperties(OWLNaryBooleanDescription oWLNaryBooleanDescription, Set<Object> set) throws OWLException {
        Iterator iterator = oWLNaryBooleanDescription.getOperands().iterator();
        while (iterator.hasNext()) {
            this.getProperties((OWLDescription)iterator.next(), set);
        }
    }

    public void getProperties(OWLClass oWLClass, Set<Object> set) throws OWLException {
        for (Object e : oWLClass.getSuperClasses(this.getOntology())) {
            this.getProperties((OWLDescription)e, set);
        }
        for (Object e : oWLClass.getEquivalentClasses(this.getOntology())) {
            this.getProperties((OWLDescription)e, set);
        }
    }
}

