/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontowrap.jena25;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import fr.inrialpes.exmo.ontowrap.OntologyCache;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import fr.inrialpes.exmo.ontowrap.jena25.JENAOntology;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.NoSuchElementException;

public class JENAOntologyFactory
extends OntologyFactory {
    private static URI formalismUri = null;
    private static String formalismId = "OWL1.0";
    private static OntologyCache<JENAOntology> cache = null;

    public JENAOntologyFactory() {
        cache = new OntologyCache();
        try {
            formalismUri = new URI("http://www.w3.org/2002/07/owl#");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    @Override
    public JENAOntology newOntology(Object object) throws OntowrapException {
        if (object instanceof OntModel) {
            JENAOntology jENAOntology = new JENAOntology();
            jENAOntology.setFormalism(formalismId);
            jENAOntology.setFormURI(formalismUri);
            jENAOntology.setOntology((OntModel)object);
            try {
                try {
                    jENAOntology.setURI(new URI(((Ontology)((OntModel)object).listOntologies().next()).getURI()));
                }
                catch (NoSuchElementException noSuchElementException) {
                    jENAOntology.setURI(new URI(((OntModel)object).getNsPrefixURI("")));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new OntowrapException("URI Error ", uRISyntaxException);
            }
            cache.recordOntology(jENAOntology.getURI(), jENAOntology);
            return jENAOntology;
        }
        throw new OntowrapException("Argument is not an OntModel: " + object);
    }

    @Override
    public JENAOntology loadOntology(URI uRI) throws OntowrapException {
        JENAOntology jENAOntology = null;
        jENAOntology = cache.getOntologyFromURI(uRI);
        if (jENAOntology != null) {
            return jENAOntology;
        }
        jENAOntology = cache.getOntology(uRI);
        if (jENAOntology != null) {
            return jENAOntology;
        }
        try {
            OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, null);
            ontModel.read(uRI.toString());
            jENAOntology = new JENAOntology();
            jENAOntology.setFile(uRI);
            try {
                jENAOntology.setURI(new URI(((Ontology)ontModel.listOntologies().next()).getURI()));
            }
            catch (NoSuchElementException noSuchElementException) {
                jENAOntology.setURI(new URI(ontModel.getNsPrefixURI("")));
            }
            jENAOntology.setOntology(ontModel);
            cache.recordOntology(uRI, jENAOntology);
            return jENAOntology;
        }
        catch (Exception exception) {
            throw new OntowrapException("Cannot load " + uRI, exception);
        }
    }

    @Override
    public void clearCache() {
        cache.clear();
    }
}

