/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontowrap.jena25;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import fr.inrialpes.exmo.ontowrap.BasicOntology;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import fr.inrialpes.exmo.ontowrap.util.EntityFilter;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class JENAOntology
extends BasicOntology<OntModel>
implements LoadedOntology<OntModel> {
    protected static final Map1<OntProperty, OntResource> mapProperty = new Map1<OntProperty, OntResource>(){

        public OntResource map1(OntProperty ontProperty) {
            return ontProperty;
        }
    };
    protected static final Map1<OntClass, OntResource> mapClass = new Map1<OntClass, OntResource>(){

        public OntResource map1(OntClass ontClass) {
            return ontClass;
        }
    };
    protected static final Map1<Individual, OntResource> mapInd = new Map1<Individual, OntResource>(){

        public OntResource map1(Individual individual) {
            return individual;
        }
    };

    @Override
    public Object getEntity(URI uRI) throws OntowrapException {
        return ((OntModel)this.onto).getOntResource(uRI.toString());
    }

    public void getEntityAnnotations(Object object, Set<String> set, String string) throws OntowrapException {
        StmtIterator stmtIterator = ((OntModel)this.onto).listStatements((Resource)object, null, (RDFNode)null);
        while (stmtIterator.hasNext()) {
            RDFNode rDFNode;
            Statement statement = (Statement)stmtIterator.next();
            if (!statement.getPredicate().canAs(AnnotationProperty.class) || !(rDFNode = statement.getObject()).isLiteral()) continue;
            Literal literal = (Literal)rDFNode.as(Literal.class);
            if (string == null || string.equals(literal.getLanguage())) {
                set.add(literal.getLexicalForm());
                continue;
            }
            if (!rDFNode.isResource()) continue;
            this.getEntityAnnotations(rDFNode, set, string);
        }
    }

    @Override
    public Set<String> getEntityAnnotations(Object object) throws OntowrapException {
        HashSet<String> hashSet = new HashSet<String>();
        this.getEntityAnnotations(object, hashSet, null);
        return hashSet;
    }

    @Override
    public Set<String> getEntityAnnotations(Object object, String string) throws OntowrapException {
        HashSet<String> hashSet = new HashSet<String>();
        this.getEntityAnnotations(object, hashSet, string);
        return hashSet;
    }

    @Override
    public Set<String> getEntityComments(Object object, String string) throws OntowrapException {
        HashSet<String> hashSet = new HashSet<String>();
        ExtendedIterator extendedIterator = ((OntResource)object).listComments(string);
        while (extendedIterator.hasNext()) {
            hashSet.add(((LiteralImpl)extendedIterator.next()).getLexicalForm());
        }
        return hashSet;
    }

    @Override
    public Set<String> getEntityComments(Object object) throws OntowrapException {
        return this.getEntityComments(object, null);
    }

    @Override
    public String getEntityName(Object object) throws OntowrapException {
        try {
            return this.getFragmentAsLabel(new URI(((OntResource)object).getURI()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getEntityName(Object object, String string) throws OntowrapException {
        return this.getEntityName(object);
    }

    @Override
    public Set<String> getEntityNames(Object object, String string) throws OntowrapException {
        HashSet<String> hashSet = new HashSet<String>();
        OntResource ontResource = (OntResource)object;
        ExtendedIterator extendedIterator = ontResource.listLabels(string);
        while (extendedIterator.hasNext()) {
            String string2 = ((LiteralImpl)extendedIterator.next()).getLexicalForm();
            hashSet.add(string2);
        }
        return hashSet;
    }

    @Override
    public Set<String> getEntityNames(Object object) throws OntowrapException {
        return this.getEntityNames(object, null);
    }

    @Override
    public URI getEntityURI(Object object) throws OntowrapException {
        try {
            OntResource ontResource = (OntResource)object;
            return new URI(ontResource.getURI());
        }
        catch (Exception exception) {
            throw new OntowrapException(object.toString() + " do not have uri", exception);
        }
    }

    @Override
    public Set<OntClass> getClasses() {
        return new EntityFilter<OntClass>(((OntModel)this.onto).listNamedClasses().toSet(), this);
    }

    @Override
    public Set<DatatypeProperty> getDataProperties() {
        return new EntityFilter<DatatypeProperty>(((OntModel)this.onto).listDatatypeProperties().toSet(), this);
    }

    @Override
    public Set<OntResource> getEntities() {
        return new EntityFilter<OntResource>(((OntModel)this.onto).listAllOntProperties().mapWith(mapProperty).andThen((Iterator)((OntModel)this.onto).listNamedClasses().mapWith(mapClass)).andThen((Iterator)((OntModel)this.onto).listIndividuals().mapWith(mapInd)).toSet(), this);
    }

    @Override
    public Set<Individual> getIndividuals() {
        return new EntityFilter<Individual>(((OntModel)this.onto).listIndividuals().toSet(), this);
    }

    @Override
    public Set<ObjectProperty> getObjectProperties() {
        return new EntityFilter<ObjectProperty>(((OntModel)this.onto).listObjectProperties().toSet(), this);
    }

    @Override
    public Set<OntProperty> getProperties() {
        return new EntityFilter<OntProperty>(((OntModel)this.onto).listAllOntProperties().toSet(), this);
    }

    @Override
    public boolean isClass(Object object) {
        return object instanceof OntClass;
    }

    @Override
    public boolean isDataProperty(Object object) {
        return object instanceof DatatypeProperty;
    }

    @Override
    public boolean isEntity(Object object) {
        return this.isClass(object) || this.isProperty(object) || this.isIndividual(object);
    }

    @Override
    public boolean isIndividual(Object object) {
        return object instanceof Individual;
    }

    @Override
    public boolean isObjectProperty(Object object) {
        return object instanceof ObjectProperty;
    }

    @Override
    public boolean isProperty(Object object) {
        return object instanceof OntProperty;
    }

    @Override
    public int nbEntities() {
        return this.getEntities().size();
    }

    @Override
    public int nbClasses() {
        return this.getClasses().size();
    }

    @Override
    public int nbDataProperties() {
        return this.getDataProperties().size();
    }

    @Override
    public int nbIndividuals() {
        return this.getIndividuals().size();
    }

    @Override
    public int nbObjectProperties() {
        return this.getObjectProperties().size();
    }

    @Override
    public int nbProperties() {
        return this.getProperties().size();
    }

    @Override
    public void unload() {
    }
}

