/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontowrap;

import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Hashtable;

public abstract class OntologyFactory {
    public static int ANY = 0;
    public static int DIRECT = 1;
    public static int INDIRECT = 2;
    public static int ASSERTED = 3;
    public static int UNASSERTED = 4;
    public static int INHERITED = 5;
    public static int FULL = 6;
    public static int NAMED = 7;
    public static int LOCAL = 8;
    public static int GLOBAL = 9;
    public static int UNNAMED = 10;
    public static int MENTIONNED = 11;
    public static int ALL = 12;
    protected static Hashtable<String, OntologyFactory> instances = null;
    private static String API_NAME = "fr.inrialpes.exmo.ontowrap.owlapi30.OWLAPI3OntologyFactory";

    public static String getDefaultFactory() {
        return API_NAME;
    }

    public static void setDefaultFactory(String string) {
        API_NAME = string;
    }

    public static OntologyFactory getFactory() {
        return OntologyFactory.newInstance(API_NAME);
    }

    private static OntologyFactory newInstance(String string) {
        OntologyFactory ontologyFactory;
        if (instances == null) {
            instances = new Hashtable();
        }
        if ((ontologyFactory = instances.get(string)) != null) {
            return ontologyFactory;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{};
            ontologyFactory = (OntologyFactory)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        instances.put(string, ontologyFactory);
        return ontologyFactory;
    }

    public static void clear() {
        if (instances != null) {
            for (OntologyFactory ontologyFactory : instances.values()) {
                ontologyFactory.clearCache();
            }
        }
    }

    public abstract void clearCache();

    public abstract LoadedOntology newOntology(Object var1) throws OntowrapException;

    public abstract LoadedOntology loadOntology(URI var1) throws OntowrapException;
}

