/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontowrap;

import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;

public class OntologyCache<O extends LoadedOntology> {
    Hashtable<URI, O> ontologies = new Hashtable();
    Hashtable<URI, O> ontologyUris = new Hashtable();

    public void recordOntology(URI uRI, O o) {
        this.ontologies.put(uRI, o);
        this.ontologyUris.put(o.getURI(), o);
    }

    public O getOntology(URI uRI) {
        return (O)((LoadedOntology)this.ontologies.get(uRI));
    }

    public O getOntologyFromURI(URI uRI) {
        return (O)((LoadedOntology)this.ontologyUris.get(uRI));
    }

    public void unloadOntology(URI uRI, O o) {
        LoadedOntology loadedOntology = (LoadedOntology)this.ontologyUris.get(uRI);
        loadedOntology.unload();
        this.ontologyUris.remove(uRI);
        this.ontologies.remove(uRI);
    }

    public void displayCache() {
        System.err.println("CACHE: " + this.ontologies.size() + "/" + this.ontologyUris.size() + " elements cached");
        Enumeration<URI> enumeration = this.ontologies.keys();
        while (enumeration.hasMoreElements()) {
            URI uRI = enumeration.nextElement();
            LoadedOntology loadedOntology = (LoadedOntology)this.ontologies.get(uRI);
            System.err.println("      " + uRI);
            System.err.println("      " + loadedOntology.getURI());
            System.err.println("  --> " + loadedOntology + " (" + loadedOntology.getOntology() + ")");
        }
    }

    public void clear() {
        for (LoadedOntology loadedOntology : this.ontologies.values()) {
            loadedOntology.unload();
        }
        this.ontologyUris.clear();
        this.ontologies.clear();
    }
}

