/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.util;

import fr.inrialpes.exmo.align.impl.BasicOntologyNetwork;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.OntologyNetwork;

public class OntologyNetworkWeakener {
    public static OntologyNetwork unconnect(OntologyNetwork ontologyNetwork, int n) {
        return ontologyNetwork;
    }

    public static OntologyNetwork weakenAlignments(OntologyNetwork ontologyNetwork, double d, boolean bl) throws AlignmentException {
        if (d < 0.0 || d > 1.0) {
            throw new AlignmentException("Argument must be between 0 and 1.: " + d);
        }
        BasicOntologyNetwork basicOntologyNetwork = new BasicOntologyNetwork();
        for (URI uRI : ontologyNetwork.getOntologies()) {
            basicOntologyNetwork.addOntology(uRI);
        }
        for (URI uRI : ontologyNetwork.getAlignments()) {
            Alignment alignment = (Alignment)uRI.clone();
            if (bl) {
                alignment.cut("perc", 1.0 - d);
            } else {
                int n = alignment.nbCells();
                ArrayList<Cell> arrayList = new ArrayList<Cell>(n);
                for (Cell cell : alignment) {
                    arrayList.add(cell);
                }
                Collections.shuffle(arrayList);
                for (int i = (int)(d * (double)n) - 1; i >= 0; --i) {
                    alignment.remCell((Cell)arrayList.get(i));
                }
            }
            basicOntologyNetwork.addAlignment(alignment);
        }
        return basicOntologyNetwork;
    }

    public static OntologyNetwork dropAlignments(OntologyNetwork ontologyNetwork, double d) throws AlignmentException {
        System.err.println(" >>>> " + d);
        if (d < 0.0 || d > 1.0) {
            throw new AlignmentException("Argument must be between 0 and 1.: " + d);
        }
        BasicOntologyNetwork basicOntologyNetwork = new BasicOntologyNetwork();
        for (URI uRI : ontologyNetwork.getOntologies()) {
            basicOntologyNetwork.addOntology(uRI);
        }
        Set set = ontologyNetwork.getAlignments();
        int n = set.size();
        ArrayList<Alignment> arrayList = new ArrayList<Alignment>(n);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Alignment alignment = (Alignment)iterator.next();
            arrayList.add(alignment);
        }
        Collections.shuffle(arrayList);
        for (int i = n - (int)(d * (double)n); i > 0; --i) {
            basicOntologyNetwork.addAlignment((Alignment)arrayList.get(i));
        }
        return basicOntologyNetwork;
    }
}

