/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.util;

import fr.inrialpes.exmo.align.impl.BasicParameters;
import fr.inrialpes.exmo.align.impl.eval.PRecEvaluator;
import fr.inrialpes.exmo.align.parser.AlignmentParser;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Evaluator;

public class GroupOutput {
    static int SIZE = 16;
    static int[][] cellSpec = new int[][]{{101}, {201, 202, 203, 204, 205, 206, 207, 208, 209, 210}, {221}, {224}, {225, 228, 230, 231}, {232, 237, 238}, {233, 239, 240}, {236}, {249}, {248, 251, 252}, {250}, {241, 246, 247}, {253, 258, 259}, {257}, {254, 260, 261}, {262, 265, 266}};
    BasicParameters params = null;
    Vector<String> listAlgo;
    String fileNames = "";
    String outFile = null;
    String type = "tex";
    String color = null;
    int debug = 0;
    PrintWriter output = null;

    public static void main(String[] stringArray) {
        try {
            new GroupOutput().run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] stringArray) throws Exception {
        void var6_9;
        int n;
        LongOpt[] longOptArray = new LongOpt[8];
        longOptArray[0] = new LongOpt("help", 0, null, 104);
        longOptArray[1] = new LongOpt("output", 1, null, 111);
        longOptArray[2] = new LongOpt("color", 2, null, 99);
        longOptArray[3] = new LongOpt("type", 1, null, 116);
        longOptArray[4] = new LongOpt("debug", 2, null, 100);
        longOptArray[6] = new LongOpt("list", 1, null, 108);
        Getopt getopt = new Getopt("", stringArray, "ho:c::d::l:t:", longOptArray);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    this.usage();
                    return;
                }
                case 111: {
                    this.outFile = getopt.getOptarg();
                    break;
                }
                case 99: {
                    String string = getopt.getOptarg();
                    if (string != null) {
                        this.color = string.trim();
                        break;
                    }
                    this.color = "blue";
                    break;
                }
                case 116: {
                    this.type = getopt.getOptarg();
                    break;
                }
                case 108: {
                    this.fileNames = getopt.getOptarg();
                    break;
                }
                case 100: {
                    String string = getopt.getOptarg();
                    this.debug = string != null ? Integer.parseInt(string.trim()) : 4;
                }
            }
        }
        this.listAlgo = new Vector();
        for (String string : this.fileNames.split(",")) {
            this.listAlgo.add(string);
        }
        this.params = new BasicParameters();
        if (this.debug > 0) {
            this.params.setParameter("debug", Integer.toString(this.debug - 1));
        }
        this.params.setParameter("step", Integer.toString(SIZE));
        if (this.outFile == null) {
            PrintStream printStream = System.out;
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outFile);
        }
        this.output = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)var6_9, "UTF-8")), true);
        if (this.type.equals("tex")) {
            this.output.println("\\documentclass[11pt]{book}");
            this.output.println();
            this.output.println("\\usepackage{figureflt}");
            this.output.println("\\usepackage{pgf}");
            this.output.println("\\usepackage{tikz}");
            this.output.println("\\usepackage{pgflibraryshapes}");
            this.output.println();
            this.output.println("\\begin{document}");
            this.output.println("\\date{today}");
            this.output.println("");
        }
        this.iterateAlgorithm();
        if (this.type.equals("tex")) {
            this.output.println("\\end{document}");
            this.output.println();
        }
    }

    public void iterateAlgorithm() {
        for (String string : this.listAlgo) {
            if (this.debug > 0) {
                System.err.println("Algorithm: " + string);
            }
            if (this.type.equals("tex")) {
                this.printPGFTeX(string, this.iterateCells(string));
                continue;
            }
            System.err.println("Flag -t " + this.type + " : not implemented yet");
        }
    }

    public double[] iterateCells(String string) {
        double[] dArray = new double[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            dArray[i] = this.iterateTests(string, cellSpec[i]);
        }
        return dArray;
    }

    public double iterateTests(String string, int[] nArray) {
        File file = new File(System.getProperty("user.dir"));
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            if (this.debug > 1) {
                System.err.println("    tests: " + nArray[i]);
            }
            String string2 = file.toURI().toString() + "/" + nArray[i] + "/";
            try {
                PRecEvaluator pRecEvaluator = (PRecEvaluator)this.eval(string2 + "refalign.rdf", string2 + string + ".rdf");
                d += pRecEvaluator.getFmeasure();
                continue;
            }
            catch (AlignmentException alignmentException) {
                alignmentException.printStackTrace();
            }
        }
        OntologyFactory.clear();
        return d / (double)nArray.length;
    }

    public Evaluator eval(String string, String string2) throws AlignmentException {
        PRecEvaluator pRecEvaluator = null;
        int n = this.debug < 3 ? 0 : this.debug - 3;
        Alignment alignment = null;
        Alignment alignment2 = null;
        try {
            AlignmentParser alignmentParser = new AlignmentParser(n);
            alignment = alignmentParser.parse(string);
            if (this.debug > 2) {
                System.err.println(" Alignment structure1 parsed");
            }
            alignmentParser.initAlignment(null);
            alignment2 = alignmentParser.parse(string2);
            if (this.debug > 2) {
                System.err.println(" Alignment structure2 parsed");
            }
        }
        catch (Exception exception) {
            throw new AlignmentException("Cannot parse ", exception);
        }
        pRecEvaluator = new PRecEvaluator(alignment, alignment2);
        this.params.setParameter("debug", Integer.toString(n));
        pRecEvaluator.eval(this.params);
        return pRecEvaluator;
    }

    public void printPGFTeX(String string, double[] dArray) {
        this.output.println("\n%% Plot generated by GroupOutput of alignapi");
        this.output.println("\\begin{floatingigure}[r]{6.5cm}");
        this.output.println("\\begin{figure}[!h]");
        this.output.println("\\begin{center}");
        this.output.println("\\begin{tikzpicture}");
        this.output.println("\\draw (-.5,2.) node[anchor=east] {labels};");
        this.output.println("\\draw (0,2.) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[11]) + "] {" + this.stringFormat(dArray[11]) + "}; % l");
        this.output.println("\\draw (0,1.) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[5]) + "] {" + this.stringFormat(dArray[5]) + "}; % lp");
        this.output.println("\\draw (0.5,1.5) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[2]) + "] {" + this.stringFormat(dArray[2]) + "}; % lip");
        this.output.println("\\draw (1.,2.) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[6]) + "] {" + this.stringFormat(dArray[6]) + "}; %li");
        this.output.println("");
        this.output.println("\\draw (-.5,0.) node[anchor=east] {properties};");
        this.output.println("\\draw (-0.5,-0.5) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[9]) + "] {" + this.stringFormat(dArray[9]) + "}; % ip");
        this.output.println("\\draw (0,0) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[12]) + "] {" + this.stringFormat(dArray[12]) + "}; %p");
        this.output.println("\\draw (.5,.5) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[3]) + "] {" + this.stringFormat(dArray[3]) + "}; % lph");
        this.output.println("\\draw (1.,1.) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[0]) + "] {" + this.stringFormat(dArray[0]) + "}; % liph");
        this.output.println("\\draw (1.5,1.5) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[4]) + "] {" + this.stringFormat(dArray[4]) + "}; %hil");
        this.output.println("\\draw (2.,2.) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[14]) + "] {" + this.stringFormat(dArray[14]) + "}; %i");
        this.output.println("\\draw (2.5,2.0) node[anchor=west] {instances};");
        this.output.println("");
        this.output.println("\\draw (2.,1.) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[10]) + "] {" + this.stringFormat(dArray[10]) + "}; % hi");
        this.output.println("\\draw (1.5,0.5) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[1]) + "] {" + this.stringFormat(dArray[1]) + "}; % phi");
        this.output.println("\\draw (1.,0) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[8]) + "] {" + this.stringFormat(dArray[8]) + "}; % ph");
        this.output.println("\\draw (2.,0) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[13]) + "] {" + this.stringFormat(dArray[13]) + "}; % h");
        this.output.println("\\draw (2.5,0.) node[anchor=west] {hierarchy};");
        this.output.println("\\draw (2.5,-0.5) node[diamond,minimum size=.5cm" + this.colorFormat(dArray[7]) + "] {" + this.stringFormat(dArray[7]) + "}; % hl");
        this.output.println("\\end{tikzpicture} ");
        this.output.println("\\caption{" + string + " evaluation on F-measure (the darkest the best).}\\label{fig:diag" + string + "}");
        this.output.println("\\end{center}");
        this.output.println("\\end{floatingfigure}");
    }

    public void printTSV(double[][] dArray) {
    }

    public String stringFormat(double d) {
        String string;
        if (d != d) {
            string = "N";
        } else {
            int n = (int)(d * 100.0);
            int n2 = n % 100;
            if ((int)(d * 1000.0) % 10 >= 5) {
                ++n2;
            }
            if (n >= 100 || n2 >= 100) {
                string = "1.0";
            } else {
                string = ".";
                if (n2 < 10) {
                    string = string + "0";
                }
                string = string + n2;
            }
        }
        return string;
    }

    public String colorFormat(double d) {
        if (this.color == null) {
            return "";
        }
        return ",fill=" + this.color + "!" + (int)(d * 100.0);
    }

    public void usage() {
        System.out.println("usage: GenPlot [options]");
        System.out.println("options are:");
        System.out.println("\t--type=tsv|tex|(html|xml) -t tsv|tex|(html|xml)\tSpecifies the output format");
        System.out.println("\t--list=algo1,...,algon -l algo1,...,algon\tSequence of the filenames to consider");
        System.out.println("\t--color=color -c color\tSpecifies if the output must color even lines of the output");
        System.out.println("\t--debug[=n] -d [n]\t\tReport debug info at level n");
        System.out.println("\t--help -h\t\t\tPrint this message");
    }
}

