/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.util;

import fr.inrialpes.exmo.align.impl.BasicParameters;
import fr.inrialpes.exmo.align.impl.eval.PRecEvaluator;
import fr.inrialpes.exmo.align.parser.AlignmentParser;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Vector;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.Evaluator;

public class GroupEval {
    BasicParameters params = null;
    String filename = null;
    String reference = "refalign.rdf";
    String format = "pr";
    int fsize = 2;
    String type = "html";
    boolean embedded = false;
    String dominant = "s";
    Vector<String> listAlgo = null;
    int debug = 0;
    String color = null;
    String ontoDir = null;

    public static void main(String[] stringArray) {
        try {
            new GroupEval().run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run(String[] stringArray) throws Exception {
        int n;
        String string = "";
        LongOpt[] longOptArray = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("output", 1, null, 111), new LongOpt("format", 1, null, 102), new LongOpt("type", 1, null, 116), new LongOpt("debug", 2, null, 100), new LongOpt("sup", 1, null, 115), new LongOpt("list", 1, null, 108), new LongOpt("color", 2, null, 99), new LongOpt("reference", 1, null, 114), new LongOpt("directory", 1, null, 119)};
        Getopt getopt = new Getopt("", stringArray, "ho:a:d::l:f:t:r:w:c::", longOptArray);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    this.usage();
                    return;
                }
                case 111: {
                    this.filename = getopt.getOptarg();
                    break;
                }
                case 114: {
                    this.reference = getopt.getOptarg();
                    break;
                }
                case 102: {
                    this.format = getopt.getOptarg();
                    break;
                }
                case 116: {
                    this.type = getopt.getOptarg();
                    break;
                }
                case 115: {
                    this.dominant = getopt.getOptarg();
                    break;
                }
                case 99: {
                    String string2 = getopt.getOptarg();
                    if (string2 != null) {
                        this.color = string2.trim();
                        break;
                    }
                    this.color = "lightblue";
                    break;
                }
                case 108: {
                    string = getopt.getOptarg();
                    break;
                }
                case 100: {
                    String string2 = getopt.getOptarg();
                    if (string2 != null) {
                        this.debug = Integer.parseInt(string2.trim());
                        break;
                    }
                    this.debug = 4;
                    break;
                }
                case 119: {
                    String string2 = getopt.getOptarg();
                    this.ontoDir = string2 != null ? getopt.getOptarg() : null;
                }
            }
        }
        this.listAlgo = new Vector();
        for (String string3 : string.split(",")) {
            this.listAlgo.add(string3);
        }
        this.params = new BasicParameters();
        if (this.debug > 0) {
            this.params.setParameter("debug", Integer.toString(this.debug - 1));
        }
        this.print(this.iterateDirectories());
    }

    public Vector<Vector> iterateDirectories() {
        Vector<Vector> vector = null;
        Object[] objectArray = null;
        try {
            objectArray = this.ontoDir == null ? new File(System.getProperty("user.dir")).listFiles() : new File(this.ontoDir).listFiles();
        }
        catch (Exception exception) {
            System.err.println("Cannot stat dir " + exception.getMessage());
            this.usage();
        }
        int n = objectArray.length;
        Arrays.sort(objectArray);
        vector = new Vector<Vector>(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Vector<Object> vector2;
            if (!((File)objectArray[i]).isDirectory()) continue;
            if (this.debug > 0) {
                System.err.println("\nEntering directory " + objectArray[i]);
            }
            if ((vector2 = this.iterateAlignments((File)objectArray[i])) == null) continue;
            vector.add(n2, vector2);
            ++n2;
        }
        return vector;
    }

    public Vector<Object> iterateAlignments(File file) {
        String string = file.toURI().toString() + "/";
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        vector.add(0, file.getName().toString());
        int n = 0;
        for (String string2 : this.listAlgo) {
            Evaluator evaluator;
            ++n;
            if (this.debug > 2) {
                System.err.println("  Considering result " + n);
            }
            if ((evaluator = this.eval(string + this.reference, string + string2 + ".rdf")) != null) {
                bl = true;
            }
            vector.add(n, evaluator);
        }
        OntologyFactory.clear();
        if (bl) {
            return vector;
        }
        return null;
    }

    public Evaluator eval(String string, String string2) {
        PRecEvaluator pRecEvaluator = null;
        try {
            int n = this.debug < 2 ? 0 : this.debug - 2;
            AlignmentParser alignmentParser = new AlignmentParser(n);
            Alignment alignment = alignmentParser.parse(string);
            if (this.debug > 2) {
                System.err.println(" Alignment structure1 parsed");
            }
            alignmentParser.initAlignment(null);
            Alignment alignment2 = alignmentParser.parse(string2);
            if (this.debug > 2) {
                System.err.println(" Alignment structure2 parsed");
            }
            pRecEvaluator = new PRecEvaluator(alignment, alignment2);
            this.params.setParameter("debug", Integer.toString(n));
            pRecEvaluator.eval(this.params);
        }
        catch (Exception exception) {
            if (this.debug > 1) {
                exception.printStackTrace();
            }
            System.err.println("GroupEval: " + exception);
            System.err.println(string + " - " + string2);
        }
        return pRecEvaluator;
    }

    public void print(Vector<Vector> vector) {
        if (this.type.equals("html")) {
            this.printHTML(vector);
        } else if (this.type.equals("tex")) {
            this.printLATEX(vector);
        } else if (this.type.equals("triangle")) {
            this.printTRIANGLE(vector);
        }
    }

    public void printTRIANGLE(Vector<Vector> vector) {
        int n = 0;
        int[] nArray = new int[this.listAlgo.size()];
        int[] nArray2 = new int[this.listAlgo.size()];
        long[] lArray = new long[this.listAlgo.size()];
        for (int i = this.listAlgo.size() - 1; i >= 0; --i) {
            nArray[i] = 0;
            nArray2[i] = 0;
            lArray[i] = 0L;
        }
        for (Vector object : vector) {
            int n2 = -1;
            Enumeration d = object.elements();
            d.nextElement();
            int n3 = 0;
            while (d.hasMoreElements()) {
                PRecEvaluator d2 = (PRecEvaluator)d.nextElement();
                if (d2 != null) {
                    if (n2 == -1) {
                        n2 = 0;
                        n += d2.getExpected();
                    }
                    int n4 = n3;
                    nArray[n4] = nArray[n4] + d2.getFound();
                    int n5 = n3;
                    nArray2[n5] = nArray2[n5] + d2.getCorrect();
                    int n6 = n3;
                    lArray[n6] = lArray[n6] + d2.getTime();
                }
                ++n3;
            }
        }
        System.out.println("\\documentclass[11pt]{book}");
        System.out.println();
        System.out.println("\\usepackage{pgf}");
        System.out.println("\\usepackage{tikz}");
        System.out.println();
        System.out.println("\\begin{document}");
        System.out.println("\\date{today}");
        System.out.println("");
        System.out.println("\n%% Plot generated by GenPlot of alignapi");
        System.out.println("\\begin{tikzpicture}[cap=round]");
        System.out.println("% Draw grid");
        System.out.println("\\draw[step=1cm,very thin,color=gray] (-0.2,-0.2) grid (10.0,9.0);");
        System.out.println("\\draw[|-|] (-0,0) -- (10,0);");
        System.out.println("%\\draw[dashed,very thin] (0,0) -- (5,8.66) -- (10,0);");
        System.out.println("\\draw[dashed,very thin] (10,0) arc (0:60:10cm);");
        System.out.println("\\draw[dashed,very thin] (0,0) arc (180:120:10cm);");
        System.out.println("\\draw (0,-0.3) node {$recall$}; ");
        System.out.println("\\draw (10,-0.3) node {$precision$}; ");
        System.out.println("% Plots");
        int n7 = 0;
        for (String string : this.listAlgo) {
            double d = (double)nArray2[n7] / (double)nArray[n7];
            double d2 = (double)nArray2[n7] / (double)n;
            double d3 = d * d;
            double d4 = (d3 - d2 * d2 + 1.0) / 2.0;
            double d5 = Math.sqrt(d3 - d4 * d4);
            System.out.println("\\draw plot[mark=+,] coordinates {(" + (d4 *= 10.0) + "," + (d5 *= 10.0) + ")};");
            System.out.println("\\draw (" + (d4 + 0.01) + "," + (d5 + 0.01) + ") node[anchor=south west] {" + string + "};");
            ++n7;
        }
        System.out.println("\\end{tikzpicture}");
        System.out.println();
        System.out.println("\\end{document}");
    }

    public void printLATEX(Vector vector) {
    }

    /*
     * WARNING - void declaration
     */
    public void printHTML(Vector<Vector> vector) {
        int n = 0;
        PrintStream printStream = null;
        this.fsize = this.format.length();
        try {
            int n2;
            printStream = this.filename == null ? System.out : new PrintStream(new FileOutputStream(this.filename));
            Formatter formatter = new Formatter(printStream);
            if (!this.embedded) {
                printStream.println("<html><head></head><body>");
            }
            printStream.println("<table border='2' frame='sides' rules='groups'>");
            printStream.println("<colgroup align='center' />");
            for (String object : this.listAlgo) {
                printStream.println("<colgroup align='center' span='" + this.fsize + "' />");
            }
            printStream.println("<thead valign='top'><tr><th>algo</th>");
            for (String string : this.listAlgo) {
                printStream.println("<th colspan='" + this.fsize + "'>" + string + "</th>");
            }
            printStream.println("</tr></thead><tbody><tr><td>test</td>");
            for (String string : this.listAlgo) {
                for (int i = 0; i < this.fsize; ++i) {
                    printStream.print("<td>");
                    if (this.format.charAt(i) == 'p') {
                        printStream.print("Prec.");
                    } else if (this.format.charAt(i) == 'r') {
                        printStream.print("Rec.");
                    } else if (this.format.charAt(i) == 'f') {
                        printStream.print("Fall.");
                    } else if (this.format.charAt(i) == 'm') {
                        printStream.print("FMeas.");
                    } else if (this.format.charAt(i) == 'o') {
                        printStream.print("Over.");
                    } else if (this.format.charAt(i) == 't') {
                        printStream.print("Time");
                    }
                    printStream.println("</td>");
                }
            }
            printStream.println("</tr></tbody><tbody>");
            int[] nArray = new int[this.listAlgo.size()];
            int[] nArray2 = new int[this.listAlgo.size()];
            long[] lArray = new long[this.listAlgo.size()];
            for (n2 = this.listAlgo.size() - 1; n2 >= 0; --n2) {
                nArray[n2] = 0;
                nArray2[n2] = 0;
                lArray[n2] = 0L;
            }
            n2 = 0;
            for (Vector vector2 : vector) {
                int n3 = -1;
                if (n2 == 1 && this.color != null) {
                    n2 = 0;
                    printStream.println("<tr bgcolor=\"" + this.color + "\">");
                } else {
                    n2 = 1;
                    printStream.println("<tr>");
                }
                printStream.println("<td>" + (String)vector2.get(0) + "</td>");
                Enumeration enumeration = vector2.elements();
                enumeration.nextElement();
                int n4 = 0;
                while (enumeration.hasMoreElements()) {
                    PRecEvaluator pRecEvaluator = (PRecEvaluator)enumeration.nextElement();
                    if (pRecEvaluator != null) {
                        if (n3 == -1) {
                            n += pRecEvaluator.getExpected();
                            n3 = 0;
                        }
                        int n5 = n4;
                        nArray[n5] = nArray[n5] + pRecEvaluator.getFound();
                        int n6 = n4;
                        nArray2[n6] = nArray2[n6] + pRecEvaluator.getCorrect();
                        int n7 = n4;
                        lArray[n7] = lArray[n7] + pRecEvaluator.getTime();
                        for (int i = 0; i < this.fsize; ++i) {
                            printStream.print("<td>");
                            if (this.format.charAt(i) == 'p') {
                                formatter.format("%1.2f", pRecEvaluator.getPrecision());
                            } else if (this.format.charAt(i) == 'r') {
                                formatter.format("%1.2f", pRecEvaluator.getRecall());
                            } else if (this.format.charAt(i) == 'f') {
                                formatter.format("%1.2f", pRecEvaluator.getFallout());
                            } else if (this.format.charAt(i) == 'm') {
                                formatter.format("%1.2f", pRecEvaluator.getFmeasure());
                            } else if (this.format.charAt(i) == 'o') {
                                formatter.format("%1.2f", pRecEvaluator.getOverall());
                            } else if (this.format.charAt(i) == 't') {
                                if (pRecEvaluator.getTime() == 0L) {
                                    printStream.print("-");
                                } else {
                                    formatter.format("%1.2f", pRecEvaluator.getTime());
                                }
                            }
                            printStream.println("</td>");
                        }
                    } else {
                        printStream.println("<td>n/a</td><td>n/a</td>");
                    }
                    ++n4;
                }
                printStream.println("</tr>");
            }
            printStream.print("<tr bgcolor=\"yellow\"><td>H-mean</td>");
            boolean bl = false;
            for (String string : this.listAlgo) {
                void var9_15;
                double d = (double)nArray2[var9_15] / (double)nArray[var9_15];
                double d2 = (double)nArray2[var9_15] / (double)n;
                for (int i = 0; i < this.fsize; ++i) {
                    printStream.print("<td>");
                    if (this.format.charAt(i) == 'p') {
                        formatter.format("%1.2f", d);
                    } else if (this.format.charAt(i) == 'r') {
                        formatter.format("%1.2f", d2);
                    } else if (this.format.charAt(i) == 'f') {
                        formatter.format("%1.2f", (double)(nArray[var9_15] - nArray2[var9_15]) / (double)nArray[var9_15]);
                    } else if (this.format.charAt(i) == 'm') {
                        formatter.format("%1.2f", 2.0 * d * d2 / (d + d2));
                    } else if (this.format.charAt(i) == 'o') {
                        formatter.format("%1.2f", d2 * (2.0 - 1.0 / d));
                    } else if (this.format.charAt(i) == 't') {
                        if (lArray[var9_15] == 0L) {
                            printStream.print("-");
                        } else {
                            formatter.format("%1.2f", lArray[var9_15]);
                        }
                    }
                    printStream.println("</td>");
                }
                ++var9_15;
            }
            printStream.println("</tr>");
            printStream.println("</tbody></table>");
            printStream.println("<p><small>n/a: result alignment not provided or not readable<br />");
            printStream.println("NaN: division per zero, likely due to empty alignment.</small></p>");
            if (!this.embedded) {
                printStream.println("</body></html>");
            }
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void usage() {
        System.out.println("usage: GroupEval [options]");
        System.out.println("options are:");
        System.out.println("\t--format=prfmot -r prfmot\tSpecifies the output order (precision/recall/fallout/f-measure/overall/time)");
        System.out.println("\t--output=filename -o filename\tSpecifies a file to which the output will go");
        System.out.println("\t--reference=filename -r filename\tSpecifies the name of the reference alignment file (default: refalign.rdf)");
        System.out.println("\t--type=html|xml|tex|ascii|triangle -t html|xml|tex|ascii\tSpecifies the output format");
        System.out.println("\t--list=algo1,...,algon -l algo1,...,algon\tSequence of the filenames to consider");
        System.out.println("\t--color=color -c color\tSpecifies if the output must color even lines of the output");
        System.out.println("\t--debug[=n] -d [n]\t\tReport debug info at level n");
        System.out.println("\t--help -h\t\t\tPrint this message");
        System.err.print("\n" + GroupEval.class.getPackage().getImplementationTitle() + " " + GroupEval.class.getPackage().getImplementationVersion());
        System.err.println(" ($Id: GroupEval.java 1353 2010-03-24 23:49:46Z euzenat $)\n");
    }
}

