/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.util;

import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.BasicParameters;
import fr.inrialpes.exmo.align.impl.Namespace;
import fr.inrialpes.exmo.align.parser.AlignmentParser;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentProcess;
import org.semanticweb.owl.align.AlignmentVisitor;

public class GroupAlign {
    BasicParameters params = null;
    String filename = "align";
    String paramfile = null;
    String urlprefix = null;
    String source = "onto1.rdf";
    String target = "onto.rdf";
    URI uri1 = null;
    String initName = null;
    int debug = 0;
    String alignmentClassName = "fr.inrialpes.exmo.align.impl.method.StringDistAlignment";
    String rendererClass = "fr.inrialpes.exmo.align.impl.renderer.RDFRendererVisitor";
    String ontoDir = null;

    public static void main(String[] stringArray) {
        try {
            new GroupAlign().run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run(String[] stringArray) throws Exception {
        int n;
        LongOpt[] longOptArray = new LongOpt[13];
        this.params = new BasicParameters();
        longOptArray[0] = new LongOpt("help", 0, null, 104);
        longOptArray[1] = new LongOpt("output", 1, null, 111);
        longOptArray[2] = new LongOpt("alignment", 1, null, 97);
        longOptArray[3] = new LongOpt("renderer", 1, null, 114);
        longOptArray[4] = new LongOpt("debug", 2, null, 100);
        longOptArray[5] = new LongOpt("impl", 1, null, 105);
        longOptArray[6] = new LongOpt("params", 1, null, 112);
        longOptArray[7] = new LongOpt("name", 1, null, 110);
        longOptArray[8] = new LongOpt("prefix", 1, null, 117);
        longOptArray[9] = new LongOpt("source", 1, null, 115);
        longOptArray[10] = new LongOpt("target", 1, null, 116);
        longOptArray[11] = new LongOpt("D", 1, null, 68);
        longOptArray[12] = new LongOpt("directory", 1, null, 119);
        Getopt getopt = new Getopt("", stringArray, "ho:a:d::n:u:r:i:s:t:p:D:w:", longOptArray);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    this.usage();
                    return;
                }
                case 111: {
                    this.filename = getopt.getOptarg();
                    break;
                }
                case 110: {
                    String string = getopt.getOptarg();
                    if (string != null) {
                        try {
                            this.uri1 = new URI(getopt.getOptarg());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                    this.uri1 = null;
                    break;
                }
                case 112: {
                    this.paramfile = getopt.getOptarg();
                    BasicParameters.read(this.params, this.paramfile);
                    break;
                }
                case 114: {
                    this.rendererClass = getopt.getOptarg();
                    break;
                }
                case 105: {
                    this.alignmentClassName = getopt.getOptarg();
                    break;
                }
                case 97: {
                    this.initName = getopt.getOptarg();
                    break;
                }
                case 117: {
                    this.urlprefix = getopt.getOptarg();
                    break;
                }
                case 115: {
                    this.source = getopt.getOptarg();
                    break;
                }
                case 116: {
                    this.target = getopt.getOptarg();
                    break;
                }
                case 68: {
                    String string = getopt.getOptarg();
                    int n2 = string.indexOf(61);
                    if (n2 != -1) {
                        this.params.setParameter(string.substring(0, n2), string.substring(n2 + 1));
                        break;
                    }
                    System.err.println("Bad parameter syntax: " + getopt);
                    this.usage();
                    System.exit(0);
                    break;
                }
                case 100: {
                    String string = getopt.getOptarg();
                    if (string != null) {
                        this.debug = Integer.parseInt(string.trim());
                        break;
                    }
                    this.debug = 4;
                    break;
                }
                case 119: {
                    String string = getopt.getOptarg();
                    this.ontoDir = string != null ? getopt.getOptarg() : null;
                }
            }
        }
        if (this.debug == 0 && this.params.getParameter("debug") != null) {
            this.debug = Integer.parseInt(this.params.getParameter("debug"));
        }
        if (this.debug > 0) {
            this.params.setParameter("debug", Integer.toString(this.debug - 1));
        }
        this.iterateDirectories();
    }

    public void iterateDirectories() {
        File[] fileArray = null;
        try {
            fileArray = this.ontoDir == null ? new File(System.getProperty("user.dir")).listFiles() : new File(this.ontoDir).listFiles();
        }
        catch (Exception exception) {
            System.err.println("Cannot stat dir " + exception.getMessage());
            this.usage();
        }
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            try {
                if (this.debug > 0) {
                    System.err.println("Directory: " + fileArray[i]);
                }
                this.align(fileArray[i]);
                OntologyFactory.clear();
                continue;
            }
            catch (Exception exception) {
                if (this.debug <= 1) continue;
                exception.printStackTrace();
            }
        }
    }

    public void align(File file) throws Exception {
        String string = null;
        AlignmentProcess alignmentProcess = null;
        Alignment alignment = null;
        string = this.urlprefix != null ? this.urlprefix + "/" + file.getName() + "/" : file.toURI().toString();
        BasicConfigurator.configure();
        if (this.uri1 == null) {
            this.uri1 = new URI(string + this.source);
        }
        if (!this.source.equalsIgnoreCase("onto1.rdf") && !this.target.equalsIgnoreCase("onto1.rdf")) {
            this.uri1 = new URI(string + this.source);
        }
        URI uRI = new URI(string + this.target);
        if (this.debug > 1) {
            System.err.println(" Handler set");
        }
        if (this.debug > 1) {
            System.err.println(" URI1: " + this.uri1);
        }
        if (this.debug > 1) {
            System.err.println(" URI2: " + uRI);
        }
        try {
            Object object;
            if (this.initName != null) {
                object = new AlignmentParser(this.debug - 1);
                alignment = ((AlignmentParser)object).parse(this.initName);
                this.uri1 = alignment.getFile1();
                uRI = alignment.getFile2();
                if (this.debug > 1) {
                    System.err.println(" Init parsed");
                }
            }
            object = new Object[]{};
            Class[] classArray = new Class[]{};
            Class<?> clazz = Class.forName(this.alignmentClassName);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            alignmentProcess = (AlignmentProcess)constructor.newInstance((Object[])object);
            alignmentProcess.init((Object)this.uri1, (Object)uRI);
        }
        catch (Exception exception) {
            System.err.println("Cannot create alignment " + this.alignmentClassName + "\n" + exception.getMessage());
            throw exception;
        }
        if (this.debug > 1) {
            System.err.println(" Alignment structure created");
        }
        long l = System.currentTimeMillis();
        alignmentProcess.align(alignment, (Properties)this.params);
        long l2 = System.currentTimeMillis();
        alignmentProcess.setExtension(Namespace.ALIGNMENT.uri, Annotations.TIME, Long.toString(l2 - l));
        if (this.debug > 1) {
            System.err.println(" Alignment performed");
        }
        PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file + File.separator + this.filename + ".rdf"), "UTF-8")), true);
        AlignmentVisitor alignmentVisitor = null;
        try {
            Object[] objectArray = new Object[]{printWriter};
            Class[] classArray = new Class[]{Class.forName("java.io.PrintWriter")};
            Constructor<?> constructor = Class.forName(this.rendererClass).getConstructor(classArray);
            alignmentVisitor = (AlignmentVisitor)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            System.err.println("Cannot create renderer " + this.rendererClass + "\n" + exception.getMessage());
            throw exception;
        }
        if (this.debug > 1) {
            System.err.println(" Outputing result to " + file + File.separator + this.filename + ".rdf");
        }
        alignmentProcess.render(alignmentVisitor);
        if (this.debug > 1) {
            System.err.println(" Done..." + alignmentVisitor + "\n");
        }
        printWriter.close();
    }

    public void usage() {
        System.err.println("usage: GroupAlign [options]");
        System.err.println("options are:");
        System.err.println("\t--name=uri -n uri\t\tUse the given uri to compare with.");
        System.err.println("\t--source=filename -s filename Source filename (default onto1.rdf)");
        System.err.println("\t--target=filename -t filename Target filename (default onto.rdf)");
        System.err.println("\t--prefix=uriprefix -u uriprefix URI prefix of the target");
        System.err.println("\t--output=filename -o filename\tOutput the alignment in filename.rdf");
        System.err.println("\t--impl=className -i classname\t\tUse the given alignment implementation.");
        System.err.println("\t--renderer=className -r className\tSpecifies the alignment renderer");
        System.err.println("\t--alignment=filename -a filename Start from an XML alignment file");
        System.err.println("\t--params=filename -p filename\tReads parameters from filename");
        System.err.println("\t-Dparam=value\t\t\tSet parameter");
        System.err.println("\t--debug[=n] -d [n]\t\tReport debug info at level n");
        System.err.println("\t--help -h\t\t\tPrint this message");
        System.err.print("\n" + GroupAlign.class.getPackage().getImplementationTitle() + " " + GroupAlign.class.getPackage().getImplementationVersion());
        System.err.println(" ($Id: GroupAlign.java 1286 2010-03-07 18:22:12Z euzenat $)\n");
    }
}

