/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.util;

import fr.inrialpes.exmo.align.impl.eval.GraphEvaluator;
import fr.inrialpes.exmo.align.impl.eval.Pair;
import fr.inrialpes.exmo.align.parser.AlignmentParser;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.Vector;
import org.semanticweb.owl.align.Alignment;

public class GenPlot {
    int STEP = 10;
    Properties params = null;
    Vector<String> listAlgo;
    Vector<GraphEvaluator> listEvaluators;
    String fileNames = "";
    String outFile = null;
    Constructor evalConstructor = null;
    Constructor graphConstructor = null;
    String ylabel = "precision";
    String xlabel = "recall";
    String type = "tsv";
    int debug = 0;
    int size = 0;
    PrintWriter output = null;

    public static void main(String[] stringArray) {
        try {
            new GenPlot().run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run(String[] stringArray) throws Exception {
        int n;
        int n2;
        LongOpt[] longOptArray = new LongOpt[10];
        longOptArray[0] = new LongOpt("help", 0, null, 104);
        longOptArray[1] = new LongOpt("output", 1, null, 111);
        longOptArray[3] = new LongOpt("type", 1, null, 116);
        longOptArray[4] = new LongOpt("debug", 2, null, 100);
        longOptArray[5] = new LongOpt("evaluator", 1, null, 101);
        longOptArray[6] = new LongOpt("grapher", 1, null, 103);
        longOptArray[7] = new LongOpt("list", 1, null, 108);
        longOptArray[8] = new LongOpt("step", 1, null, 115);
        Getopt getopt = new Getopt("", stringArray, "ho:d::l:e:g:s:t:", longOptArray);
        int n3 = 10;
        String string = "fr.inrialpes.exmo.align.impl.eval.PRecEvaluator";
        String string2 = "fr.inrialpes.exmo.align.impl.eval.PRGraphEvaluator";
        while ((n2 = getopt.getopt()) != -1) {
            switch (n2) {
                case 104: {
                    this.usage();
                    return;
                }
                case 111: {
                    this.outFile = getopt.getOptarg();
                    break;
                }
                case 101: {
                    string = getopt.getOptarg();
                    break;
                }
                case 103: {
                    string2 = getopt.getOptarg();
                    if (!string2.equals("fr.inrialpes.exmo.align.impl.eval.ROCCurveEvaluator")) break;
                    this.xlabel = "noise";
                    this.ylabel = "recall";
                    break;
                }
                case 116: {
                    this.type = getopt.getOptarg();
                    break;
                }
                case 108: {
                    this.fileNames = getopt.getOptarg();
                    break;
                }
                case 115: {
                    this.fileNames = getopt.getOptarg();
                    break;
                }
                case 100: {
                    String string3 = getopt.getOptarg();
                    this.debug = string3 != null ? Integer.parseInt(string3.trim()) : 4;
                }
            }
        }
        Class<?> clazz = Class.forName(string2);
        Class[] classArray = new Class[]{};
        this.graphConstructor = clazz.getConstructor(classArray);
        this.listAlgo = new Vector();
        String[] stringArray2 = this.fileNames.split(",");
        int n4 = stringArray2.length;
        for (n = 0; n < n4; ++n) {
            String string4 = stringArray2[n];
            ++this.size;
            this.listAlgo.add(string4);
        }
        this.params = new Properties();
        if (this.debug > 0) {
            this.params.setProperty("debug", Integer.toString(this.debug - 1));
        }
        this.listEvaluators = this.iterateDirectories();
        int n5 = 0;
        for (GraphEvaluator graphEvaluator : this.listEvaluators) {
            int n6 = graphEvaluator.nbCells();
            if (n6 <= n5) continue;
            n5 = n6;
        }
        this.params.setProperty("scale", Integer.toString(n5));
        Vector vector = new Vector();
        for (n = 0; n < this.size; ++n) {
            vector.add(n, this.listEvaluators.get(n).eval(this.params));
        }
        OutputStream outputStream = this.outFile == null ? System.out : new FileOutputStream(this.outFile);
        this.output = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")), true);
        if (this.type.equals("tsv")) {
            this.printTSV(vector);
        } else if (this.type.equals("tex")) {
            this.printPGFTex(vector);
        } else {
            System.err.println("Flag -t " + this.type + " : not implemented yet");
        }
    }

    public Vector<GraphEvaluator> iterateDirectories() {
        Vector<GraphEvaluator> vector = new Vector<GraphEvaluator>(this.size);
        Object[] objectArray = new Object[]{};
        try {
            for (int i = 0; i < this.size; ++i) {
                GraphEvaluator graphEvaluator = (GraphEvaluator)this.graphConstructor.newInstance(objectArray);
                graphEvaluator.setStep(this.STEP);
                vector.add(i, graphEvaluator);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        File[] fileArray = null;
        try {
            fileArray = new File(System.getProperty("user.dir")).listFiles();
        }
        catch (Exception exception) {
            System.err.println("Cannot stat dir " + exception.getMessage());
            this.usage();
        }
        for (int i = fileArray.length - 1; i >= 0; --i) {
            if (!fileArray[i].isDirectory()) continue;
            this.iterateAlignments(fileArray[i], vector);
        }
        return vector;
    }

    public void iterateAlignments(File file, Vector<GraphEvaluator> vector) {
        if (this.debug > 0) {
            System.err.println("Directory : " + file);
        }
        String string = file.toURI().toString() + "/";
        int n = this.debug < 2 ? 0 : this.debug - 2;
        AlignmentParser alignmentParser = new AlignmentParser(n);
        Alignment alignment = null;
        try {
            alignment = alignmentParser.parse(string + "refalign.rdf");
            if (this.debug > 1) {
                System.err.println(" Reference alignment parsed");
            }
        }
        catch (Exception exception) {
            if (this.debug > 1) {
                exception.printStackTrace();
            } else {
                System.err.println("GenPlot cannot parse refalign : " + exception);
            }
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            String string2 = this.listAlgo.get(i);
            Alignment alignment2 = null;
            if (this.debug > 0) {
                System.err.println("  Considering result " + string2 + " (" + i + ")");
            }
            try {
                alignmentParser.initAlignment(null);
                alignment2 = alignmentParser.parse(string + string2 + ".rdf");
                if (this.debug > 1) {
                    System.err.println(" Alignment " + string2 + " parsed");
                }
            }
            catch (Exception exception) {
                if (this.debug > 1) {
                    exception.printStackTrace();
                }
                System.err.println("GenPlot: " + exception);
            }
            vector.get(i).ingest(alignment2, alignment);
        }
        OntologyFactory.clear();
    }

    public Vector<Pair> scaleResults(int n, Vector<Pair> vector) {
        boolean bl = false;
        Vector<Pair> vector2 = new Vector<Pair>();
        Pair pair = null;
        double d = 0.0;
        for (Pair pair2 : vector) {
            if (pair2.getX() == d) {
                vector2.add(pair2);
                d += (double)n;
            } else if (pair2.getX() >= d) {
                double d2 = pair.getY() >= pair2.getY() ? pair2.getY() + (pair.getY() - pair2.getY()) / (pair.getX() - pair2.getX()) : pair.getY() + (pair2.getY() - pair.getY()) / (pair.getX() - pair2.getX());
                vector2.add(new Pair(d, d2));
                d += (double)n;
            }
            pair = pair2;
        }
        vector2.add(pair);
        return vector2;
    }

    public void printPGFTex(Vector<Vector<Pair>> vector) {
        int n = 0;
        String[] stringArray = new String[]{"+", "*", "x", "-", "|", "o", "asterisk", "star", "oplus", "oplus*", "otimes", "otimes*", "square", "square*", "triangle", "triangle*", "diamond", "diamond*", "pentagon", "pentagon*"};
        String[] stringArray2 = new String[]{"black", "red", "green", "blue", "cyan", "magenta", "yellow"};
        this.output.println("\\documentclass[11pt]{book}");
        this.output.println();
        this.output.println("\\usepackage{pgf}");
        this.output.println("\\usepackage{tikz}");
        this.output.println("\\usetikzlibrary{plotmarks}");
        this.output.println();
        this.output.println("\\begin{document}");
        this.output.println("\\date{today}");
        this.output.println("");
        this.output.println("\n%% Plot generated by GenPlot of alignapi");
        this.output.println("\\begin{tikzpicture}[cap=round]");
        this.output.println("% Draw grid");
        this.output.println("\\draw[step=" + this.STEP / 10 + "cm,very thin,color=gray] (-0.2,-0.2) grid (" + this.STEP + "," + this.STEP + ");");
        this.output.println("\\draw[->] (-0.2,0) -- (10.2,0);");
        this.output.println("\\draw (5,-0.3) node {$" + this.xlabel + "$}; ");
        this.output.println("\\draw (0,-0.3) node {0.}; ");
        this.output.println("\\draw (10,-0.3) node {1.}; ");
        this.output.println("\\draw[->] (0,-0.2) -- (0,10.2);");
        this.output.println("\\draw (-0.3,0) node {0.}; ");
        this.output.println("\\draw (-0.3,5) node[rotate=90] {$" + this.ylabel + "$}; ");
        this.output.println("\\draw (-0.3,10) node {1.}; ");
        this.output.println("% Plots");
        for (String object : this.listAlgo) {
            this.output.println("\\draw[" + stringArray2[n % 7] + "] plot[mark=" + stringArray[n % 19] + "] file {" + object + ".table};");
            ++n;
        }
        this.output.println("% Legend");
        n = 0;
        for (String string : this.listAlgo) {
            this.output.println("\\draw[" + stringArray2[n % 7] + "] plot[mark=" + stringArray[n % 19] + "] coordinates {(" + (n % 3 * 3 + 1) + "," + ((double)(-(n / 3)) * 0.8 - 1.0) + ") (" + (n % 3 * 3 + 3) + "," + ((double)(-(n / 3)) * 0.8 - 1.0) + ")};");
            this.output.println("\\draw[" + stringArray2[n % 7] + "] (" + (n % 3 * 3 + 2) + "," + ((double)(-(n / 3)) * 0.8 - 0.8) + ") node {" + string + "};");
            this.output.printf("\\draw[" + stringArray2[n % 7] + "] (" + (n % 3 * 3 + 2) + "," + ((double)(-(n / 3)) * 0.8 - 1.2) + ") node {%1.2f};\n", this.listEvaluators.get(n).getGlobalResult());
            ++n;
        }
        this.output.println("\\end{tikzpicture}");
        this.output.println();
        this.output.println("\\end{document}");
        n = 0;
        for (Vector vector2 : vector) {
            String string = this.listAlgo.get(n);
            try {
                PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string + ".table"), "UTF-8")), true);
                printWriter.println("#Curve 0, " + (this.STEP + 1) + " points");
                printWriter.println("#x y type");
                printWriter.println("%% Plot generated by GenPlot of alignapi");
                printWriter.println("%% Include in PGF tex by:\n");
                printWriter.println("%% \\begin{tikzpicture}[cap=round]");
                printWriter.println("%% \\draw[step=" + this.STEP / 10 + "cm,very thin,color=gray] (-0.2,-0.2) grid (" + this.STEP + "," + this.STEP + ");");
                printWriter.println("%% \\draw[->] (-0.2,0) -- (10.2,0) node[right] {$recall$}; ");
                printWriter.println("%% \\draw[->] (0,-0.2) -- (0,10.2) node[above] {$precision$}; ");
                printWriter.println("%% \\draw plot[mark=+,smooth] file {" + string + ".table};");
                printWriter.println("%% \\end{tikzpicture}");
                printWriter.println();
                for (Pair pair : vector2) {
                    if (this.debug > 1) {
                        System.err.println(" >> " + pair.getX() + " - " + pair.getY());
                    }
                    printWriter.println(pair.getX() * 10.0 + " " + pair.getY() * 10.0);
                }
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    public void printTSV(Vector<Vector<Pair>> vector) {
        for (String string : this.listAlgo) {
            this.output.print("\t" + string);
        }
        for (int i = 0; i < 100; i += this.STEP) {
            for (int j = 0; j < this.size; ++j) {
                Pair pair = vector.get(j).get(i);
                this.output.println(pair.getX() + " " + pair.getY());
            }
        }
        this.output.println();
    }

    public void usage() {
        System.out.println("usage: GenPlot [options]");
        System.out.println("options are:");
        System.out.println("\t--type=tsv|tex|(html|xml) -t tsv|tex|(html|xml)\tSpecifies the output format");
        System.out.println("\t--graph=class -g class\tSpecifies the class of Evaluator to be used");
        System.out.println("\t--evaluator=class -e class\tSpecifies the class of GraphEvaluator (plotter) to be used");
        System.out.println("\t--list=algo1,...,algon -l algo1,...,algon\tSequence of the filenames to consider");
        System.out.println("\t--debug[=n] -d [n]\t\tReport debug info at level n");
        System.out.println("\t--help -h\t\t\tPrint this message");
    }
}

