/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.util;

import fr.inrialpes.exmo.align.impl.BasicParameters;
import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.impl.URIAlignment;
import fr.inrialpes.exmo.align.impl.eval.ExtPREvaluator;
import fr.inrialpes.exmo.align.parser.AlignmentParser;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Vector;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.Evaluator;

public class ExtGroupEval {
    BasicParameters params = null;
    String filename = null;
    String reference = "refalign.rdf";
    String format = "s";
    int fsize = 2;
    String type = "html";
    boolean embedded = false;
    String dominant = "s";
    Vector<String> listAlgo = null;
    int debug = 0;
    String color = null;
    String ontoDir = null;

    public static void main(String[] stringArray) {
        try {
            new ExtGroupEval().run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run(String[] stringArray) throws Exception {
        int n;
        String string = "";
        LongOpt[] longOptArray = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("output", 1, null, 111), new LongOpt("format", 1, null, 102), new LongOpt("type", 1, null, 116), new LongOpt("debug", 2, null, 100), new LongOpt("sup", 1, null, 115), new LongOpt("list", 1, null, 108), new LongOpt("color", 2, null, 99), new LongOpt("reference", 1, null, 114), new LongOpt("directory", 1, null, 119)};
        Getopt getopt = new Getopt("", stringArray, "ho:a:d::l:f:t:r:w:c::", longOptArray);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    this.usage();
                    return;
                }
                case 111: {
                    this.filename = getopt.getOptarg();
                    break;
                }
                case 114: {
                    this.reference = getopt.getOptarg();
                    break;
                }
                case 102: {
                    this.format = getopt.getOptarg();
                    break;
                }
                case 116: {
                    this.type = getopt.getOptarg();
                    break;
                }
                case 115: {
                    this.dominant = getopt.getOptarg();
                    break;
                }
                case 99: {
                    this.color = "lightblue";
                    break;
                }
                case 108: {
                    string = getopt.getOptarg();
                    break;
                }
                case 100: {
                    String string2 = getopt.getOptarg();
                    if (string2 != null) {
                        this.debug = Integer.parseInt(string2.trim());
                        break;
                    }
                    this.debug = 4;
                    break;
                }
                case 119: {
                    String string2 = getopt.getOptarg();
                    this.ontoDir = string2 != null ? getopt.getOptarg() : null;
                }
            }
        }
        this.listAlgo = new Vector();
        for (String string3 : string.split(",")) {
            this.listAlgo.add(string3);
        }
        this.params = new BasicParameters();
        if (this.debug > 0) {
            this.params.setParameter("debug", Integer.toString(this.debug - 1));
        }
        this.print(this.iterateDirectories());
    }

    public Vector<Vector> iterateDirectories() {
        Vector<Vector> vector = null;
        Object[] objectArray = null;
        try {
            objectArray = this.ontoDir == null ? new File(System.getProperty("user.dir")).listFiles() : new File(this.ontoDir).listFiles();
        }
        catch (Exception exception) {
            System.err.println("Cannot stat dir " + exception.getMessage());
            this.usage();
        }
        int n = objectArray.length;
        Arrays.sort(objectArray);
        vector = new Vector<Vector>(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Vector<Object> vector2;
            if (!((File)objectArray[i]).isDirectory()) continue;
            if (this.debug > 0) {
                System.err.println("\nEntering directory " + objectArray[i]);
            }
            if ((vector2 = this.iterateAlignments((File)objectArray[i])) == null) continue;
            vector.add(n2, vector2);
            ++n2;
        }
        return vector;
    }

    public Vector<Object> iterateAlignments(File file) {
        String string = file.toURI().toString() + "/";
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        vector.add(0, file.getName().toString());
        int n = 0;
        for (String string2 : this.listAlgo) {
            Evaluator evaluator;
            ++n;
            if (this.debug > 1) {
                System.err.println("  Considering result " + n);
            }
            if ((evaluator = this.eval(string + this.reference, string + string2 + ".rdf")) != null) {
                bl = true;
            }
            vector.add(n, evaluator);
        }
        OntologyFactory.clear();
        if (bl) {
            return vector;
        }
        return null;
    }

    public Evaluator eval(String string, String string2) {
        ExtPREvaluator extPREvaluator = null;
        try {
            int n = this.debug < 2 ? 0 : this.debug - 2;
            AlignmentParser alignmentParser = new AlignmentParser(n);
            Alignment alignment = alignmentParser.parse(string);
            if (this.debug > 1) {
                System.err.println(" Alignment structure1 parsed");
            }
            alignmentParser.initAlignment(null);
            Alignment alignment2 = alignmentParser.parse(string2);
            if (this.debug > 1) {
                System.err.println(" Alignment structure2 parsed");
            }
            extPREvaluator = new ExtPREvaluator(ObjectAlignment.toObjectAlignment((URIAlignment)alignment), ObjectAlignment.toObjectAlignment((URIAlignment)alignment2));
            this.params.setParameter("debug", Integer.toString(n));
            extPREvaluator.eval(this.params);
        }
        catch (Exception exception) {
            if (this.debug > 1) {
                exception.printStackTrace();
            }
            System.err.println("ExtGroupEval: " + exception);
            System.err.println(string + " - " + string2);
        }
        return extPREvaluator;
    }

    /*
     * WARNING - void declaration
     */
    public void print(Vector<Vector> vector) {
        int n = 0;
        PrintStream printStream = null;
        this.fsize = this.format.length();
        try {
            int n2;
            printStream = this.filename == null ? System.out : new PrintStream(new FileOutputStream(this.filename));
            Formatter formatter = new Formatter(printStream);
            printStream.println("<html><head></head><body>");
            printStream.println("<table border='2' frame='sides' rules='groups'>");
            printStream.println("<colgroup align='center' />");
            for (String object : this.listAlgo) {
                printStream.println("<colgroup align='center' span='" + this.fsize + "' />");
            }
            printStream.println("<thead valign='top'><tr><th>algo</th>");
            for (String string : this.listAlgo) {
                printStream.println("<th colspan='" + (this.fsize + 1) + "'>" + string + "</th>");
            }
            printStream.println("</tr></thead><tbody><tr><td>test</td>");
            for (String string : this.listAlgo) {
                for (int i = 0; i < this.fsize; ++i) {
                    if (this.format.charAt(i) == 's') {
                        printStream.println("<td colspan='2'>Symmetric</td>");
                        continue;
                    }
                    if (this.format.charAt(i) == 'e') {
                        printStream.println("<td colspan='2'>Effort</td>");
                        continue;
                    }
                    if (this.format.charAt(i) != 'o') continue;
                    printStream.println("<td colspan='2'>Oriente</td>");
                }
            }
            printStream.println("</tr></tbody><tbody>");
            int[] nArray = new int[this.listAlgo.size()];
            double[] dArray = new double[this.listAlgo.size()];
            for (n2 = this.listAlgo.size() - 1; n2 >= 0; --n2) {
                nArray[n2] = 0;
                dArray[n2] = 0.0;
            }
            n2 = 0;
            for (Vector vector2 : vector) {
                int n3 = -1;
                if (n2 == 1 && this.color != null) {
                    n2 = 0;
                    printStream.println("<tr bgcolor=\"" + this.color + "\">");
                } else {
                    n2 = 1;
                    printStream.println("<tr>");
                }
                printStream.println("<td>" + (String)vector2.get(0) + "</td>");
                Enumeration enumeration = vector2.elements();
                enumeration.nextElement();
                int n4 = 0;
                while (enumeration.hasMoreElements()) {
                    ExtPREvaluator extPREvaluator = (ExtPREvaluator)enumeration.nextElement();
                    if (extPREvaluator != null) {
                        if (n3 == -1) {
                            n3 = extPREvaluator.getExpected();
                            n += n3;
                        }
                        if (nArray[n4] != -1) {
                            int n5 = n4;
                            nArray[n5] = nArray[n5] + extPREvaluator.getFound();
                        }
                        for (int i = 0; i < this.fsize; ++i) {
                            printStream.print("<td>");
                            if (this.format.charAt(i) == 's') {
                                formatter.format("%1.2f", extPREvaluator.getSymPrecision());
                                System.out.print("</td><td>");
                                formatter.format("%1.2f", extPREvaluator.getSymRecall());
                                int n6 = n4;
                                dArray[n6] = dArray[n6] + (double)extPREvaluator.getFound() * extPREvaluator.getSymPrecision();
                            } else if (this.format.charAt(i) == 'e') {
                                formatter.format("%1.2f", extPREvaluator.getEffPrecision());
                                System.out.print("</td><td>");
                                formatter.format("%1.2f", extPREvaluator.getEffRecall());
                                int n7 = n4;
                                dArray[n7] = dArray[n7] + (double)extPREvaluator.getFound() * extPREvaluator.getEffPrecision();
                            } else if (this.format.charAt(i) == 'o') {
                                formatter.format("%1.2f", extPREvaluator.getOrientPrecision());
                                System.out.print("</td><td>");
                                formatter.format("%1.2f", extPREvaluator.getOrientRecall());
                                int n8 = n4;
                                dArray[n8] = dArray[n8] + (double)extPREvaluator.getFound() * extPREvaluator.getOrientPrecision();
                            }
                            printStream.println("</td>");
                        }
                    } else {
                        printStream.println("<td>n/a</td><td>n/a</td>");
                    }
                    ++n4;
                }
                printStream.println("</tr>");
            }
            printStream.print("<tr bgcolor=\"yellow\"><td>H-mean</td>");
            boolean bl = false;
            for (String string : this.listAlgo) {
                void var8_15;
                if (nArray[var8_15] != -1) {
                    double d = dArray[var8_15] / (double)nArray[var8_15];
                    double d2 = dArray[var8_15] / (double)n;
                    printStream.print("<td>");
                    formatter.format("%1.2f", d);
                    System.out.print("</td><td>");
                    formatter.format("%1.2f", d2);
                    printStream.println("</td>");
                } else {
                    printStream.println("<td colspan='2'><center>Error</center></td>");
                }
                ++var8_15;
            }
            printStream.println("</tr>");
            printStream.println("</tbody></table>");
            printStream.println("<p><small>n/a: result alignment not provided or not readable<br />");
            printStream.println("NaN: division per zero, likely due to empty alignent.</small></p>");
            printStream.println("</body></html>");
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void usage() {
        System.out.println("usage: ExtGroupEval [options]");
        System.out.println("options are:");
        System.out.println("\t--format=seo -r seo\tSpecifies the extended measure used (symetric/effort-based/oriented)");
        System.out.println("\t--reference=filename -r filename\tSpecifies the name of the reference alignment file (default: refalign.rdf)");
        System.out.println("\t--dominant=algo -s algo\tSpecifies if dominant columns are algorithms or measure");
        System.out.println("\t--type=html|xml|tex|ascii -t html|xml|tex|ascii\tSpecifies the output format");
        System.out.println("\t--list=algo1,...,algon -l algo1,...,algon\tSequence of the filenames to consider");
        System.out.println("\t--debug[=n] -d [n]\t\tReport debug info at level n");
        System.out.println("\t--help -h\t\t\tPrint this message");
        System.err.println(" ($Id: ExtGroupEval.java 1353 2010-03-24 23:49:46Z euzenat $)\n");
    }
}

