/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.parser;

import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.BasicCell;
import fr.inrialpes.exmo.align.impl.Extensions;
import fr.inrialpes.exmo.align.impl.Namespace;
import fr.inrialpes.exmo.align.impl.URIAlignment;
import fr.inrialpes.exmo.align.parser.SyntaxElement;
import fr.inrialpes.exmo.ontowrap.Ontology;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler {
    protected int debugMode = 0;
    protected String uri = null;
    Ontology onto1 = null;
    Ontology curronto = null;
    Ontology onto2 = null;
    protected Alignment alignment = null;
    protected String content = null;
    protected Object cl1 = null;
    protected Object cl2 = null;
    protected Cell cell = null;
    protected String relation = null;
    protected String id = null;
    protected String sem = null;
    protected Extensions extensions = null;
    protected String measure = null;
    protected SAXParser parser = null;
    protected int parseLevel = 0;
    protected boolean embedded = false;
    protected int alignLevel = -1;

    public XMLParser() throws ParserConfigurationException, SAXException {
        this(0);
    }

    public XMLParser(int n) throws ParserConfigurationException, SAXException {
        this.debugMode = n;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        if (n > 0) {
            sAXParserFactory.setValidating(true);
        } else {
            sAXParserFactory.setValidating(false);
        }
        sAXParserFactory.setNamespaceAware(true);
        this.parser = sAXParserFactory.newSAXParser();
    }

    public void setEmbedded(boolean bl) {
        this.embedded = bl;
    }

    public Alignment parse(String string) throws AlignmentException {
        try {
            this.parser.parse(string, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            throw new AlignmentException("Parsing error", (Exception)sAXException);
        }
        catch (IOException iOException) {
            throw new AlignmentException("I/O error", (Exception)iOException);
        }
        return this.alignment;
    }

    public Alignment parse(Reader reader) throws AlignmentException {
        try {
            this.parser.parse(new InputSource(reader), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            throw new AlignmentException("Parsing error", (Exception)sAXException);
        }
        catch (IOException iOException) {
            throw new AlignmentException("I/O error", (Exception)iOException);
        }
        return this.alignment;
    }

    public Alignment parse(InputStream inputStream) throws AlignmentException {
        try {
            this.parser.parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            throw new AlignmentException("Parsing error", (Exception)sAXException);
        }
        catch (IOException iOException) {
            throw new AlignmentException("I/O error", (Exception)iOException);
        }
        return this.alignment;
    }

    public void initAlignment(URIAlignment uRIAlignment) {
        this.alignment = uRIAlignment;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.debugMode > 2) {
            System.err.println("startElement XMLParser : " + string2);
        }
        ++this.parseLevel;
        if (string.equals(Namespace.ALIGNMENT.uri + "#") || string.equals(Namespace.ALIGNMENT.uri)) {
            if (!(string2.equals(SyntaxElement.RULE_RELATION.name) || string2.equals(SyntaxElement.SEMANTICS.name) || string2.equals(SyntaxElement.MEASURE.name))) {
                if (string2.equals(SyntaxElement.ENTITY2.name)) {
                    if (this.debugMode > 2) {
                        System.err.println(" resource = " + attributes.getValue(SyntaxElement.RDF_RESOURCE.print()));
                    }
                    try {
                        this.cl2 = new URI(attributes.getValue(SyntaxElement.RDF_RESOURCE.print()));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new SAXException("Malformed URI: " + attributes.getValue(SyntaxElement.RDF_RESOURCE.print()));
                    }
                }
                if (string2.equals(SyntaxElement.ENTITY1.name)) {
                    if (this.debugMode > 2) {
                        System.err.println(" resource = " + attributes.getValue(SyntaxElement.RDF_RESOURCE.print()));
                    }
                    try {
                        this.cl1 = new URI(attributes.getValue(SyntaxElement.RDF_RESOURCE.print()));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new SAXException("Malformed URI: " + attributes.getValue(SyntaxElement.RDF_RESOURCE.print()));
                    }
                }
                if (string2.equals(SyntaxElement.CELL.name)) {
                    if (this.alignment == null) {
                        throw new SAXException("No alignment provided");
                    }
                    if (attributes.getValue(SyntaxElement.RDF_ID.print()) != null) {
                        this.id = attributes.getValue(SyntaxElement.RDF_ID.print());
                    } else if (attributes.getValue(SyntaxElement.RDF_ABOUT.print()) != null) {
                        this.id = attributes.getValue(SyntaxElement.RDF_ABOUT.print());
                    }
                    this.sem = null;
                    this.measure = null;
                    this.relation = null;
                    this.extensions = null;
                    this.cl1 = null;
                    this.cl2 = null;
                } else {
                    if (string2.equals(SyntaxElement.MAP.name)) {
                        try {
                            this.alignment.init((Object)this.onto1, (Object)this.onto2);
                        }
                        catch (AlignmentException alignmentException) {
                            throw new SAXException("Catched alignment exception", (Exception)((Object)alignmentException));
                        }
                    }
                    if (string2.equals(SyntaxElement.FORMALISM.name)) {
                        if (attributes.getValue(SyntaxElement.URI.name) != null) {
                            try {
                                this.curronto.setFormURI(new URI(attributes.getValue("uri")));
                            }
                            catch (Exception exception) {
                                throw new SAXException("Malformed URI" + attributes.getValue("uri"), exception);
                            }
                        }
                        if (attributes.getValue("name") != null) {
                            this.curronto.setFormalism(attributes.getValue(SyntaxElement.NAME.name));
                        }
                    } else if (!string2.equals(SyntaxElement.FORMATT.name) && !string2.equals(SyntaxElement.LOCATION.name)) {
                        if (string2.equals(SyntaxElement.ONTOLOGY.name)) {
                            String string4 = attributes.getValue(SyntaxElement.RDF_ABOUT.print());
                            if (string4 != null && !string4.equals("")) {
                                try {
                                    this.curronto.setURI(new URI(string4));
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    throw new SAXException("onto2: malformed URI");
                                }
                            }
                        } else if (string2.equals(SyntaxElement.MAPPING_TARGET.name)) {
                            this.curronto = this.onto2;
                        } else if (string2.equals(SyntaxElement.MAPPING_SOURCE.name)) {
                            this.curronto = this.onto1;
                        } else if (!(string2.equals("uri2") || string2.equals("uri1") || string2.equals(SyntaxElement.TYPE.name) || string2.equals(SyntaxElement.LEVEL.name) || string2.equals(SyntaxElement.XML.name))) {
                            if (string2.equals(SyntaxElement.ALIGNMENT.name)) {
                                this.alignLevel = this.parseLevel;
                                this.parseLevel = 2;
                                if (this.alignment == null) {
                                    this.alignment = new URIAlignment();
                                }
                                this.onto1 = ((URIAlignment)this.alignment).getOntologyObject1();
                                this.onto2 = ((URIAlignment)this.alignment).getOntologyObject2();
                                String string5 = attributes.getValue(SyntaxElement.RDF_ABOUT.print());
                                if (string5 != null && !string5.equals("")) {
                                    this.alignment.setExtension(Namespace.ALIGNMENT.uri, Annotations.ID, string5);
                                }
                            } else if (this.debugMode > 0) {
                                System.err.println("[XMLParser] Unknown element name : " + string2);
                            }
                        }
                    }
                }
            }
        } else if (string.equals(Namespace.SOAP_ENV.prefix)) {
            if (!string2.equals("Envelope") && !string2.equals("Body")) {
                throw new SAXException("[XMLParser] unknown element name: " + string2);
            }
        } else if (string.equals(Namespace.RDF.prefix)) {
            if (!string2.equals("RDF")) {
                throw new SAXException("[XMLParser] unknown element name: " + string2);
            }
        } else if (this.alignLevel != -1 && this.parseLevel != 3 && this.parseLevel != 5 && !this.embedded) {
            throw new SAXException("[XMLParser(" + this.parseLevel + ")] Unknown namespace : " + string);
        }
    }

    private Object getEntity(Object object, String string) throws SAXException {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SAXException("[XMLParser] bad URI syntax : " + string);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.content = new String(cArray, n, n2);
        if (this.debugMode > 2) {
            System.err.println("content XMLParser : " + this.content);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void endElement(String var1_1, String var2_2, String var3_3) throws SAXException {
        if (this.debugMode > 2) {
            System.err.println("endElement XMLParser : " + var2_2);
        }
        if (var1_1.equals(Namespace.ALIGNMENT.uri + "#") || var1_1.equals(Namespace.ALIGNMENT.uri)) {
            try {
                if (var2_2.equals(SyntaxElement.RULE_RELATION.name)) {
                    this.relation = this.content;
                }
                if (var2_2.equals(SyntaxElement.MEASURE.name)) {
                    this.measure = this.content;
                }
                if (var2_2.equals(SyntaxElement.SEMANTICS.name)) {
                    this.sem = this.content;
                }
                if (var2_2.equals(SyntaxElement.ENTITY2.name) || var2_2.equals(SyntaxElement.ENTITY1.name)) ** GOTO lbl107
                if (var2_2.equals(SyntaxElement.CELL.name)) {
                    if (this.debugMode > 1) {
                        System.err.print(" " + this.cl1);
                        System.err.print(" " + this.cl2);
                        System.err.print(" " + this.relation);
                        System.err.println(" " + Double.parseDouble(this.measure));
                    }
                    if (this.cl1 == null || this.cl2 == null) {
                        System.err.println("Warning (cell voided), missing entity " + this.cl1 + " " + this.cl2);
                    } else {
                        this.cell = this.measure == null || this.relation == null ? this.alignment.addAlignCell(this.cl1, this.cl2) : this.alignment.addAlignCell(this.cl1, this.cl2, this.relation, Double.parseDouble(this.measure));
                    }
                    if (this.id != null) {
                        this.cell.setId(this.id);
                    }
                    if (this.sem != null) {
                        this.cell.setSemantics(this.sem);
                    }
                    if (this.extensions == null) ** GOTO lbl107
                    ((BasicCell)this.cell).setExtensions(this.extensions);
                }
                if (var2_2.equals(SyntaxElement.MAP.name)) ** GOTO lbl107
                if (var2_2.equals("uri1")) {
                    if (this.onto1.getURI() != null) ** GOTO lbl107
                    try {
                        var4_4 = new URI(this.content);
                        this.onto1.setURI(var4_4);
                    }
                    catch (URISyntaxException var4_5) {
                        throw new SAXException("uri1: malformed URI");
                    }
                }
                if (var2_2.equals("uri2")) {
                    if (this.onto2.getURI() != null) ** GOTO lbl107
                    try {
                        var4_6 = new URI(this.content);
                        this.onto2.setURI(var4_6);
                    }
                    catch (URISyntaxException var4_7) {
                        throw new SAXException("uri2: malformed URI");
                    }
                }
                if (var2_2.equals(SyntaxElement.ONTOLOGY.name)) ** GOTO lbl107
                if (var2_2.equals(SyntaxElement.LOCATION.name)) {
                    try {
                        this.curronto.setFile(new URI(this.content));
                    }
                    catch (URISyntaxException var4_8) {
                        throw new SAXException("onto2: malformed URI");
                    }
                }
                if (var2_2.equals(SyntaxElement.FORMALISM.name) || var2_2.equals(SyntaxElement.FORMATT.name)) ** GOTO lbl107
                if (var2_2.equals(SyntaxElement.MAPPING_SOURCE.name) || var2_2.equals(SyntaxElement.MAPPING_TARGET.name)) {
                    if (this.curronto.getFile() == null && this.content != null && !this.content.equals("")) {
                        try {
                            this.curronto.setFile(new URI(this.content));
                        }
                        catch (URISyntaxException var4_9) {
                            throw new SAXException(var2_2 + ": malformed URI");
                        }
                    }
                    this.curronto = null;
                }
                if (var2_2.equals(SyntaxElement.TYPE.name)) {
                    this.alignment.setType(this.content);
                }
                if (var2_2.equals(SyntaxElement.LEVEL.name)) {
                    if (this.content.startsWith("2")) {
                        throw new SAXException("Cannot parse Level 2 alignments (so far)");
                    }
                    this.alignment.setLevel(this.content);
                }
                if (var2_2.equals(SyntaxElement.XML.name)) ** GOTO lbl107
                if (var2_2.equals(SyntaxElement.ALIGNMENT.name)) {
                    this.parseLevel = this.alignLevel;
                    this.alignLevel = -1;
                }
                if (this.parseLevel == 3) {
                    this.alignment.setExtension(var1_1, var2_2, this.content);
                }
                if (this.parseLevel == 5) {
                    this.extensions.setExtension(var1_1, var2_2, this.content);
                }
                System.err.println("[XMLParser(" + this.parseLevel + ")] Unknown element name : " + var2_2);
            }
            catch (AlignmentException var4_10) {
                throw new SAXException("[XMLParser] Exception raised", (Exception)var4_10);
            }
        } else if (var1_1.equals(Namespace.SOAP_ENV.prefix)) {
            if (!var2_2.equals("Envelope") && !var2_2.equals("Body")) {
                throw new SAXException("[XMLParser] unknown element name: " + var2_2);
            }
        } else if (var1_1.equals(Namespace.RDF.prefix)) {
            if (!var2_2.equals("RDF")) {
                throw new SAXException("[XMLParser] unknown element name: " + var2_2);
            }
        } else if (this.parseLevel == 3 && this.alignLevel != -1) {
            this.alignment.setExtension(var1_1, var2_2, this.content);
        } else if (this.parseLevel == 5 && this.alignLevel != -1) {
            if (this.extensions == null) {
                this.extensions = new Extensions();
            }
            this.extensions.setExtension(var1_1, var2_2, this.content);
        } else if (!this.embedded) {
            throw new SAXException("[XMLParser] Unknown namespace : " + var1_1);
        }
lbl107:
        // 28 sources

        --this.parseLevel;
    }
}

