/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.parser;

import fr.inrialpes.exmo.align.impl.Namespace;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owl.align.AlignmentException;

public enum SyntaxElement {
    RDF(Namespace.RDF, "RDF", true),
    RDF_ID(Namespace.RDF, "ID"),
    RDF_ABOUT(Namespace.RDF, "about"),
    RDF_DATATYPE(Namespace.RDF, "datatype"),
    RDF_PARSETYPE(Namespace.RDF, "parseType"),
    RDF_RESOURCE(Namespace.RDF, "resource"),
    CREATOR(Namespace.DUBLIN_CORE, "creator"),
    DATE(Namespace.DUBLIN_CORE, "date"),
    IDENTIFIER(Namespace.DUBLIN_CORE, "identifier"),
    ALIGNMENT(Namespace.ALIGNMENT, "Alignment", true),
    ALID(Namespace.ALIGNMENT, "id"),
    CELL(Namespace.ALIGNMENT, "Cell", true),
    CERTIFICATE(Namespace.ALIGNMENT, "certificate"),
    FORMALISM(Namespace.ALIGNMENT, "Formalism", true),
    FORMATT(Namespace.ALIGNMENT, "formalism"),
    CELLID(Namespace.ALIGNMENT, "id"),
    LEVEL(Namespace.ALIGNMENT, "level"),
    LIMITATIONS(Namespace.ALIGNMENT, "limitations"),
    MAP(Namespace.ALIGNMENT, "map"),
    MAPPING_SOURCE(Namespace.ALIGNMENT, "onto1"),
    MAPPING_TARGET(Namespace.ALIGNMENT, "onto2"),
    MEASURE(Namespace.ALIGNMENT, "measure"),
    METHOD(Namespace.ALIGNMENT, "method"),
    NAME(Namespace.ALIGNMENT, "name"),
    PURPOSE(Namespace.ALIGNMENT, "purpose"),
    RULE_RELATION(Namespace.ALIGNMENT, "relation"),
    SEMANTICS(Namespace.ALIGNMENT, "semantics"),
    ENTITY1(Namespace.ALIGNMENT, "entity1"),
    ENTITY2(Namespace.ALIGNMENT, "entity2"),
    TIME(Namespace.ALIGNMENT, "time"),
    TYPE(Namespace.ALIGNMENT, "type"),
    URI(Namespace.ALIGNMENT, "uri"),
    XML(Namespace.ALIGNMENT, "xml"),
    ONTOLOGY(Namespace.ALIGNMENT, "Ontology", true),
    LOCATION(Namespace.ALIGNMENT, "location"),
    AND(Namespace.EDOAL, "and", Constructor.AND),
    APPLY(Namespace.EDOAL, "Apply", true),
    ARGUMENTS(Namespace.EDOAL, "arguments"),
    ATTR_TRANSF(Namespace.EDOAL, "transf"),
    CLASS_EXPR(Namespace.EDOAL, "Class", true),
    COMPARATOR(Namespace.EDOAL, "comparator"),
    COMPOSE(Namespace.EDOAL, "compose", Constructor.COMP),
    DATATYPE(Namespace.EDOAL, "datatype"),
    DOMAIN_RESTRICTION(Namespace.EDOAL, "AttributeDomainRestriction", true),
    INSTANCE_EXPR(Namespace.EDOAL, "Instance", true),
    INVERSE(Namespace.EDOAL, "inverse", Constructor.INVERSE),
    LITERAL(Namespace.EDOAL, "Literal", true),
    NOT(Namespace.EDOAL, "not", Constructor.NOT),
    ONPROPERTY(Namespace.EDOAL, "onAttribute"),
    OPERATOR(Namespace.EDOAL, "operator"),
    OR(Namespace.EDOAL, "or", Constructor.OR),
    PROPERTY_EXPR(Namespace.EDOAL, "Property"),
    OCCURENCE_COND(Namespace.EDOAL, "AttributeOccurenceRestriction", true),
    PROPERTY_TYPE_COND(Namespace.EDOAL, "PropertyTypeRestriction", true),
    PROPERTY_DOMAIN_COND(Namespace.EDOAL, "PropertyDomainRestriction", true),
    PROPERTY_VALUE_COND(Namespace.EDOAL, "PropertyValueRestriction", true),
    RELATION_DOMAIN_COND(Namespace.EDOAL, "RelationDomainRestriction", true),
    RELATION_CODOMAIN_COND(Namespace.EDOAL, "RelationCoDomainRestriction", true),
    REFLEXIVE(Namespace.EDOAL, "reflexive", Constructor.REFLEXIVE),
    RELATION_EXPR(Namespace.EDOAL, "Relation", true),
    STRING(Namespace.EDOAL, "string"),
    SYMMETRIC(Namespace.EDOAL, "symmetric", Constructor.SYMMETRIC),
    TOCLASS(Namespace.EDOAL, "class"),
    TRANSF(Namespace.EDOAL, "transf"),
    TRANSITIVE(Namespace.EDOAL, "transitive", Constructor.TRANSITIVE),
    TYPE_COND(Namespace.EDOAL, "AttributeTypeRestriction", true),
    VALUE(Namespace.EDOAL, "value"),
    VAR(Namespace.EDOAL, "var"),
    VALUE_COND(Namespace.EDOAL, "AttributeValueRestriction", true);

    private static Map<String, SyntaxElement> register;
    public final String name;
    public final Namespace namespace;
    public final Constructor operator;
    public Object resource;
    public final boolean isProperty;

    private static void recordElement(String string, SyntaxElement syntaxElement) {
        if (register == null) {
            register = new HashMap<String, SyntaxElement>();
        }
        register.put(string, syntaxElement);
    }

    private SyntaxElement(Namespace namespace, String string2, Constructor constructor, boolean bl) {
        if (string2 == null || namespace == null) {
            throw new NullPointerException("The name and the namespace must not be null");
        }
        this.namespace = namespace;
        this.name = string2;
        this.isProperty = bl;
        this.operator = constructor;
        SyntaxElement.recordElement(string2, this);
    }

    private SyntaxElement(Namespace namespace, String string2) {
        this(namespace, string2, null, true);
    }

    private SyntaxElement(Namespace namespace, String string2, boolean bl) {
        this(namespace, string2, null, bl);
    }

    private SyntaxElement(Namespace namespace, String string2, Constructor constructor) {
        this(namespace, string2, constructor, true);
    }

    public static SyntaxElement getElementByName(String string) {
        if (string == null) {
            throw new NullPointerException("The string must not be null");
        }
        for (SyntaxElement syntaxElement : SyntaxElement.values()) {
            if (!string.equals(syntaxElement.getName())) continue;
            return syntaxElement;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public static Object getResource(String string) throws AlignmentException {
        if (register == null) {
            throw new AlignmentException("Non initialized Syntax resources");
        }
        return SyntaxElement.register.get((Object)string).resource;
    }

    public Constructor getOperator() {
        return this.operator;
    }

    public static SyntaxElement getElement(Constructor constructor) {
        for (SyntaxElement syntaxElement : SyntaxElement.values()) {
            if (!constructor.equals((Object)syntaxElement.getOperator())) continue;
            return syntaxElement;
        }
        return null;
    }

    public String print() {
        return this.namespace.getShortCut() + ":" + this.name;
    }

    public String id() {
        return this.namespace.getUriPrefix() + this.name;
    }

    public String print(Namespace namespace) {
        return this.namespace == namespace ? this.name : this.print();
    }

    public String toString() {
        return this.print();
    }

    public static enum Constructor {
        AND,
        OR,
        NOT,
        COMP,
        JOIN,
        SYMMETRIC,
        REFLEXIVE,
        TRANSITIVE,
        INVERSE;

    }
}

