/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.parser;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.vocabulary.RDF;
import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.Namespace;
import fr.inrialpes.exmo.align.impl.edoal.Apply;
import fr.inrialpes.exmo.align.impl.edoal.ClassConstruction;
import fr.inrialpes.exmo.align.impl.edoal.ClassDomainRestriction;
import fr.inrialpes.exmo.align.impl.edoal.ClassExpression;
import fr.inrialpes.exmo.align.impl.edoal.ClassId;
import fr.inrialpes.exmo.align.impl.edoal.ClassOccurenceRestriction;
import fr.inrialpes.exmo.align.impl.edoal.ClassTypeRestriction;
import fr.inrialpes.exmo.align.impl.edoal.ClassValueRestriction;
import fr.inrialpes.exmo.align.impl.edoal.Comparator;
import fr.inrialpes.exmo.align.impl.edoal.Datatype;
import fr.inrialpes.exmo.align.impl.edoal.EDOALAlignment;
import fr.inrialpes.exmo.align.impl.edoal.EDOALCell;
import fr.inrialpes.exmo.align.impl.edoal.EDOALRelation;
import fr.inrialpes.exmo.align.impl.edoal.Expression;
import fr.inrialpes.exmo.align.impl.edoal.InstanceExpression;
import fr.inrialpes.exmo.align.impl.edoal.InstanceId;
import fr.inrialpes.exmo.align.impl.edoal.PathExpression;
import fr.inrialpes.exmo.align.impl.edoal.PropertyConstruction;
import fr.inrialpes.exmo.align.impl.edoal.PropertyDomainRestriction;
import fr.inrialpes.exmo.align.impl.edoal.PropertyExpression;
import fr.inrialpes.exmo.align.impl.edoal.PropertyId;
import fr.inrialpes.exmo.align.impl.edoal.PropertyTypeRestriction;
import fr.inrialpes.exmo.align.impl.edoal.PropertyValueRestriction;
import fr.inrialpes.exmo.align.impl.edoal.RelationCoDomainRestriction;
import fr.inrialpes.exmo.align.impl.edoal.RelationConstruction;
import fr.inrialpes.exmo.align.impl.edoal.RelationDomainRestriction;
import fr.inrialpes.exmo.align.impl.edoal.RelationExpression;
import fr.inrialpes.exmo.align.impl.edoal.RelationId;
import fr.inrialpes.exmo.align.impl.edoal.Value;
import fr.inrialpes.exmo.align.impl.edoal.ValueExpression;
import fr.inrialpes.exmo.align.impl.edoal.Variable;
import fr.inrialpes.exmo.align.parser.SyntaxElement;
import fr.inrialpes.exmo.ontowrap.BasicOntology;
import fr.inrialpes.exmo.ontowrap.Ontology;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owl.align.AlignmentException;

public class RDFParser {
    private static Logger logger = Logger.getLogger(RDFParser.class.toString());
    private static Model rDFModel;
    private int debug = 0;
    private boolean isPattern = false;
    private EDOALAlignment alignment;

    public RDFParser() {
        this(0);
    }

    public RDFParser(int n) {
        this.debug = n;
    }

    public static void initSyntax() {
        if (rDFModel == null) {
            rDFModel = ModelFactory.createDefaultModel();
            for (SyntaxElement syntaxElement : SyntaxElement.values()) {
                syntaxElement.resource = syntaxElement.isProperty ? rDFModel.createProperty(syntaxElement.id()) : rDFModel.createResource(syntaxElement.id());
            }
        }
    }

    public EDOALAlignment parse(Model model) throws AlignmentException {
        RDFParser.initSyntax();
        RDFDefaultErrorHandler.silent = true;
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, (RDFNode)((Resource)SyntaxElement.getResource("Alignment")));
        if (!stmtIterator.hasNext()) {
            throw new AlignmentException("There is no alignment in the RDF document");
        }
        Statement statement = stmtIterator.nextStatement();
        this.alignment = this.parseAlignment(statement.getSubject());
        model.close();
        return this.alignment;
    }

    public EDOALAlignment parse(File file) throws AlignmentException {
        try {
            return this.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AlignmentException("RDFParser: There isn't such file: " + file.getName(), (Exception)fileNotFoundException);
        }
    }

    public EDOALAlignment parse(Reader reader) throws AlignmentException {
        if (reader == null) {
            throw new AlignmentException("The reader must not be null");
        }
        Model model = ModelFactory.createDefaultModel();
        model.read(reader, null);
        return this.parse(model);
    }

    public EDOALAlignment parse(InputStream inputStream) throws AlignmentException {
        if (inputStream == null) {
            throw new AlignmentException("The inputstream must not be null");
        }
        Model model = ModelFactory.createDefaultModel();
        model.read(inputStream, null);
        return this.parse(model);
    }

    public EDOALAlignment parse(String string) throws AlignmentException {
        Model model = ModelFactory.createDefaultModel();
        model.read(string);
        return this.parse(model);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EDOALAlignment parseAlignment(Resource resource) throws AlignmentException {
        if (resource == null) {
            throw new NullPointerException("Alignment must not be null");
        }
        try {
            StmtIterator stmtIterator;
            Ontology ontology = null;
            Ontology ontology2 = null;
            URI uRI = this.getNodeId(resource);
            this.alignment = new EDOALAlignment();
            if (uRI != null) {
                this.alignment.setExtension(Namespace.ALIGNMENT.uri, Annotations.ID, uRI.toString());
            }
            if (!(stmtIterator = resource.listProperties((Property)SyntaxElement.MAPPING_SOURCE.resource)).hasNext()) {
                throw new AlignmentException("Missing ontology onto1");
            }
            ontology = this.parseOntology(stmtIterator.nextStatement().getResource());
            stmtIterator = resource.listProperties((Property)SyntaxElement.MAPPING_TARGET.resource);
            if (!stmtIterator.hasNext()) {
                throw new AlignmentException("Missing ontology onto2");
            }
            ontology2 = this.parseOntology(stmtIterator.nextStatement().getResource());
            stmtIterator = resource.listProperties((Property)SyntaxElement.LEVEL.resource);
            if (!stmtIterator.hasNext()) throw new AlignmentException("Missing level ");
            String string = stmtIterator.nextStatement().getString();
            if (string != null && !string.equals("")) {
                if (!string.startsWith("2EDOAL")) throw new AlignmentException("Cannot parse alignment of level " + string);
                this.alignment.setLevel(string);
                if (string.equals("2EDOALPattern")) {
                    this.isPattern = true;
                }
            }
            stmtIterator = resource.listProperties((Property)SyntaxElement.TYPE.resource);
            if (!stmtIterator.hasNext()) throw new AlignmentException("Missing type ");
            string = stmtIterator.nextStatement().getString();
            if (string != null && !string.equals("")) {
                this.alignment.setType(string);
            }
            stmtIterator = resource.listProperties((Property)SyntaxElement.MAP.resource);
            while (stmtIterator.hasNext()) {
                string = stmtIterator.nextStatement();
                if (this.debug > 0) {
                    System.err.println("  ---------------> " + string);
                }
                try {
                    this.alignment.addAlignCell(this.parseCell(string.getResource()));
                }
                catch (AlignmentException alignmentException) {
                    System.err.println("Error " + (Object)((Object)alignmentException));
                    alignmentException.printStackTrace();
                }
            }
            if (ontology == null || ontology2 == null) {
                throw new IllegalArgumentException("Missing ontology description");
            }
            this.alignment.init(ontology, ontology2);
            return this.alignment;
        }
        catch (AlignmentException alignmentException) {
            throw alignmentException;
        }
        catch (Exception exception) {
            throw new AlignmentException("There is some error in parsing alignment: " + resource.getLocalName(), exception);
        }
    }

    protected Ontology parseOntology(Resource resource) throws AlignmentException {
        if (resource == null) {
            throw new AlignmentException("The ontology node must not be null");
        }
        try {
            Resource resource2 = resource.getProperty((Property)SyntaxElement.FORMATT.resource).getResource();
            String string = resource2.getProperty((Property)SyntaxElement.NAME.resource).getString();
            String string2 = resource2.getProperty((Property)SyntaxElement.URI.resource).getString();
            Statement statement = resource.getProperty((Property)SyntaxElement.LOCATION.resource);
            BasicOntology basicOntology = new BasicOntology();
            basicOntology.setURI(new URI(resource.getURI()));
            basicOntology.setFormURI(new URI(string2));
            basicOntology.setFormalism(string);
            if (statement != null) {
                basicOntology.setFile(new URI(statement.getString()));
            }
            return basicOntology;
        }
        catch (Exception exception) {
            throw new AlignmentException("The ontology node isn't correct: " + resource.getLocalName(), exception);
        }
    }

    protected EDOALCell parseCell(Resource resource) throws AlignmentException {
        if (resource == null) {
            throw new NullPointerException("The node must not be null");
        }
        try {
            String string = resource.getProperty((Property)SyntaxElement.RULE_RELATION.resource).getString();
            EDOALRelation eDOALRelation = new EDOALRelation(string);
            if (eDOALRelation == null) {
                throw new IllegalArgumentException("Couln't parse the string \"" + string + "\" to a valid rule type");
            }
            float f = resource.getProperty((Property)SyntaxElement.MEASURE.resource).getFloat();
            String string2 = resource.getURI();
            Resource resource2 = resource.getProperty((Property)SyntaxElement.ENTITY1.resource).getResource();
            Resource resource3 = resource.getProperty((Property)SyntaxElement.ENTITY2.resource).getResource();
            Expression expression = this.parseExpression(resource2);
            Expression expression2 = this.parseExpression(resource3);
            if (this.debug > 0) {
                System.err.println(" s : " + expression);
                System.err.println(" t : " + expression2);
            }
            return new EDOALCell(string2, expression, expression2, eDOALRelation, (double)f);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "The cell isn't correct:" + resource.getLocalName() + " " + exception.getMessage());
            throw new AlignmentException("Cannot parse correspondence " + resource.getLocalName(), exception);
        }
    }

    protected Expression parseExpression(Resource resource) throws AlignmentException {
        StmtIterator stmtIterator;
        Expression expression;
        Resource resource2 = resource.getProperty(RDF.type).getResource();
        if (resource2.equals(SyntaxElement.CLASS_EXPR.resource) || resource2.equals(SyntaxElement.OCCURENCE_COND.resource) || resource2.equals(SyntaxElement.DOMAIN_RESTRICTION.resource) || resource2.equals(SyntaxElement.TYPE_COND.resource) || resource2.equals(SyntaxElement.VALUE_COND.resource)) {
            expression = this.parseClass(resource);
        } else if (resource2.equals(SyntaxElement.PROPERTY_EXPR.resource) || resource2.equals(SyntaxElement.PROPERTY_DOMAIN_COND.resource) || resource2.equals(SyntaxElement.PROPERTY_TYPE_COND.resource) || resource2.equals(SyntaxElement.PROPERTY_VALUE_COND.resource)) {
            expression = this.parseProperty(resource);
        } else if (resource2.equals(SyntaxElement.RELATION_EXPR.resource) || resource2.equals(SyntaxElement.RELATION_DOMAIN_COND.resource) || resource2.equals(SyntaxElement.RELATION_CODOMAIN_COND.resource)) {
            expression = this.parseRelation(resource);
        } else if (resource2.equals(SyntaxElement.INSTANCE_EXPR.resource)) {
            expression = this.parseInstance(resource);
        } else {
            throw new AlignmentException("There is no parser for entity " + resource2.getLocalName());
        }
        if (this.isPattern && (stmtIterator = resource.listProperties((Property)SyntaxElement.VAR.resource)).hasNext()) {
            String string = stmtIterator.nextStatement().getString();
            Variable variable = this.alignment.recordVariable(string, expression);
            expression.setVariable(variable);
        }
        return expression;
    }

    protected ClassExpression parseClass(Resource resource) throws AlignmentException {
        StmtIterator stmtIterator;
        if (this.debug > 1) {
            stmtIterator = resource.listProperties();
            while (stmtIterator.hasNext()) {
                System.err.println("   > " + stmtIterator.next());
            }
        }
        if ((stmtIterator = resource.getProperty(RDF.type).getResource()).equals(SyntaxElement.CLASS_EXPR.resource)) {
            URI uRI = this.getNodeId(resource);
            if (uRI != null) {
                return new ClassId(uRI);
            }
            Statement statement = null;
            SyntaxElement.Constructor constructor = null;
            LinkedList<ClassExpression> linkedList = new LinkedList<ClassExpression>();
            if (resource.hasProperty((Property)SyntaxElement.AND.resource)) {
                constructor = SyntaxElement.AND.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.AND.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.OR.resource)) {
                constructor = SyntaxElement.OR.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.OR.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.NOT.resource)) {
                constructor = SyntaxElement.NOT.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.NOT.resource);
            } else {
                if (this.isPattern) {
                    return new ClassId();
                }
                throw new AlignmentException("Class statement must containt one constructor or Id : " + resource);
            }
            Resource resource2 = statement.getResource();
            if (constructor == SyntaxElement.NOT.getOperator()) {
                linkedList.add(this.parseClass(resource2));
            } else {
                while (!RDF.nil.getURI().equals(resource2.getURI())) {
                    linkedList.add(this.parseClass(resource2.getProperty(RDF.first).getResource()));
                    resource2 = resource2.getProperty(RDF.rest).getResource();
                }
            }
            return new ClassConstruction(constructor, linkedList);
        }
        if (!(stmtIterator.equals(SyntaxElement.OCCURENCE_COND.resource) || stmtIterator.equals(SyntaxElement.DOMAIN_RESTRICTION.resource) || stmtIterator.equals(SyntaxElement.TYPE_COND.resource) || stmtIterator.equals(SyntaxElement.VALUE_COND.resource))) {
            throw new AlignmentException("Bad class restriction type : " + stmtIterator);
        }
        Statement statement = resource.getProperty((Property)SyntaxElement.ONPROPERTY.resource);
        if (statement == null) {
            throw new AlignmentException("Required edoal:onAttribute property");
        }
        PathExpression pathExpression = this.parsePathExpression(statement.getResource());
        if (stmtIterator.equals(SyntaxElement.TYPE_COND.resource)) {
            statement = resource.getProperty((Property)SyntaxElement.DATATYPE.resource);
            if (statement == null) {
                throw new AlignmentException("Required edoal:datatype property");
            }
            RDFNode rDFNode = statement.getObject();
            if (rDFNode.isLiteral()) {
                return new ClassTypeRestriction(pathExpression, new Datatype(((Literal)rDFNode).getString()));
            }
            throw new AlignmentException("Bad edoal:datatype value");
        }
        if (stmtIterator.equals(SyntaxElement.DOMAIN_RESTRICTION.resource)) {
            statement = resource.getProperty((Property)SyntaxElement.TOCLASS.resource);
            if (statement == null) {
                throw new AlignmentException("Required edoal:class property");
            }
            RDFNode rDFNode = statement.getObject();
            if (rDFNode.isResource()) {
                return new ClassDomainRestriction(pathExpression, this.parseClass((Resource)rDFNode));
            }
            throw new AlignmentException("Incorrect class expression " + rDFNode);
        }
        statement = resource.getProperty((Property)SyntaxElement.COMPARATOR.resource);
        if (statement == null) {
            throw new AlignmentException("Required edoal:comparator property");
        }
        URI uRI = this.getNodeId(statement.getResource());
        if (uRI == null) {
            throw new AlignmentException("edoal:comparator requires an URI");
        }
        Comparator comparator = new Comparator(uRI);
        if (stmtIterator.equals(SyntaxElement.OCCURENCE_COND.resource)) {
            statement = resource.getProperty((Property)SyntaxElement.VALUE.resource);
            if (statement == null) {
                throw new AlignmentException("Required edoal:value property");
            }
            RDFNode rDFNode = statement.getObject();
            if (rDFNode.isLiteral()) {
                return new ClassOccurenceRestriction(pathExpression, comparator, ((Literal)rDFNode).getInt());
            }
            throw new AlignmentException("Bad occurence specification : " + rDFNode);
        }
        if (stmtIterator.equals(SyntaxElement.VALUE_COND.resource)) {
            statement = resource.getProperty((Property)SyntaxElement.VALUE.resource);
            if (statement == null) {
                throw new AlignmentException("Required edoal:value property");
            }
            ValueExpression valueExpression = this.parseValue(statement.getObject());
            return new ClassValueRestriction(pathExpression, comparator, valueExpression);
        }
        return null;
    }

    protected PathExpression parsePathExpression(Resource resource) throws AlignmentException {
        Resource resource2 = resource.getProperty(RDF.type).getResource();
        if (resource2.equals(SyntaxElement.PROPERTY_EXPR.resource) || resource2.equals(SyntaxElement.PROPERTY_DOMAIN_COND.resource) || resource2.equals(SyntaxElement.PROPERTY_TYPE_COND.resource) || resource2.equals(SyntaxElement.PROPERTY_VALUE_COND.resource)) {
            return this.parseProperty(resource);
        }
        if (resource2.equals(SyntaxElement.RELATION_EXPR.resource) || resource2.equals(SyntaxElement.RELATION_CODOMAIN_COND.resource) || resource2.equals(SyntaxElement.RELATION_DOMAIN_COND.resource)) {
            return this.parseRelation(resource);
        }
        throw new AlignmentException("Cannot parse path expression (" + resource2 + "): " + resource);
    }

    protected PropertyExpression parseProperty(Resource resource) throws AlignmentException {
        Resource resource2 = resource.getProperty(RDF.type).getResource();
        Statement statement = null;
        if (resource2.equals(SyntaxElement.PROPERTY_EXPR.resource)) {
            URI uRI = this.getNodeId(resource);
            if (uRI != null) {
                return new PropertyId(uRI);
            }
            SyntaxElement.Constructor constructor = null;
            LinkedList<PathExpression> linkedList = new LinkedList<PathExpression>();
            if (resource.hasProperty((Property)SyntaxElement.AND.resource)) {
                constructor = SyntaxElement.AND.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.AND.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.OR.resource)) {
                constructor = SyntaxElement.OR.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.OR.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.COMPOSE.resource)) {
                constructor = SyntaxElement.COMPOSE.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.COMPOSE.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.NOT.resource)) {
                constructor = SyntaxElement.NOT.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.NOT.resource);
            } else {
                if (this.isPattern) {
                    return new PropertyId();
                }
                throw new AlignmentException("Property statement must containt one constructor or Id : " + resource);
            }
            Resource resource3 = statement.getResource();
            if (constructor == SyntaxElement.NOT.getOperator()) {
                linkedList.add(this.parseProperty(resource3));
            } else if (constructor == SyntaxElement.COMPOSE.getOperator()) {
                while (!RDF.nil.getURI().equals(resource3.getURI())) {
                    Resource resource4 = resource3.getProperty(RDF.rest).getResource();
                    if (!RDF.nil.getURI().equals(resource4.getURI())) {
                        linkedList.add(this.parseRelation(resource3.getProperty(RDF.first).getResource()));
                    } else {
                        linkedList.add(this.parseProperty(resource3.getProperty(RDF.first).getResource()));
                    }
                    resource3 = resource4;
                }
            } else {
                while (!RDF.nil.getURI().equals(resource3.getURI())) {
                    linkedList.add(this.parseProperty(resource3.getProperty(RDF.first).getResource()));
                    resource3 = resource3.getProperty(RDF.rest).getResource();
                }
            }
            return new PropertyConstruction(constructor, linkedList);
        }
        if (resource2.equals(SyntaxElement.PROPERTY_DOMAIN_COND.resource)) {
            statement = resource.getProperty((Property)SyntaxElement.TOCLASS.resource);
            if (statement == null) {
                throw new AlignmentException("Required edoal:toClass property");
            }
            RDFNode rDFNode = statement.getObject();
            if (rDFNode.isResource()) {
                return new PropertyDomainRestriction(this.parseClass((Resource)rDFNode));
            }
            throw new AlignmentException("Incorrect class expression " + rDFNode);
        }
        if (resource2.equals(SyntaxElement.PROPERTY_TYPE_COND.resource)) {
            statement = resource.getProperty((Property)SyntaxElement.DATATYPE.resource);
            if (statement == null) {
                throw new AlignmentException("Required edoal:datatype property");
            }
            RDFNode rDFNode = statement.getObject();
            if (rDFNode.isLiteral()) {
                return new PropertyTypeRestriction(new Datatype(((Literal)rDFNode).getString()));
            }
            throw new AlignmentException("Bad edoal:datatype value");
        }
        if (resource2.equals(SyntaxElement.PROPERTY_VALUE_COND.resource)) {
            statement = resource.getProperty((Property)SyntaxElement.COMPARATOR.resource);
            if (statement == null) {
                throw new AlignmentException("Required edoal:comparator property");
            }
            URI uRI = this.getNodeId(statement.getResource());
            if (uRI == null) {
                throw new AlignmentException("edoal:comparator requires and URI");
            }
            Comparator comparator = new Comparator(uRI);
            statement = resource.getProperty((Property)SyntaxElement.VALUE.resource);
            if (statement == null) {
                throw new AlignmentException("Required edoal:value property");
            }
            ValueExpression valueExpression = this.parseValue(statement.getObject());
            return new PropertyValueRestriction(comparator, valueExpression);
        }
        throw new AlignmentException("There is no pasrser for entity " + resource2.getLocalName());
    }

    protected RelationExpression parseRelation(Resource resource) throws AlignmentException {
        Resource resource2 = resource.getProperty(RDF.type).getResource();
        Statement statement = null;
        if (resource2.equals(SyntaxElement.RELATION_EXPR.resource)) {
            URI uRI = this.getNodeId(resource);
            if (uRI != null) {
                return new RelationId(uRI);
            }
            SyntaxElement.Constructor constructor = null;
            LinkedList<PathExpression> linkedList = new LinkedList<PathExpression>();
            if (resource.hasProperty((Property)SyntaxElement.AND.resource)) {
                constructor = SyntaxElement.AND.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.AND.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.OR.resource)) {
                constructor = SyntaxElement.OR.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.OR.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.COMPOSE.resource)) {
                constructor = SyntaxElement.COMPOSE.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.COMPOSE.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.NOT.resource)) {
                constructor = SyntaxElement.NOT.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.NOT.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.INVERSE.resource)) {
                constructor = SyntaxElement.INVERSE.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.INVERSE.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.REFLEXIVE.resource)) {
                constructor = SyntaxElement.REFLEXIVE.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.REFLEXIVE.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.SYMMETRIC.resource)) {
                constructor = SyntaxElement.SYMMETRIC.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.SYMMETRIC.resource);
            } else if (resource.hasProperty((Property)SyntaxElement.TRANSITIVE.resource)) {
                constructor = SyntaxElement.TRANSITIVE.getOperator();
                statement = resource.getProperty((Property)SyntaxElement.TRANSITIVE.resource);
            } else {
                if (this.isPattern) {
                    return new RelationId();
                }
                throw new AlignmentException("Relation statement must containt one constructor or Id : " + resource);
            }
            Resource resource3 = statement.getResource();
            if (constructor == SyntaxElement.NOT.getOperator() || constructor == SyntaxElement.INVERSE.getOperator() || constructor == SyntaxElement.REFLEXIVE.getOperator() || constructor == SyntaxElement.SYMMETRIC.getOperator() || constructor == SyntaxElement.TRANSITIVE.getOperator()) {
                linkedList.add(this.parseRelation(resource3));
            } else {
                while (!RDF.nil.getURI().equals(resource3.getURI())) {
                    linkedList.add(this.parseRelation(resource3.getProperty(RDF.first).getResource()));
                    resource3 = resource3.getProperty(RDF.rest).getResource();
                }
            }
            return new RelationConstruction(constructor, linkedList);
        }
        if (resource2.equals(SyntaxElement.RELATION_DOMAIN_COND.resource)) {
            statement = resource.getProperty((Property)SyntaxElement.TOCLASS.resource);
            if (statement == null) {
                throw new AlignmentException("Required edoal:toClass property");
            }
            RDFNode rDFNode = statement.getObject();
            if (rDFNode.isResource()) {
                return new RelationDomainRestriction(this.parseClass((Resource)rDFNode));
            }
            throw new AlignmentException("Incorrect class expression " + rDFNode);
        }
        if (resource2.equals(SyntaxElement.RELATION_CODOMAIN_COND.resource)) {
            statement = resource.getProperty((Property)SyntaxElement.TOCLASS.resource);
            if (statement == null) {
                throw new AlignmentException("Required edoal:toClass property");
            }
            RDFNode rDFNode = statement.getObject();
            if (rDFNode.isResource()) {
                return new RelationCoDomainRestriction(this.parseClass((Resource)rDFNode));
            }
            throw new AlignmentException("Incorrect class expression " + rDFNode);
        }
        throw new AlignmentException("There is no pasrser for entity " + resource2.getLocalName());
    }

    protected InstanceExpression parseInstance(Resource resource) throws AlignmentException {
        Resource resource2 = resource.getProperty(RDF.type).getResource();
        if (resource2.equals(SyntaxElement.INSTANCE_EXPR.resource)) {
            URI uRI = this.getNodeId(resource);
            if (uRI != null) {
                return new InstanceId(uRI);
            }
            throw new AlignmentException("Cannot parse anonymous individual");
        }
        if (this.isPattern) {
            return new InstanceId();
        }
        throw new AlignmentException("There is no pasrser for entity " + resource2.getLocalName());
    }

    protected ValueExpression parseValue(RDFNode rDFNode) throws AlignmentException {
        if (rDFNode.isLiteral()) {
            return new Value(((Literal)rDFNode).getString());
        }
        if (rDFNode.isResource()) {
            Resource resource = ((Resource)rDFNode).getProperty(RDF.type).getResource();
            if (resource.equals(SyntaxElement.INSTANCE_EXPR.resource)) {
                return this.parseInstance((Resource)rDFNode);
            }
            if (resource.equals(SyntaxElement.LITERAL.resource)) {
                if (((Resource)rDFNode).hasProperty((Property)SyntaxElement.STRING.resource)) {
                    if (((Resource)rDFNode).hasProperty((Property)SyntaxElement.TYPE.resource)) {
                        try {
                            return new Value(((Resource)rDFNode).getProperty((Property)SyntaxElement.STRING.resource).getLiteral().getString(), new URI(((Resource)rDFNode).getProperty((Property)SyntaxElement.TYPE.resource).getLiteral().getString()));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new AlignmentException("Incorect URI for edoal:type : " + ((Resource)rDFNode).getProperty((Property)SyntaxElement.TYPE.resource).getLiteral().getString());
                        }
                    }
                    return new Value(((Resource)rDFNode).getProperty((Property)SyntaxElement.STRING.resource).getLiteral().getString());
                }
                throw new AlignmentException("edoal:Literal requires a edoal:value");
            }
            if (resource.equals(SyntaxElement.APPLY.resource)) {
                URI uRI;
                Object object;
                if (((Resource)rDFNode).hasProperty((Property)SyntaxElement.OPERATOR.resource)) {
                    object = ((Resource)rDFNode).getProperty((Property)SyntaxElement.OPERATOR.resource).getLiteral().getString();
                    try {
                        uRI = new URI((String)object);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new AlignmentException("edoal:Apply incorrect operation URI : " + (String)object);
                    }
                } else {
                    throw new AlignmentException("edoal:Apply requires an operation");
                }
                object = new LinkedList();
                if (((Resource)rDFNode).hasProperty((Property)SyntaxElement.ARGUMENTS.resource)) {
                    Statement statement = ((Resource)rDFNode).getProperty((Property)SyntaxElement.ARGUMENTS.resource);
                    Resource resource2 = statement.getResource();
                    while (!RDF.nil.getURI().equals(resource2.getURI())) {
                        object.add(this.parseValue((RDFNode)resource2.getProperty(RDF.first).getResource()));
                        resource2 = resource2.getProperty(RDF.rest).getResource();
                    }
                }
                return new Apply(uRI, (List<ValueExpression>)object);
            }
            return this.parsePathExpression((Resource)rDFNode);
        }
        throw new AlignmentException("Bad edoal:value value");
    }

    protected URI getNodeId(Resource resource) throws AlignmentException {
        String string = resource.getURI();
        if (string != null && string.length() > 0) {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new AlignmentException("Incorrect URI: " + string);
            }
        }
        return null;
    }

    protected void parseAnnotation(Statement statement, EDOALAlignment eDOALAlignment) throws AlignmentException {
        try {
            String string = statement.getString();
            if (string != null && string.length() > 0) {
                URI uRI = new URI(statement.getPredicate().getURI());
                String string2 = uRI.getFragment();
                String string3 = uRI.getScheme() + ":" + uRI.getSchemeSpecificPart();
                if (string2 == null) {
                    int n = string3.lastIndexOf(47);
                    string2 = string3.substring(n + 1);
                    string3 = string3.substring(0, n + 1);
                } else {
                    string3 = string3 + "#";
                }
                eDOALAlignment.setExtension(string3, string2, string);
            }
        }
        catch (Exception exception) {
            throw new AlignmentException("The annotation is not correct", exception);
        }
    }
}

