/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.parser;

import fr.inrialpes.exmo.align.impl.URIAlignment;
import fr.inrialpes.exmo.align.parser.RDFParser;
import fr.inrialpes.exmo.align.parser.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;

public class AlignmentParser {
    protected int debugMode = 0;
    protected String uri = null;
    protected Alignment alignment = null;
    protected int parseLevel = 0;
    protected boolean embedded = false;
    protected int alignLevel = -1;

    public AlignmentParser(int n) {
        this.debugMode = n;
    }

    public void setEmbedded(boolean bl) {
        this.embedded = bl;
    }

    @Deprecated
    public Alignment parse(String string, Hashtable hashtable) throws AlignmentException {
        return this.parse(string);
    }

    private Alignment callParser(Object object) throws AlignmentException {
        try {
            XMLParser xMLParser = new XMLParser(this.debugMode);
            if (this.embedded) {
                xMLParser.setEmbedded(this.embedded);
            }
            this.alignment = this.callParser(xMLParser, object);
        }
        catch (Exception exception) {
            if (this.debugMode > 0) {
                System.err.println("XMLParser failed to parse alignment (INFO)");
                exception.printStackTrace();
            }
            try {
                if (this.embedded) {
                    throw new AlignmentException("Cannot parse " + object, exception);
                }
                RDFParser rDFParser = new RDFParser(this.debugMode);
                this.alignment = this.callParser(rDFParser, object);
            }
            catch (Exception exception2) {
                throw new AlignmentException("Cannot parse " + object, exception2);
            }
        }
        return this.alignment;
    }

    private Alignment callParser(XMLParser xMLParser, Object object) throws AlignmentException {
        if (object instanceof URI) {
            return xMLParser.parse(((URI)object).toString());
        }
        if (object instanceof String) {
            return xMLParser.parse(new ByteArrayInputStream(((String)object).getBytes()));
        }
        if (object instanceof Reader) {
            return xMLParser.parse((Reader)object);
        }
        if (object instanceof InputStream) {
            return xMLParser.parse((InputStream)object);
        }
        throw new AlignmentException("AlignmentParser: cannot parse :" + object);
    }

    private Alignment callParser(RDFParser rDFParser, Object object) throws AlignmentException {
        if (object instanceof URI) {
            return rDFParser.parse(((URI)object).toString());
        }
        if (object instanceof String) {
            return rDFParser.parse(new ByteArrayInputStream(((String)object).getBytes()));
        }
        if (object instanceof Reader) {
            return rDFParser.parse((Reader)object);
        }
        if (object instanceof InputStream) {
            return rDFParser.parse((InputStream)object);
        }
        throw new AlignmentException("AlignmentParser: cannot parse :" + object);
    }

    public Alignment parseString(String string) throws AlignmentException {
        this.callParser(string);
        return this.alignment;
    }

    public Alignment parse(Reader reader) throws AlignmentException {
        this.callParser(reader);
        return this.alignment;
    }

    public Alignment parse(String string) throws AlignmentException {
        this.uri = string;
        try {
            this.callParser(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AlignmentException("Invalid URI : " + string, (Exception)uRISyntaxException);
        }
        return this.alignment;
    }

    public Alignment parse(URI uRI) throws AlignmentException {
        this.uri = uRI.toString();
        this.callParser(uRI);
        return this.alignment;
    }

    public Alignment parse(InputStream inputStream) throws AlignmentException {
        this.callParser(inputStream);
        return this.alignment;
    }

    public void initAlignment(URIAlignment uRIAlignment) {
        this.alignment = uRIAlignment;
    }
}

