/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.ling;

import fr.inrialpes.exmo.align.impl.DistanceAlignment;
import fr.inrialpes.exmo.align.impl.MatrixMeasure;
import fr.inrialpes.exmo.ontosim.string.JWNLDistances;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentProcess;

public class JWNLAlignment
extends DistanceAlignment
implements AlignmentProcess {
    static final String WNVERS = "3.0";

    public JWNLAlignment() {
        this.setSimilarity(new WordNetMatrixMeasure());
        this.setType("**");
    }

    @Override
    public void align(Alignment alignment, Properties properties) throws AlignmentException {
        String string;
        int n = 0;
        this.loadInit(alignment);
        WordNetMatrixMeasure wordNetMatrixMeasure = (WordNetMatrixMeasure)this.getSimilarity();
        String string2 = properties.getProperty("wnvers");
        if (string2 == null) {
            string2 = WNVERS;
        }
        if ((string = properties.getProperty("wnfunction")) != null) {
            if (string.equals("cosynonymySimilarity")) {
                n = 1;
            } else if (string.equals("basicSynonymySimilarity")) {
                n = 2;
            }
        }
        wordNetMatrixMeasure.init(properties.getProperty("wndict"), string2, n);
        wordNetMatrixMeasure.initialize((LoadedOntology)this.ontology1(), (LoadedOntology)this.ontology2(), alignment);
        wordNetMatrixMeasure.compute(properties);
        if (properties.getProperty("printMatrix") != null) {
            this.printDistanceMatrix(properties);
        }
        this.extract(this.type, properties);
    }

    protected class WordNetMatrixMeasure
    extends MatrixMeasure {
        protected JWNLDistances Dist = new JWNLDistances();
        protected int method = 0;

        public void init() throws AlignmentException {
            this.Dist.Initialize();
        }

        public void init(String string) throws AlignmentException {
            this.Dist.Initialize(string, JWNLAlignment.WNVERS);
        }

        public void init(String string, String string2) throws AlignmentException {
            this.Dist.Initialize(string, string2);
        }

        public void init(String string, String string2, int n) throws AlignmentException {
            this.Dist.Initialize(string, string2);
            this.method = n;
        }

        @Override
        public double measure(Object object, Object object2) throws Exception {
            String string = JWNLAlignment.this.ontology1().getEntityName(object);
            String string2 = JWNLAlignment.this.ontology2().getEntityName(object2);
            if (string == null || string2 == null) {
                return 1.0;
            }
            switch (this.method) {
                case 0: {
                    return this.Dist.basicSynonymDistance(string, string2);
                }
                case 1: {
                    return 1.0 - this.Dist.cosynonymySimilarity(string, string2);
                }
                case 2: {
                    return 1.0 - this.Dist.basicSynonymySimilarity(string, string2);
                }
            }
            return this.Dist.basicSynonymDistance(string, string2);
        }

        @Override
        public double classMeasure(Object object, Object object2) throws Exception {
            return this.measure(object, object2);
        }

        @Override
        public double propertyMeasure(Object object, Object object2) throws Exception {
            return this.measure(object, object2);
        }

        @Override
        public double individualMeasure(Object object, Object object2) throws Exception {
            if (JWNLAlignment.this.debug > 4) {
                System.err.println("ID:" + object + " -- " + object2);
            }
            return this.measure(object, object2);
        }
    }
}

