/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Hashtable;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;

public class XSLTRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Cell cell = null;
    LoadedOntology onto1 = null;
    LoadedOntology onto2 = null;
    Hashtable<String, String> namespaces = null;
    int nsrank = 0;
    boolean embedded = false;

    public XSLTRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
        this.namespaces = new Hashtable();
        this.namespaces.put("http://www.w3.org/1999/XSL/Transform", "xsl");
        this.namespaces.put("http://www.w3.org/2002/07/owl#", "owl");
        this.namespaces.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.namespaces.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
    }

    public void init(Properties properties) {
        if (properties.getProperty("embedded") != null && !properties.getProperty("embedded").equals("")) {
            this.embedded = true;
        }
    }

    public void visit(Visitable visitable) throws AlignmentException {
        if (visitable instanceof Alignment) {
            this.visit((Alignment)visitable);
        } else if (visitable instanceof Cell) {
            this.visit((Cell)visitable);
        } else if (visitable instanceof Relation) {
            this.visit((Relation)visitable);
        }
    }

    public void visit(Alignment alignment) throws AlignmentException {
        Cell cell2;
        this.alignment = alignment;
        if (alignment instanceof ObjectAlignment) {
            this.onto1 = (LoadedOntology)((ObjectAlignment)alignment).getOntologyObject1();
            this.onto2 = (LoadedOntology)((ObjectAlignment)alignment).getOntologyObject2();
        }
        for (Cell cell2 : alignment) {
            this.collectURIs(cell2);
        }
        this.alignment = alignment;
        if (!this.embedded) {
            this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        this.writer.println("<xsl:stylesheet version=\"1.0\"");
        Object object = this.namespaces.keys();
        while (object.hasMoreElements()) {
            cell2 = object.nextElement();
            this.writer.println("    xmlns:" + this.namespaces.get(cell2) + "=\"" + cell2 + "\"");
        }
        this.writer.println("  >\n");
        this.writer.print("  <!-- Generated by fr.inrialpes.exmo.impl.renderer.XSLTRendererVisitor -->\n");
        for (Cell cell2 : alignment.getExtensions()) {
            String string = cell2[1];
            this.writer.print("  <!-- " + string + ": " + (String)cell2[2] + " -->\n");
        }
        this.writer.print("\n");
        object = alignment.getElements();
        while (object.hasMoreElements()) {
            cell2 = (Cell)object.nextElement();
            cell2.accept((AlignmentVisitor)this);
        }
        this.writer.println("  <!-- Copying the root -->");
        this.writer.println("  <xsl:template match=\"/\">");
        this.writer.println("    <xsl:apply-templates/>");
        this.writer.println("  </xsl:template>");
        this.writer.println("");
        this.writer.println("  <!-- Copying all elements and attributes -->");
        this.writer.println("  <xsl:template match=\"*|@*|text()\">");
        this.writer.println("    <xsl:copy>");
        this.writer.println("      <xsl:apply-templates select=\"*|@*|text()\"/>");
        this.writer.println("    </xsl:copy>");
        this.writer.println("  </xsl:template>");
        this.writer.println("");
        this.writer.print("</xsl:stylesheet>\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        cell.getRelation().accept((AlignmentVisitor)this);
    }

    private void collectURIs(Cell cell) throws AlignmentException {
        String string;
        URI uRI;
        URI uRI2;
        if (this.onto1 != null) {
            try {
                uRI2 = this.onto1.getEntityURI(cell.getObject1());
                uRI = this.onto2.getEntityURI(cell.getObject2());
            }
            catch (OntowrapException ontowrapException) {
                throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
            }
        } else {
            uRI2 = cell.getObject1AsURI(this.alignment);
            uRI = cell.getObject2AsURI(this.alignment);
        }
        if (uRI2 != null && this.namespaces.get(string = uRI2.getScheme() + ":" + uRI2.getSchemeSpecificPart() + "#") == null) {
            this.namespaces.put(string, "ns" + this.nsrank++);
        }
        if (uRI != null && this.namespaces.get(string = uRI.getScheme() + ":" + uRI.getSchemeSpecificPart() + "#") == null) {
            this.namespaces.put(string, "ns" + this.nsrank++);
        }
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        if (this.onto1 != null) {
            try {
                this.writer.println("  <xsl:template match=\"" + this.namespacify(this.onto1.getEntityURI(this.cell.getObject1())) + "\">");
                this.writer.println("    <xsl:element name=\"" + this.namespacify(this.onto2.getEntityURI(this.cell.getObject2())) + "\">");
            }
            catch (OntowrapException ontowrapException) {
                throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
            }
        } else {
            this.writer.println("  <xsl:template match=\"" + this.namespacify(this.cell.getObject1AsURI(this.alignment)) + "\">");
            this.writer.println("    <xsl:element name=\"" + this.namespacify(this.cell.getObject2AsURI(this.alignment)) + "\">");
        }
        this.writer.println("      <xsl:apply-templates select=\"*|@*|text()\"/>");
        this.writer.println("    </xsl:element>");
        this.writer.println("  </xsl:template>\n");
    }

    private String namespacify(URI uRI) {
        String string = uRI.getScheme() + ":" + uRI.getSchemeSpecificPart() + "#";
        return this.namespaces.get(string) + ":" + uRI.getFragment();
    }

    public void visit(SubsumeRelation subsumeRelation) {
    }

    public void visit(SubsumedRelation subsumedRelation) {
    }

    public void visit(IncompatRelation incompatRelation) {
    }

    public void visit(Relation relation) throws AlignmentException {
        try {
            Method method = null;
            if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
            }
            if (method != null) {
                method.invoke((Object)this, relation);
            }
        }
        catch (Exception exception) {
            throw new AlignmentException("Dispatching problem ", exception);
        }
    }
}

