/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.Namespace;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Visitable;

public class XMLMetadataRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    boolean embedded = false;
    Hashtable<String, String> nslist = null;
    boolean newstyle = false;

    public XMLMetadataRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void init(Properties properties) {
        if (properties.getProperty("embedded") != null && !properties.getProperty("embedded").equals("")) {
            this.embedded = true;
        }
    }

    public void visit(Visitable visitable) throws AlignmentException {
        if (visitable instanceof Alignment) {
            this.visit((Alignment)visitable);
        }
    }

    public void visit(Alignment alignment) throws AlignmentException {
        Object object2;
        String string = "";
        this.alignment = alignment;
        this.nslist = new Hashtable();
        this.nslist.put(Namespace.ALIGNMENT.uri, "align");
        this.nslist.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.nslist.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        int n = 0;
        for (Object object2 : alignment.getExtensions()) {
            String string2 = object2[0];
            String string3 = object2[1];
            String string4 = this.nslist.get(string2);
            if (string4 == null) {
                string4 = "ns" + n++;
                this.nslist.put(string2, string4);
            }
            string4 = string4.equals("align") ? string3 : string4 + ":" + string3;
            string = string + "  <" + string4 + ">" + object2[2] + "</" + string4 + ">\n";
        }
        if (!this.embedded) {
            this.writer.print("<?xml version='1.0' encoding='utf-8");
            this.writer.print("' standalone='no'?>\n");
        }
        this.writer.print("<rdf:RDF xmlns='" + Namespace.ALIGNMENT.uri + "'");
        Object object3 = this.nslist.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            this.writer.print("\n         xmlns:" + this.nslist.get(object2) + "='" + (String)object2 + "'");
        }
        if (alignment instanceof BasicAlignment) {
            object3 = ((BasicAlignment)alignment).getXNamespaces().getNames();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (((String)object2).equals("rdf") || ((String)object2).equals("xsd") || ((String)object2).equals("<default>")) continue;
                this.writer.print("\n         xmlns:" + (String)object2 + "='" + ((BasicAlignment)alignment).getXNamespace((String)object2) + "'");
            }
        }
        this.writer.print(">\n");
        this.writer.print("<Alignment");
        object3 = alignment.getExtension(Namespace.ALIGNMENT.uri, Annotations.ID);
        if (object3 != null) {
            this.writer.print(" rdf:about=\"" + (String)object3 + "\"");
        }
        this.writer.print(">\n  <xml>yes</xml>\n");
        this.writer.print("  <level>");
        this.writer.print(alignment.getLevel());
        this.writer.print("</level>\n  <type>");
        this.writer.print(alignment.getType());
        this.writer.print("</type>\n");
        if (alignment.getFile1() != null) {
            this.writer.print("  <onto1>" + alignment.getFile1().toString() + "</onto1>\n");
        }
        if (alignment.getFile2() != null) {
            this.writer.print("  <onto2>" + alignment.getFile2().toString() + "</onto2>\n");
        }
        this.writer.print("  <uri1>");
        this.writer.print(alignment.getOntology1URI().toString());
        this.writer.print("</uri1>\n");
        this.writer.print("  <uri2>");
        this.writer.print(alignment.getOntology2URI().toString());
        this.writer.print("</uri2>\n");
        this.writer.print(string);
        if (this.newstyle) {
            this.writer.print("  <onto1>\n    <Ontology");
            if (alignment.getOntology1URI() != null) {
                this.writer.print(" rdf:about=\"" + alignment.getOntology1URI() + "\"");
            }
            this.writer.print(">\n      <location>" + alignment.getFile1() + "</location>");
            if (alignment instanceof BasicAlignment && ((BasicAlignment)alignment).getOntologyObject1().getFormalism() != null) {
                this.writer.print("\n      <formalism>\n        <Formalism align:name=\"" + ((BasicAlignment)alignment).getOntologyObject1().getFormalism() + "\" align:uri=\"" + ((BasicAlignment)alignment).getOntologyObject1().getFormURI() + "\"/>\n      </formalism>");
            }
            this.writer.print("\n    </Ontology>\n  </onto1>\n");
            this.writer.print("  <onto2>\n    <Ontology");
            if (alignment.getOntology2URI() != null) {
                this.writer.print(" rdf:about=\"" + alignment.getOntology2URI() + "\"");
            }
            this.writer.print(">\n      <location>" + alignment.getFile2() + "</location>");
            if (alignment instanceof BasicAlignment && ((BasicAlignment)alignment).getOntologyObject2().getFormalism() != null) {
                this.writer.print("\n      <formalism>\n        <Formalism align:name=\"" + ((BasicAlignment)alignment).getOntologyObject2().getFormalism() + "\" align:uri=\"" + ((BasicAlignment)alignment).getOntologyObject2().getFormURI() + "\"/>\n      </formalism>");
            }
            this.writer.print("\n    </Ontology>\n  </onto2>\n");
        }
        this.writer.print("</Alignment>\n");
        this.writer.print("</rdf:RDF>\n");
    }
}

