/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;

public class SWRLRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    LoadedOntology onto1 = null;
    LoadedOntology onto2 = null;
    Cell cell = null;
    boolean embedded = false;

    public SWRLRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void init(Properties properties) {
        if (properties.getProperty("embedded") != null && !properties.getProperty("embedded").equals("")) {
            this.embedded = true;
        }
    }

    public void visit(Visitable visitable) throws AlignmentException {
        if (visitable instanceof Alignment) {
            this.visit((Alignment)visitable);
        } else if (visitable instanceof Cell) {
            this.visit((Cell)visitable);
        } else if (visitable instanceof Relation) {
            this.visit((Relation)visitable);
        }
    }

    public void visit(Alignment alignment) throws AlignmentException {
        if (!(alignment instanceof ObjectAlignment)) {
            throw new AlignmentException("SWRLRenderer: cannot render simple alignment. Turn them into ObjectAlignment, by toObjectAlignement()");
        }
        this.alignment = alignment;
        this.onto1 = (LoadedOntology)((ObjectAlignment)this.alignment).getOntologyObject1();
        this.onto2 = (LoadedOntology)((ObjectAlignment)this.alignment).getOntologyObject2();
        if (!this.embedded) {
            this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
        this.writer.println("<swrlx:Ontology swrlx:name=\"generatedAl\"");
        this.writer.println("                xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        this.writer.println("                xmlns:swrlx=\"http://www.w3.org/2003/11/swrlx#\"");
        this.writer.println("                xmlns:owlx=\"http://www.w3.org/2003/05/owl-xml\"");
        this.writer.println("                xmlns:ruleml=\"http://www.w3.org/2003/11/ruleml#\">");
        this.writer.print("\n  <!-- Generated by fr.inrialpes.exmo.impl.renderer.SWRLRendererVisitor -->\n");
        for (Cell cell : alignment.getExtensions()) {
            this.writer.print("  <owlx:Annotation><owlx:Documentation>" + cell[1] + ": " + cell[2] + "</owlx:Documentation></owlx:Annotation>\n");
        }
        this.writer.print("\n");
        this.writer.println("  <owlx:Imports rdf:resource=\"" + this.onto1.getURI() + "\"/>\n");
        for (Cell cell : alignment) {
            cell.accept((AlignmentVisitor)this);
        }
        this.writer.println("</swrlx:Ontology>");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        cell.getRelation().accept((AlignmentVisitor)this);
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        URI uRI;
        URI uRI2;
        Object object = this.cell.getObject1();
        try {
            uRI2 = this.onto1.getEntityURI(object);
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot find entity URI(1)", (Exception)((Object)ontowrapException));
        }
        this.writer.println("  <ruleml:imp>");
        this.writer.println("    <ruleml:_body>");
        if (this.onto1.isClass(object)) {
            this.writer.println("      <swrl:classAtom>");
            this.writer.println("        <owllx:Class owllx:name=\"" + uRI2 + "\"/>");
            this.writer.println("        <ruleml:var>x</ruleml:var>");
            this.writer.println("      </swrl:classAtom>");
        } else if (this.onto1.isDataProperty(object)) {
            this.writer.println("      <swrl:datavaluedPropertyAtom swrlx:property=\"" + uRI2 + "\"/>");
            this.writer.println("        <ruleml:var>x</ruleml:var>");
            this.writer.println("        <ruleml:var>y</ruleml:var>");
            this.writer.println("      <swrl:datavaluedPropertyAtom>");
        } else {
            this.writer.println("      <swrl:individualPropertyAtom swrlx:property=\"" + uRI2 + "\"/>");
            this.writer.println("        <ruleml:var>x</ruleml:var>");
            this.writer.println("        <ruleml:var>y</ruleml:var>");
            this.writer.println("      </swrl:individualPropertyAtom>");
        }
        this.writer.println("    </ruleml:_body>");
        this.writer.println("    <ruleml:_head>");
        Object object2 = this.cell.getObject2();
        try {
            uRI = this.onto2.getEntityURI(object2);
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot find entity URI(2)", (Exception)((Object)ontowrapException));
        }
        if (this.onto2.isClass(object2)) {
            this.writer.println("      <swrlx:classAtom>");
            this.writer.println("        <owllx:Class owllx:name=\"" + uRI + "\"/>");
            this.writer.println("        <ruleml:var>x</ruleml:var>");
            this.writer.println("      </swrl:classAtom>");
        } else if (this.onto2.isDataProperty(object2)) {
            this.writer.println("      <swrl:datavaluedPropertyAtom swrlx:property=\"" + uRI + "\"/>");
            this.writer.println("        <ruleml:var>x</ruleml:var>");
            this.writer.println("        <ruleml:var>y</ruleml:var>");
            this.writer.println("      </swrl:datavaluedPropertyAtom>");
        } else {
            this.writer.println("      <swrl:individualPropertyAtom swrlx:property=\"" + uRI + "\"/>");
            this.writer.println("        <ruleml:var>x</ruleml:var>");
            this.writer.println("        <ruleml:var>y</ruleml:var>");
            this.writer.println("      </swrl:individualPropertyAtom>");
        }
        this.writer.println("    </ruleml:_head>");
        this.writer.println("  </ruleml:imp>\n");
    }

    public void visit(SubsumeRelation subsumeRelation) {
    }

    public void visit(SubsumedRelation subsumedRelation) {
    }

    public void visit(IncompatRelation incompatRelation) {
    }

    public void visit(Relation relation) throws AlignmentException {
        try {
            Method method = null;
            if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
            }
            if (method != null) {
                method.invoke((Object)this, relation);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

