/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;

public class SKOSRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    LoadedOntology onto1 = null;
    LoadedOntology onto2 = null;
    Cell cell = null;
    boolean embedded = false;
    boolean pre2008 = false;

    public SKOSRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void init(Properties properties) {
        if (properties.getProperty("embedded") != null && !properties.getProperty("embedded").equals("")) {
            this.embedded = true;
        }
        if (properties.getProperty("pre2008") != null && !properties.getProperty("pre2008").equals("")) {
            this.pre2008 = true;
        }
    }

    public void visit(Visitable visitable) throws AlignmentException {
        if (visitable instanceof Alignment) {
            this.visit((Alignment)visitable);
        } else if (visitable instanceof Cell) {
            this.visit((Cell)visitable);
        } else if (visitable instanceof Relation) {
            this.visit((Relation)visitable);
        }
    }

    public void visit(Alignment alignment) throws AlignmentException {
        this.alignment = alignment;
        if (alignment instanceof ObjectAlignment) {
            this.onto1 = (LoadedOntology)((ObjectAlignment)alignment).getOntologyObject1();
            this.onto2 = (LoadedOntology)((ObjectAlignment)alignment).getOntologyObject2();
        }
        if (!this.embedded) {
            this.writer.print("<?xml version='1.0' encoding='utf-8");
            this.writer.print("' standalone='no'?>\n");
        }
        this.writer.print("<rdf:RDF\n");
        this.writer.print("  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n");
        this.writer.print("  xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"\n");
        if (this.pre2008) {
            this.writer.print("  xmlns:skos=\"http://www.w3.org/2004/02/skos/core#\">\n\n");
        } else {
            this.writer.print("  xmlns:skos=\"http://www.w3.org/2008/05/skos#\">\n\n");
        }
        this.writer.print("  <!-- Generated by fr.inrialpes.exmo.impl.renderer.SKOSRendererVisitor -->\n");
        for (Cell cell : alignment.getExtensions()) {
            this.writer.print("  <!-- " + cell[1] + ": " + (String)cell[2] + " -->\n");
        }
        this.writer.print("\n");
        for (Cell cell : alignment) {
            cell.accept((AlignmentVisitor)this);
        }
        this.writer.print("</rdf:RDF>\n");
    }

    public URI getURI2() throws AlignmentException {
        if (this.onto2 != null) {
            try {
                return this.onto2.getEntityURI(this.cell.getObject2());
            }
            catch (OntowrapException ontowrapException) {
                throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
            }
        }
        return this.cell.getObject2AsURI(this.alignment);
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        if (this.onto1 != null) {
            try {
                this.writer.print("  <skos:Concept rdf:about=\"" + this.onto1.getEntityURI(cell.getObject1()) + "\">\n");
            }
            catch (OntowrapException ontowrapException) {
                throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
            }
        } else {
            this.writer.print("  <skos:Concept rdf:about=\"" + cell.getObject1AsURI(this.alignment) + "\">\n");
        }
        cell.getRelation().accept((AlignmentVisitor)this);
        this.writer.print("  </skos:Concept>\n\n");
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        if (this.pre2008) {
            this.writer.print("    <skos:related rdf:resource=\"" + this.getURI2() + "\"/>\n");
        } else {
            this.writer.print("    <skos:exactMatch rdf:resource=\"" + this.getURI2() + "\"/>\n");
        }
    }

    public void visit(SubsumeRelation subsumeRelation) throws AlignmentException {
        if (this.pre2008) {
            this.writer.print("    <skos:narrower rdf:resource=\"" + this.getURI2() + "\"/>\n");
        } else {
            this.writer.print("    <skos:narrowMatch rdf:resource=\"" + this.getURI2() + "\"/>\n");
        }
    }

    public void visit(SubsumedRelation subsumedRelation) throws AlignmentException {
        if (this.pre2008) {
            this.writer.print("    <skos:broader rdf:resource=\"" + this.getURI2() + "\"/>\n");
        } else {
            this.writer.print("    <skos:broadMatch rdf:resource=\"" + this.getURI2() + "\"/>\n");
        }
    }

    public void visit(IncompatRelation incompatRelation) throws AlignmentException {
        throw new AlignmentException("Cannot translate in SKOS" + incompatRelation);
    }

    public void visit(Relation relation) throws AlignmentException {
        try {
            Method method = null;
            if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
            }
            if (method != null) {
                method.invoke((Object)this, relation);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

