/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Random;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;

public class SEKTMappingRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    LoadedOntology onto1 = null;
    LoadedOntology onto2 = null;
    Cell cell = null;
    Random generator = null;

    public SEKTMappingRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
        this.generator = new Random();
    }

    public void init(Properties properties) {
    }

    public void visit(Visitable visitable) throws AlignmentException {
        if (visitable instanceof Alignment) {
            this.visit((Alignment)visitable);
        } else if (visitable instanceof Cell) {
            this.visit((Cell)visitable);
        } else if (visitable instanceof Relation) {
            this.visit((Relation)visitable);
        }
    }

    public void visit(Alignment alignment) throws AlignmentException {
        if (!(alignment instanceof ObjectAlignment)) {
            throw new AlignmentException("SEKTMappingRenderer: cannot render simple alignment. Turn them into ObjectAlignment, by toObjectAlignement()");
        }
        this.alignment = alignment;
        this.onto1 = (LoadedOntology)((ObjectAlignment)this.alignment).getOntologyObject1();
        this.onto2 = (LoadedOntology)((ObjectAlignment)this.alignment).getOntologyObject2();
        this.writer.print("MappingDocument(<\"\">\n");
        this.writer.print("  source(<\"" + this.onto1.getURI() + "\">)\n");
        this.writer.print("  target(<\"" + this.onto2.getURI() + "\">)\n");
        for (Cell cell : alignment) {
            cell.accept((AlignmentVisitor)this);
        }
        this.writer.print(")\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        String string = String.format("s%06d", this.generator.nextInt(100000));
        Object object = cell.getObject1();
        Object object2 = cell.getObject2();
        try {
            if (this.onto1.isClass(object)) {
                this.writer.print("  classMapping( <\"#" + string + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("    <\"" + this.onto1.getEntityURI(object) + "\">\n");
                this.writer.print("    <\"" + this.onto2.getEntityURI(object2) + "\">\n");
                this.writer.print("  )\n");
            } else if (this.onto1.isDataProperty(object)) {
                this.writer.print("  relationMapping( <\"#" + string + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("    <\"" + this.onto1.getEntityURI(object) + "\">\n");
                this.writer.print("    <\"" + this.onto2.getEntityURI(object2) + "\">\n");
                this.writer.print("  )\n");
            } else if (this.onto1.isObjectProperty(object)) {
                this.writer.print("  attributeMapping( <\"#" + string + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("    <\"" + this.onto1.getEntityURI(object) + "\">\n");
                this.writer.print("    <\"" + this.onto2.getEntityURI(object2) + "\">\n");
                this.writer.print("  )\n");
            } else if (this.onto1.isIndividual(object)) {
                this.writer.print("  instanceMapping( <\"#" + string + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("    <\"" + this.onto1.getEntityURI(object) + "\">\n");
                this.writer.print("    <\"" + this.onto2.getEntityURI(object2) + "\">\n");
                this.writer.print("  )\n");
            }
            this.writer.print("\n");
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
        }
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        this.writer.print("    bidirectional\n");
    }

    public void visit(SubsumeRelation subsumeRelation) throws AlignmentException {
        this.writer.print("    unidirectional\n");
    }

    public void visit(SubsumedRelation subsumedRelation) throws AlignmentException {
        this.writer.print("    unidirectional\n");
    }

    public void visit(IncompatRelation incompatRelation) throws AlignmentException {
        this.writer.print("    unidirectional\n");
    }

    public void visit(Relation relation) throws AlignmentException {
        try {
            Method method = null;
            if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
            }
            if (method != null) {
                method.invoke((Object)this, relation);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

