/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.Namespace;
import fr.inrialpes.exmo.align.impl.edoal.Apply;
import fr.inrialpes.exmo.align.impl.edoal.ClassConstruction;
import fr.inrialpes.exmo.align.impl.edoal.ClassDomainRestriction;
import fr.inrialpes.exmo.align.impl.edoal.ClassExpression;
import fr.inrialpes.exmo.align.impl.edoal.ClassId;
import fr.inrialpes.exmo.align.impl.edoal.ClassOccurenceRestriction;
import fr.inrialpes.exmo.align.impl.edoal.ClassRestriction;
import fr.inrialpes.exmo.align.impl.edoal.ClassTypeRestriction;
import fr.inrialpes.exmo.align.impl.edoal.ClassValueRestriction;
import fr.inrialpes.exmo.align.impl.edoal.Datatype;
import fr.inrialpes.exmo.align.impl.edoal.Expression;
import fr.inrialpes.exmo.align.impl.edoal.InstanceExpression;
import fr.inrialpes.exmo.align.impl.edoal.InstanceId;
import fr.inrialpes.exmo.align.impl.edoal.PathExpression;
import fr.inrialpes.exmo.align.impl.edoal.PropertyConstruction;
import fr.inrialpes.exmo.align.impl.edoal.PropertyDomainRestriction;
import fr.inrialpes.exmo.align.impl.edoal.PropertyExpression;
import fr.inrialpes.exmo.align.impl.edoal.PropertyId;
import fr.inrialpes.exmo.align.impl.edoal.PropertyRestriction;
import fr.inrialpes.exmo.align.impl.edoal.PropertyTypeRestriction;
import fr.inrialpes.exmo.align.impl.edoal.PropertyValueRestriction;
import fr.inrialpes.exmo.align.impl.edoal.RelationCoDomainRestriction;
import fr.inrialpes.exmo.align.impl.edoal.RelationConstruction;
import fr.inrialpes.exmo.align.impl.edoal.RelationDomainRestriction;
import fr.inrialpes.exmo.align.impl.edoal.RelationExpression;
import fr.inrialpes.exmo.align.impl.edoal.RelationId;
import fr.inrialpes.exmo.align.impl.edoal.RelationRestriction;
import fr.inrialpes.exmo.align.impl.edoal.TransfService;
import fr.inrialpes.exmo.align.impl.edoal.Value;
import fr.inrialpes.exmo.align.impl.edoal.ValueExpression;
import fr.inrialpes.exmo.align.parser.SyntaxElement;
import fr.inrialpes.exmo.ontowrap.Ontology;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Hashtable;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;

public class RDFRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Cell cell = null;
    Hashtable<String, String> nslist = null;
    boolean embedded = false;
    private static Namespace DEF = Namespace.ALIGNMENT;
    private String INDENT = "  ";
    private String NL = System.getProperty("line.separator");
    private String linePrefix = "";
    private int prefixCount = 0;
    private boolean isPattern = false;

    public RDFRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void setIndentString(String string) {
        this.INDENT = string;
    }

    public void setNewLineString(String string) {
        this.NL = string;
    }

    public void init(Properties properties) {
        if (properties.getProperty("embedded") != null && !properties.getProperty("embedded").equals("")) {
            this.embedded = true;
        }
        if (properties.getProperty("indent") != null) {
            this.INDENT = properties.getProperty("indent");
        }
        if (properties.getProperty("newline") != null) {
            this.NL = properties.getProperty("newline");
        }
    }

    public void visit(Visitable visitable) throws AlignmentException {
        if (visitable instanceof ClassExpression) {
            this.visit((ClassExpression)visitable);
        } else if (visitable instanceof TransfService) {
            this.visit((TransfService)visitable);
        } else if (visitable instanceof RelationRestriction) {
            this.visit((RelationRestriction)visitable);
        } else if (visitable instanceof PropertyRestriction) {
            this.visit((PropertyRestriction)visitable);
        } else if (visitable instanceof ClassRestriction) {
            this.visit((ClassRestriction)visitable);
        } else if (visitable instanceof PathExpression) {
            this.visit((PathExpression)visitable);
        } else if (visitable instanceof PropertyExpression) {
            this.visit((PropertyExpression)visitable);
        } else if (visitable instanceof InstanceExpression) {
            this.visit((InstanceExpression)visitable);
        } else if (visitable instanceof RelationExpression) {
            this.visit((RelationExpression)visitable);
        } else if (visitable instanceof Expression) {
            this.visit((Expression)visitable);
        } else if (visitable instanceof Cell) {
            this.visit((Cell)visitable);
        } else if (visitable instanceof Relation) {
            this.visit((Relation)visitable);
        } else if (visitable instanceof Alignment) {
            this.visit((Alignment)visitable);
        }
    }

    public void visit(Alignment alignment) throws AlignmentException {
        Object object2;
        String string = "";
        this.alignment = alignment;
        this.nslist = new Hashtable();
        this.nslist.put(Namespace.ALIGNMENT.prefix, Namespace.ALIGNMENT.shortCut);
        this.nslist.put(Namespace.RDF.prefix, Namespace.RDF.shortCut);
        this.nslist.put(Namespace.XSD.prefix, Namespace.XSD.shortCut);
        int n = 0;
        for (Object object2 : alignment.getExtensions()) {
            String string2 = object2[0];
            String string3 = object2[1];
            String string4 = this.nslist.get(string2);
            if (string2.equals(Namespace.ALIGNMENT.uri)) {
                string4 = string3;
            } else {
                if (string4 == null) {
                    string4 = "ns" + n++;
                    this.nslist.put(string2, string4);
                }
                string4 = string4 + ":" + string3;
            }
            string = string + this.INDENT + "<" + string4 + ">" + object2[2] + "</" + string4 + ">" + this.NL;
        }
        if (!this.embedded) {
            this.writer.print("<?xml version='1.0' encoding='utf-8");
            this.writer.print("' standalone='no'?>" + this.NL);
        }
        this.writer.print("<" + SyntaxElement.RDF.print(DEF) + " xmlns='" + Namespace.ALIGNMENT.prefix + "'");
        Object object3 = this.nslist.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            this.writer.print(this.NL + this.INDENT + this.INDENT + this.INDENT + this.INDENT + " xmlns:" + this.nslist.get(object2) + "='" + (String)object2 + "'");
        }
        if (alignment instanceof BasicAlignment) {
            object3 = ((BasicAlignment)alignment).getXNamespaces().getNames();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (((String)object2).equals("rdf") || ((String)object2).equals("xsd") || ((String)object2).equals("<default>")) continue;
                this.writer.print(this.NL + this.INDENT + this.INDENT + this.INDENT + this.INDENT + " xmlns:" + (String)object2 + "='" + ((BasicAlignment)alignment).getXNamespace((String)object2) + "'");
            }
        }
        this.writer.print(">" + this.NL);
        this.indentedOutput("<" + SyntaxElement.ALIGNMENT.print(DEF));
        object3 = alignment.getExtension(Namespace.ALIGNMENT.uri, Annotations.ID);
        if (object3 != null) {
            this.writer.print(" " + SyntaxElement.RDF_ABOUT.print(DEF) + "=\"" + (String)object3 + "\"");
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.indentedOutputln("<" + SyntaxElement.XML.print(DEF) + ">yes</" + SyntaxElement.XML.print(DEF) + ">");
        if (this.alignment.getLevel().startsWith("2EDOALPattern")) {
            this.isPattern = true;
        }
        this.indentedOutputln("<" + SyntaxElement.LEVEL.print(DEF) + ">" + alignment.getLevel() + "</" + SyntaxElement.LEVEL.print(DEF) + ">");
        this.indentedOutputln("<" + SyntaxElement.TYPE.print(DEF) + ">" + alignment.getType() + "</" + SyntaxElement.TYPE.print(DEF) + ">");
        this.writer.print(string);
        this.indentedOutputln("<" + SyntaxElement.MAPPING_SOURCE.print(DEF) + ">");
        this.increaseIndent();
        if (alignment instanceof BasicAlignment) {
            this.printOntology(((BasicAlignment)alignment).getOntologyObject1());
        } else {
            this.printBasicOntology(alignment.getOntology1URI(), alignment.getFile1());
        }
        this.decreaseIndent();
        this.indentedOutputln("</" + SyntaxElement.MAPPING_SOURCE.print(DEF) + ">");
        this.indentedOutputln("<" + SyntaxElement.MAPPING_TARGET.print(DEF) + ">");
        this.increaseIndent();
        if (alignment instanceof BasicAlignment) {
            this.printOntology(((BasicAlignment)alignment).getOntologyObject2());
        } else {
            this.printBasicOntology(alignment.getOntology2URI(), alignment.getFile2());
        }
        this.decreaseIndent();
        this.indentedOutputln("</" + SyntaxElement.MAPPING_TARGET.print(DEF) + ">");
        for (String string2 : alignment) {
            string2.accept((AlignmentVisitor)this);
        }
        this.decreaseIndent();
        this.indentedOutputln("</" + SyntaxElement.ALIGNMENT.print(DEF) + ">");
        this.writer.print("</" + SyntaxElement.RDF.print(DEF) + ">" + this.NL);
    }

    private void printBasicOntology(URI uRI, URI uRI2) {
        this.indentedOutput("<" + SyntaxElement.ONTOLOGY.print(DEF) + " " + SyntaxElement.RDF_ABOUT.print(DEF) + "=\"" + uRI + "\">" + this.NL);
        this.increaseIndent();
        if (uRI2 != null) {
            this.indentedOutputln("<" + SyntaxElement.LOCATION.print(DEF) + ">" + uRI2 + "</" + SyntaxElement.LOCATION.print(DEF) + ">");
        } else {
            this.indentedOutputln("<" + SyntaxElement.LOCATION.print(DEF) + ">" + uRI + "</" + SyntaxElement.LOCATION.print(DEF) + ">");
        }
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.ONTOLOGY.print(DEF) + ">" + this.NL);
    }

    public void printOntology(Ontology ontology) {
        URI uRI = ontology.getURI();
        URI uRI2 = ontology.getFile();
        this.indentedOutput("<" + SyntaxElement.ONTOLOGY.print(DEF) + " " + SyntaxElement.RDF_ABOUT.print(DEF) + "=\"" + uRI + "\">" + this.NL);
        this.increaseIndent();
        if (uRI2 != null) {
            this.indentedOutputln("<" + SyntaxElement.LOCATION.print(DEF) + ">" + uRI2 + "</" + SyntaxElement.LOCATION.print(DEF) + ">");
        } else {
            this.indentedOutputln("<" + SyntaxElement.LOCATION.print(DEF) + ">" + uRI + "</" + SyntaxElement.LOCATION.print(DEF) + ">");
        }
        if (ontology.getFormalism() != null) {
            this.indentedOutputln("<" + SyntaxElement.FORMATT.print(DEF) + ">");
            this.increaseIndent();
            this.indentedOutputln("<" + SyntaxElement.FORMALISM.print(DEF) + " " + SyntaxElement.NAME.print() + "=\"" + ontology.getFormalism() + "\" " + SyntaxElement.URI.print() + "=\"" + ontology.getFormURI() + "\"/>");
            this.decreaseIndent();
            this.indentedOutputln("</" + SyntaxElement.FORMATT.print(DEF) + ">");
        }
        this.decreaseIndent();
        this.indentedOutputln("</" + SyntaxElement.ONTOLOGY.print(DEF) + ">");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        URI uRI = cell.getObject1AsURI(this.alignment);
        URI uRI2 = cell.getObject2AsURI(this.alignment);
        if (uRI != null && uRI2 != null || this.alignment.getLevel().startsWith("2EDOAL")) {
            this.indentedOutputln("<" + SyntaxElement.MAP.print(DEF) + ">");
            this.increaseIndent();
            this.indentedOutput("<" + SyntaxElement.CELL.print(DEF));
            if (cell.getId() != null && !cell.getId().equals("")) {
                this.writer.print(" " + SyntaxElement.RDF_ABOUT.print(DEF) + "=\"" + cell.getId() + "\"");
            }
            this.writer.print(">" + this.NL);
            this.increaseIndent();
            if (this.alignment.getLevel().startsWith("2EDOAL")) {
                this.indentedOutputln("<" + SyntaxElement.ENTITY1.print(DEF) + ">");
                this.increaseIndent();
                ((Expression)cell.getObject1()).accept(this);
                this.decreaseIndent();
                this.writer.print(this.NL);
                this.indentedOutputln("</" + SyntaxElement.ENTITY1.print(DEF) + ">");
                this.indentedOutputln("<" + SyntaxElement.ENTITY2.print(DEF) + ">");
                this.increaseIndent();
                ((Expression)cell.getObject2()).accept(this);
                this.decreaseIndent();
                this.writer.print(this.NL);
                this.indentedOutputln("</" + SyntaxElement.ENTITY2.print(DEF) + ">");
            } else {
                this.indentedOutputln("<" + SyntaxElement.ENTITY1.print(DEF) + " " + SyntaxElement.RDF_RESOURCE.print(DEF) + "='" + uRI.toString() + "'/>");
                this.indentedOutputln("<" + SyntaxElement.ENTITY2.print(DEF) + " " + SyntaxElement.RDF_RESOURCE.print(DEF) + "='" + uRI2.toString() + "'/>");
            }
            this.indentedOutput("<" + SyntaxElement.RULE_RELATION.print(DEF) + ">");
            cell.getRelation().accept((AlignmentVisitor)this);
            this.writer.print("</" + SyntaxElement.RULE_RELATION.print(DEF) + ">" + this.NL);
            this.indentedOutputln("<" + SyntaxElement.MEASURE.print(DEF) + " " + SyntaxElement.RDF_DATATYPE.print(DEF) + "='" + Namespace.XSD.getUriPrefix() + "float'>" + cell.getStrength() + "</" + SyntaxElement.MEASURE.print(DEF) + ">");
            if (cell.getSemantics() != null && !cell.getSemantics().equals("") && !cell.getSemantics().equals("first-order")) {
                this.indentedOutputln("<" + SyntaxElement.SEMANTICS.print(DEF) + ">" + cell.getSemantics() + "</" + SyntaxElement.SEMANTICS.print(DEF) + ">");
            }
            if (cell.getExtensions() != null) {
                for (String[] stringArray : cell.getExtensions()) {
                    String string = stringArray[0];
                    String string2 = this.nslist.get(string);
                    if (string2 == null) {
                        string2 = stringArray[1];
                        this.indentedOutputln("<alignapilocalns:" + string2 + " xmlns:alignapilocalns=\"" + string + "\">" + stringArray[2] + "</alignapilocalns:" + string2 + ">");
                        continue;
                    }
                    string2 = string2 + ":" + stringArray[1];
                    this.indentedOutputln("<" + string2 + ">" + stringArray[2] + "</" + string2 + ">");
                }
            }
            this.decreaseIndent();
            this.indentedOutputln("</" + SyntaxElement.CELL.print(DEF) + ">");
            this.decreaseIndent();
            this.indentedOutputln("</" + SyntaxElement.MAP.print(DEF) + ">");
        }
    }

    public void visit(Relation relation) {
        relation.write(this.writer);
    }

    public void visit(Expression expression) throws AlignmentException {
        throw new AlignmentException("Cannot export abstract Expression: " + expression);
    }

    public void visit(PathExpression pathExpression) throws AlignmentException {
        if (pathExpression instanceof RelationExpression) {
            this.visit((RelationExpression)pathExpression);
        } else if (pathExpression instanceof PropertyExpression) {
            this.visit((PropertyExpression)pathExpression);
        } else {
            throw new AlignmentException("Cannot dispatch PathExpression " + pathExpression);
        }
    }

    public void visit(ClassExpression classExpression) throws AlignmentException {
        if (classExpression instanceof ClassId) {
            this.visit((ClassId)classExpression);
        } else if (classExpression instanceof ClassConstruction) {
            this.visit((ClassConstruction)classExpression);
        } else if (classExpression instanceof ClassRestriction) {
            this.visit((ClassRestriction)classExpression);
        } else {
            throw new AlignmentException("Cannot dispatch ClassExpression " + classExpression);
        }
    }

    public void renderVariables(Expression expression) {
        if (expression.getVariable() != null) {
            this.writer.print(" " + SyntaxElement.VAR.print(DEF) + "=\"" + expression.getVariable().name());
        }
    }

    public void visit(ClassId classId) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.CLASS_EXPR.print(DEF));
        if (classId.getURI() != null) {
            this.writer.print(" " + SyntaxElement.RDF_ABOUT.print(DEF));
            this.writer.print("=\"" + classId.getURI() + "\"");
        }
        if (this.isPattern) {
            this.renderVariables(classId);
        }
        this.writer.print("/>");
    }

    public void visit(ClassConstruction classConstruction) throws AlignmentException {
        SyntaxElement.Constructor constructor = classConstruction.getOperator();
        String string = SyntaxElement.getElement(constructor).print(DEF);
        this.indentedOutput("<" + SyntaxElement.CLASS_EXPR.print(DEF));
        if (this.isPattern) {
            this.renderVariables(classConstruction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.indentedOutput("<" + string);
        if (constructor == SyntaxElement.Constructor.AND || constructor == SyntaxElement.Constructor.OR) {
            this.writer.print(" " + SyntaxElement.RDF_PARSETYPE.print(DEF) + "=\"Collection\"");
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        for (ClassExpression classExpression : classConstruction.getComponents()) {
            this.writer.print(this.linePrefix);
            this.visit(classExpression);
            this.writer.print(this.NL);
        }
        this.decreaseIndent();
        this.indentedOutput("</" + string + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.CLASS_EXPR.print(DEF) + ">");
    }

    public void visit(ClassRestriction classRestriction) throws AlignmentException {
        if (classRestriction instanceof ClassValueRestriction) {
            this.visit((ClassValueRestriction)classRestriction);
        } else if (classRestriction instanceof ClassTypeRestriction) {
            this.visit((ClassTypeRestriction)classRestriction);
        } else if (classRestriction instanceof ClassDomainRestriction) {
            this.visit((ClassDomainRestriction)classRestriction);
        } else if (classRestriction instanceof ClassOccurenceRestriction) {
            this.visit((ClassOccurenceRestriction)classRestriction);
        } else {
            throw new AlignmentException("Cannot dispatch ClassExpression " + classRestriction);
        }
    }

    public void visit(ClassValueRestriction classValueRestriction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.VALUE_COND.print(DEF));
        if (this.isPattern) {
            this.renderVariables(classValueRestriction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.indentedOutput("<" + SyntaxElement.ONPROPERTY.print(DEF) + ">" + this.NL);
        this.increaseIndent();
        this.visit(classValueRestriction.getRestrictionPath());
        this.decreaseIndent();
        this.writer.print(this.NL);
        this.indentedOutputln("</" + SyntaxElement.ONPROPERTY.print(DEF) + ">");
        this.indentedOutput("<" + SyntaxElement.COMPARATOR.print(DEF));
        this.writer.print(" " + SyntaxElement.RDF_RESOURCE.print(DEF));
        this.writer.print("=\"" + classValueRestriction.getComparator().getURI());
        this.writer.print("\"/>" + this.NL);
        this.indentedOutput("<" + SyntaxElement.VALUE.print(DEF) + ">");
        this.visit(classValueRestriction.getValue());
        this.writer.print("</" + SyntaxElement.VALUE.print(DEF) + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.VALUE_COND.print(DEF) + ">");
    }

    public void visit(ClassTypeRestriction classTypeRestriction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.TYPE_COND.print(DEF));
        if (this.isPattern) {
            this.renderVariables(classTypeRestriction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.indentedOutput("<" + SyntaxElement.ONPROPERTY.print(DEF) + ">" + this.NL);
        this.increaseIndent();
        this.visit(classTypeRestriction.getRestrictionPath());
        this.writer.print(this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.ONPROPERTY.print(DEF) + ">" + this.NL);
        this.visit(classTypeRestriction.getType());
        this.decreaseIndent();
        this.writer.print(this.NL);
        this.indentedOutput("</" + SyntaxElement.TYPE_COND.print(DEF) + ">");
    }

    public void visit(ClassDomainRestriction classDomainRestriction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.DOMAIN_RESTRICTION.print(DEF));
        if (this.isPattern) {
            this.renderVariables(classDomainRestriction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.indentedOutput("<" + SyntaxElement.ONPROPERTY.print(DEF) + ">" + this.NL);
        this.increaseIndent();
        this.visit(classDomainRestriction.getRestrictionPath());
        this.writer.print(this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.ONPROPERTY.print(DEF) + ">" + this.NL);
        this.indentedOutput("<" + SyntaxElement.TOCLASS.print(DEF) + ">" + this.NL);
        this.increaseIndent();
        this.visit(classDomainRestriction.getDomain());
        this.writer.print(this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.TOCLASS.print(DEF) + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.DOMAIN_RESTRICTION.print(DEF) + ">");
    }

    public void visit(ClassOccurenceRestriction classOccurenceRestriction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.OCCURENCE_COND.print(DEF));
        if (this.isPattern) {
            this.renderVariables(classOccurenceRestriction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.indentedOutput("<" + SyntaxElement.ONPROPERTY.print(DEF) + ">" + this.NL);
        this.increaseIndent();
        this.visit(classOccurenceRestriction.getRestrictionPath());
        this.writer.print(this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.ONPROPERTY.print(DEF) + ">" + this.NL);
        this.indentedOutput("<" + SyntaxElement.COMPARATOR.print(DEF));
        this.writer.print(" " + SyntaxElement.RDF_RESOURCE.print(DEF));
        this.writer.print("=\"" + classOccurenceRestriction.getComparator().getURI());
        this.writer.print("\"/>" + this.NL);
        this.indentedOutput("<" + SyntaxElement.VALUE.print(DEF) + ">");
        this.writer.print(classOccurenceRestriction.getOccurence());
        this.writer.print("</" + SyntaxElement.VALUE.print(DEF) + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.OCCURENCE_COND.print(DEF) + ">");
    }

    public void visit(PropertyExpression propertyExpression) throws AlignmentException {
        if (propertyExpression instanceof PropertyId) {
            this.visit((PropertyId)propertyExpression);
        } else if (propertyExpression instanceof PropertyConstruction) {
            this.visit((PropertyConstruction)propertyExpression);
        } else if (propertyExpression instanceof PropertyRestriction) {
            this.visit((PropertyRestriction)propertyExpression);
        } else {
            throw new AlignmentException("Cannot dispatch ClassExpression " + propertyExpression);
        }
    }

    public void visit(PropertyId propertyId) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.PROPERTY_EXPR.print(DEF));
        if (propertyId.getURI() != null) {
            this.writer.print(" " + SyntaxElement.RDF_ABOUT.print(DEF));
            this.writer.print("=\"" + propertyId.getURI() + "\"");
        }
        if (this.isPattern) {
            this.renderVariables(propertyId);
        }
        this.writer.print("/>");
    }

    public void visit(PropertyConstruction propertyConstruction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.PROPERTY_EXPR.print(DEF));
        if (this.isPattern) {
            this.renderVariables(propertyConstruction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        SyntaxElement.Constructor constructor = propertyConstruction.getOperator();
        String string = SyntaxElement.getElement(constructor).print(DEF);
        this.indentedOutput("<" + string);
        if (constructor == SyntaxElement.Constructor.AND || constructor == SyntaxElement.Constructor.OR || constructor == SyntaxElement.Constructor.COMP) {
            this.writer.print(" " + SyntaxElement.RDF_PARSETYPE.print(DEF) + "=\"Collection\"");
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        if (constructor == SyntaxElement.Constructor.AND || constructor == SyntaxElement.Constructor.OR || constructor == SyntaxElement.Constructor.COMP) {
            for (PathExpression pathExpression : propertyConstruction.getComponents()) {
                this.writer.print(this.linePrefix);
                this.visit(pathExpression);
                this.writer.print(this.NL);
            }
        } else {
            for (PathExpression pathExpression : propertyConstruction.getComponents()) {
                this.visit(pathExpression);
            }
        }
        this.decreaseIndent();
        this.indentedOutput("</" + string + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.PROPERTY_EXPR.print(DEF) + ">");
    }

    public void visit(PropertyRestriction propertyRestriction) throws AlignmentException {
        if (propertyRestriction instanceof PropertyValueRestriction) {
            this.visit((PropertyValueRestriction)propertyRestriction);
        } else if (propertyRestriction instanceof PropertyDomainRestriction) {
            this.visit((PropertyDomainRestriction)propertyRestriction);
        } else if (propertyRestriction instanceof PropertyTypeRestriction) {
            this.visit((PropertyTypeRestriction)propertyRestriction);
        } else {
            throw new AlignmentException("Cannot dispatch ClassExpression " + propertyRestriction);
        }
    }

    public void visit(PropertyValueRestriction propertyValueRestriction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.PROPERTY_VALUE_COND.print(DEF));
        if (this.isPattern) {
            this.renderVariables(propertyValueRestriction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.writer.print("<" + SyntaxElement.COMPARATOR.print(DEF));
        this.writer.print(" " + SyntaxElement.RDF_RESOURCE.print(DEF));
        this.writer.print("=\"" + propertyValueRestriction.getComparator().getURI());
        this.writer.print("\"/>");
        this.writer.print("<" + SyntaxElement.VALUE.print(DEF) + ">");
        this.visit(propertyValueRestriction.getValue());
        this.writer.print("</" + SyntaxElement.VALUE.print(DEF) + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.PROPERTY_VALUE_COND.print(DEF) + ">");
    }

    public void visit(PropertyDomainRestriction propertyDomainRestriction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.PROPERTY_DOMAIN_COND.print(DEF));
        if (this.isPattern) {
            this.renderVariables(propertyDomainRestriction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.indentedOutput("<" + SyntaxElement.TOCLASS.print(DEF) + ">" + this.NL);
        this.increaseIndent();
        this.visit(propertyDomainRestriction.getDomain());
        this.writer.print(this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.TOCLASS.print(DEF) + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.PROPERTY_DOMAIN_COND.print(DEF) + ">" + this.NL);
    }

    public void visit(PropertyTypeRestriction propertyTypeRestriction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.PROPERTY_TYPE_COND.print(DEF));
        if (this.isPattern) {
            this.renderVariables(propertyTypeRestriction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.visit(propertyTypeRestriction.getType());
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.PROPERTY_TYPE_COND.print(DEF) + ">");
    }

    public void visit(RelationExpression relationExpression) throws AlignmentException {
        if (relationExpression instanceof RelationId) {
            this.visit((RelationId)relationExpression);
        } else if (relationExpression instanceof RelationRestriction) {
            this.visit((RelationRestriction)relationExpression);
        } else if (relationExpression instanceof RelationConstruction) {
            this.visit((RelationConstruction)relationExpression);
        } else {
            throw new AlignmentException("Cannot dispatch ClassExpression " + relationExpression);
        }
    }

    public void visit(RelationId relationId) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.RELATION_EXPR.print(DEF));
        if (relationId.getURI() != null) {
            this.writer.print(" " + SyntaxElement.RDF_ABOUT.print(DEF));
            this.writer.print("=\"" + relationId.getURI() + "\"");
        }
        if (this.isPattern) {
            this.renderVariables(relationId);
        }
        this.writer.print("/>");
    }

    public void visit(RelationConstruction relationConstruction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.RELATION_EXPR.print(DEF));
        if (this.isPattern) {
            this.renderVariables(relationConstruction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        SyntaxElement.Constructor constructor = relationConstruction.getOperator();
        String string = SyntaxElement.getElement(constructor).print(DEF);
        this.indentedOutput("<" + string);
        if (constructor == SyntaxElement.Constructor.OR || constructor == SyntaxElement.Constructor.AND || constructor == SyntaxElement.Constructor.COMP) {
            this.writer.print(" " + SyntaxElement.RDF_PARSETYPE.print(DEF) + "=\"Collection\"");
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        if (constructor == SyntaxElement.Constructor.AND || constructor == SyntaxElement.Constructor.OR || constructor == SyntaxElement.Constructor.COMP) {
            for (PathExpression pathExpression : relationConstruction.getComponents()) {
                this.writer.print(this.linePrefix);
                this.visit(pathExpression);
                this.writer.print(this.NL);
            }
        } else {
            for (PathExpression pathExpression : relationConstruction.getComponents()) {
                this.visit(pathExpression);
            }
        }
        this.decreaseIndent();
        this.indentedOutput("</" + string + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.RELATION_EXPR.print(DEF) + ">");
    }

    public void visit(RelationRestriction relationRestriction) throws AlignmentException {
        if (relationRestriction instanceof RelationCoDomainRestriction) {
            this.visit((RelationCoDomainRestriction)relationRestriction);
        } else if (relationRestriction instanceof RelationDomainRestriction) {
            this.visit((RelationDomainRestriction)relationRestriction);
        } else {
            throw new AlignmentException("Cannot dispatch ClassExpression " + relationRestriction);
        }
    }

    public void visit(RelationCoDomainRestriction relationCoDomainRestriction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.RELATION_CODOMAIN_COND.print(DEF));
        if (this.isPattern) {
            this.renderVariables(relationCoDomainRestriction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.indentedOutput("<" + SyntaxElement.TOCLASS.print(DEF) + ">" + this.NL);
        this.increaseIndent();
        this.visit(relationCoDomainRestriction.getCoDomain());
        this.writer.print(this.NL);
        this.decreaseIndent();
        this.writer.print("</" + SyntaxElement.TOCLASS.print(DEF) + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.RELATION_CODOMAIN_COND.print(DEF) + ">");
    }

    public void visit(RelationDomainRestriction relationDomainRestriction) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.RELATION_DOMAIN_COND.print(DEF));
        if (this.isPattern) {
            this.renderVariables(relationDomainRestriction);
        }
        this.writer.print(">" + this.NL);
        this.increaseIndent();
        this.indentedOutput("<" + SyntaxElement.TOCLASS.print(DEF) + ">" + this.NL);
        this.increaseIndent();
        this.visit(relationDomainRestriction.getDomain());
        this.writer.print(this.NL);
        this.decreaseIndent();
        this.writer.print("</" + SyntaxElement.TOCLASS.print(DEF) + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.RELATION_DOMAIN_COND.print(DEF) + ">");
    }

    public void visit(InstanceExpression instanceExpression) throws AlignmentException {
        if (!(instanceExpression instanceof InstanceId)) {
            throw new AlignmentException("Cannot handle InstanceExpression " + instanceExpression);
        }
        this.visit((InstanceId)instanceExpression);
    }

    public void visit(InstanceId instanceId) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.INSTANCE_EXPR.print(DEF));
        if (instanceId.getURI() != null) {
            this.writer.print(" " + SyntaxElement.RDF_ABOUT.print(DEF));
            this.writer.print("=\"" + instanceId.getURI() + "\"");
        }
        if (this.isPattern) {
            this.renderVariables(instanceId);
        }
        this.writer.print("/>");
    }

    public void visit(ValueExpression valueExpression) throws AlignmentException {
        if (valueExpression instanceof InstanceExpression) {
            this.visit((InstanceExpression)valueExpression);
        } else if (valueExpression instanceof PathExpression) {
            this.visit((PathExpression)valueExpression);
        } else if (valueExpression instanceof Apply) {
            this.visit((Apply)valueExpression);
        } else if (valueExpression instanceof Value) {
            this.visit((Value)valueExpression);
        } else {
            throw new AlignmentException("Cannot dispatch ClassExpression " + valueExpression);
        }
    }

    public void visit(Value value) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.LITERAL.print(DEF) + " " + SyntaxElement.STRING.print(DEF) + "=\"");
        this.writer.print(value.getValue());
        if (value.getType() != null) {
            this.writer.print(" " + SyntaxElement.TYPE.print(DEF) + "=\"" + value.getType() + "\"");
        }
        this.writer.print("\"/>");
    }

    public void visit(Apply apply) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.APPLY.print(DEF) + " " + SyntaxElement.OPERATOR.print(DEF) + "=\"" + apply.getOperation() + "\">" + this.NL);
        this.increaseIndent();
        this.indentedOutput("<" + SyntaxElement.ARGUMENTS.print(DEF) + " " + SyntaxElement.RDF_PARSETYPE.print(DEF) + "=\"Collection\">" + this.NL);
        this.increaseIndent();
        for (ValueExpression valueExpression : apply.getArguments()) {
            this.writer.print(this.linePrefix);
            this.visit(valueExpression);
            this.writer.print(this.NL);
        }
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.ARGUMENTS.print(DEF) + ">" + this.NL);
        this.decreaseIndent();
        this.indentedOutput("</" + SyntaxElement.APPLY.print(DEF) + ">");
    }

    public void visit(Datatype datatype) throws AlignmentException {
        this.indentedOutput("<" + SyntaxElement.DATATYPE.print(DEF) + ">");
        this.writer.print(datatype.plainText());
        this.writer.print("</" + SyntaxElement.DATATYPE.print(DEF) + ">");
    }

    private void increaseIndent() {
        ++this.prefixCount;
    }

    private void decreaseIndent() {
        if (this.prefixCount > 0) {
            --this.prefixCount;
        }
    }

    private void calcPrefix() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.NL);
        for (int i = 0; i < this.prefixCount; ++i) {
            stringBuilder.append(this.INDENT);
        }
        this.linePrefix = stringBuilder.toString();
    }

    private void indentedOutputln(String string) {
        for (int i = 0; i < this.prefixCount; ++i) {
            this.writer.print(this.INDENT);
        }
        this.writer.print(string + this.NL);
    }

    private void indentedOutput(String string) {
        for (int i = 0; i < this.prefixCount; ++i) {
            this.writer.print(this.INDENT);
        }
        this.writer.print(string);
    }

    private void indentedOutputln() {
        for (int i = 0; i < this.prefixCount; ++i) {
            this.writer.print(this.INDENT);
        }
    }

    private void indentedOutput() {
        for (int i = 0; i < this.prefixCount; ++i) {
            this.writer.print(this.INDENT);
        }
    }
}

