/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.BasicRelation;
import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;

public class OWLAxiomsRendererVisitor
implements AlignmentVisitor {
    boolean heterogeneous = false;
    PrintWriter writer = null;
    Alignment alignment = null;
    LoadedOntology onto1 = null;
    LoadedOntology onto2 = null;
    Cell cell = null;

    public OWLAxiomsRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void init(Properties properties) {
        if (properties.getProperty("heterogeneous") != null) {
            this.heterogeneous = true;
        }
    }

    public void visit(Visitable visitable) throws AlignmentException {
        if (visitable instanceof Alignment) {
            this.visit((Alignment)visitable);
        } else if (visitable instanceof Cell) {
            this.visit((Cell)visitable);
        } else if (visitable instanceof Relation) {
            this.visit((Relation)visitable);
        }
    }

    public void visit(Alignment alignment) throws AlignmentException {
        if (!(alignment instanceof ObjectAlignment)) {
            throw new AlignmentException("OWLAxiomsRenderer: cannot render simple alignment. Turn them into ObjectAlignment, by toObjectAlignement()");
        }
        this.alignment = alignment;
        if (alignment instanceof ObjectAlignment) {
            this.onto1 = (LoadedOntology)((ObjectAlignment)this.alignment).getOntologyObject1();
            this.onto2 = (LoadedOntology)((ObjectAlignment)this.alignment).getOntologyObject2();
        }
        this.writer.print("<rdf:RDF\n");
        this.writer.print("    xmlns:owl=\"http://www.w3.org/2002/07/owl#\"\n");
        this.writer.print("    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n");
        this.writer.print("    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" \n");
        this.writer.print("    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\">\n\n");
        this.writer.print("  <owl:Ontology rdf:about=\"\">\n");
        this.writer.print("    <rdfs:comment>Matched ontologies</rdfs:comment>\n");
        this.writer.print("    <rdfs:comment>Generated by fr.inrialpes.exmo.align.renderer.OWLAxiomsRendererVisitor</rdfs:comment>\n");
        for (Cell cell : alignment.getExtensions()) {
            this.writer.print("    <rdfs:comment>" + cell[1] + ": " + cell[2] + "</rdfs:comment>\n");
        }
        this.writer.print("    <owl:imports rdf:resource=\"" + alignment.getOntology1URI().toString() + "\"/>\n");
        this.writer.print("    <owl:imports rdf:resource=\"" + alignment.getOntology2URI().toString() + "\"/>\n");
        this.writer.print("  </owl:Ontology>\n\n");
        for (Cell cell : alignment) {
            Object object = cell.getObject1();
            Object object2 = cell.getObject2();
            if (!(this.heterogeneous || this.onto1.isClass(object) && this.onto2.isClass(object2) || this.onto1.isDataProperty(object) && this.onto2.isDataProperty(object2) || this.onto1.isObjectProperty(object) && this.onto2.isObjectProperty(object2)) && (!this.onto1.isIndividual(object) || !this.onto2.isIndividual(object2))) continue;
            cell.accept((AlignmentVisitor)this);
        }
        this.writer.print("</rdf:RDF>\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        URI uRI;
        this.cell = cell;
        Object object = cell.getObject1();
        Object object2 = cell.getObject2();
        try {
            uRI = cell.getRelation() instanceof SubsumedRelation ? this.onto2.getEntityURI(cell.getObject2()) : this.onto1.getEntityURI(object);
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
        }
        if (this.onto1.isClass(object)) {
            this.writer.print("  <owl:Class rdf:about=\"" + uRI + "\">\n");
            cell.getRelation().accept((AlignmentVisitor)this);
            this.writer.print("  </owl:Class>\n");
        } else if (this.onto1.isDataProperty(object)) {
            this.writer.print("  <owl:DatatypeProperty rdf:about=\"" + uRI + "\">\n");
            cell.getRelation().accept((AlignmentVisitor)this);
            this.writer.print("  </owl:DatatypeProperty>\n");
        } else if (this.onto1.isObjectProperty(object)) {
            this.writer.print("  <owl:ObjectProperty rdf:about=\"" + uRI + "\">\n");
            cell.getRelation().accept((AlignmentVisitor)this);
            this.writer.print("  </owl:ObjectProperty>\n");
        } else if (this.onto1.isIndividual(object)) {
            this.writer.print("  <owl:Thing rdf:about=\"" + uRI + "\">\n");
            cell.getRelation().accept((AlignmentVisitor)this);
            this.writer.print("  </owl:Thing>\n");
        }
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        URI uRI;
        Object object = this.cell.getObject2();
        try {
            uRI = this.onto2.getEntityURI(object);
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
        }
        if (this.onto2.isClass(object)) {
            this.writer.print("    <owl:equivalentClass rdf:resource=\"" + uRI + "\"/>\n");
        } else if (this.onto2.isDataProperty(object)) {
            this.writer.print("    <owl:equivalentProperty rdf:resource=\"" + uRI + "\"/>\n");
        } else if (this.onto2.isObjectProperty(object)) {
            this.writer.print("    <owl:equivalentProperty rdf:resource=\"" + uRI + "\"/>\n");
        } else if (this.onto2.isIndividual(object)) {
            this.writer.print("    <owl:sameAs rdf:resource=\"" + uRI + "\"/>\n");
        }
    }

    public void visit(SubsumeRelation subsumeRelation) throws AlignmentException {
        URI uRI;
        Object object = this.cell.getObject2();
        try {
            uRI = this.onto2.getEntityURI(object);
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
        }
        if (this.onto1.isClass(object)) {
            this.writer.print("    <rdfs:subClassOf rdf:resource=\"" + uRI + "\"/>\n");
        } else if (this.onto1.isDataProperty(object)) {
            this.writer.print("    <rdfs:subPropertyOf rdf:resource=\"" + uRI + "\"/>\n");
        } else if (this.onto1.isObjectProperty(object)) {
            this.writer.print("    <rdfs:subPropertyOf rdf:resource=\"" + uRI + "\"/>\n");
        }
    }

    public void visit(SubsumedRelation subsumedRelation) throws AlignmentException {
        URI uRI;
        Object object = this.cell.getObject1();
        try {
            uRI = this.onto1.getEntityURI(object);
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
        }
        if (this.onto1.isClass(object)) {
            this.writer.print("    <rdfs:subClassOf rdf:resource=\"" + uRI + "\"/>\n");
        } else if (this.onto1.isDataProperty(object)) {
            this.writer.print("    <rdfs:subPropertyOf rdf:resource=\"" + uRI + "\"/>\n");
        } else if (this.onto1.isObjectProperty(object)) {
            this.writer.print("    <rdfs:subPropertyOf rdf:resource=\"" + uRI + "\"/>\n");
        }
    }

    public void visit(IncompatRelation incompatRelation) throws AlignmentException {
        URI uRI;
        Object object = this.cell.getObject2();
        try {
            uRI = this.onto2.getEntityURI(object);
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
        }
        this.writer.print("    <owl:disjointWith rdf:resource=\"" + uRI + "\"/>\n");
    }

    public void visit(Relation relation) throws AlignmentException {
        block16: {
            try {
                String string;
                URI uRI;
                Method method = null;
                if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                    method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
                } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                    method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
                } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                    method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
                } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                    method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
                }
                if (method != null) {
                    method.invoke((Object)this, relation);
                    break block16;
                }
                if (!Class.forName("fr.inrialpes.exmo.align.impl.BasicRelation").isInstance(relation)) break block16;
                Object object = this.cell.getObject2();
                try {
                    uRI = this.onto2.getEntityURI(object);
                }
                catch (OntowrapException ontowrapException) {
                    throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
                }
                if (this.onto2.isIndividual(object) && (string = ((BasicRelation)relation).getRelation()) != null && !string.equals("")) {
                    this.writer.print("    <" + string + " rdf:resource=\"" + uRI + "\"/>\n");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }
}

