/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.Namespace;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Hashtable;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;

public class HTMLRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Cell cell = null;
    Hashtable<String, String> nslist = null;
    boolean embedded = false;
    String alid = "";

    public HTMLRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void init(Properties properties) {
        if (properties.getProperty("embedded") != null && !properties.getProperty("embedded").equals("")) {
            this.embedded = true;
        }
    }

    public void visit(Visitable visitable) throws AlignmentException {
        if (visitable instanceof Alignment) {
            this.visit((Alignment)visitable);
        } else if (visitable instanceof Cell) {
            this.visit((Cell)visitable);
        } else if (visitable instanceof Relation) {
            this.visit((Relation)visitable);
        }
    }

    public void visit(Alignment alignment) throws AlignmentException {
        this.alignment = alignment;
        this.nslist = new Hashtable();
        this.nslist.put(Namespace.ALIGNMENT.uri, "align");
        this.nslist.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.nslist.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        int n = 0;
        for (Object object2 : alignment.getExtensions()) {
            Cell cell = object2[0];
            String string = object2[1];
            String string2 = this.nslist.get(cell);
            if (string2 == null) {
                string2 = "ns" + n++;
                this.nslist.put((String)cell, string2);
            }
            if (string2.equals("align")) {
                string2 = string;
                continue;
            }
            string2 = string2 + ":" + string;
        }
        if (!this.embedded) {
            this.writer.print("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n");
            this.writer.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML+RDFa 1.0//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-rdfa-1.dtd\">\n");
        }
        this.writer.print("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\"");
        Object object = this.nslist.keys();
        while (object.hasMoreElements()) {
            Object object2;
            object2 = (String)object.nextElement();
            this.writer.print("\n       xmlns:" + this.nslist.get(object2) + "='" + (String)object2 + "'");
        }
        this.writer.print(">\n<head><title>Alignment</title></head>\n<body>\n");
        this.alid = alignment.getExtension(Namespace.ALIGNMENT.uri, Annotations.ID);
        object = alignment.getExtension(Namespace.ALIGNMENT.uri, Annotations.PRETTY);
        if (this.alid == null) {
            this.alid = "Anonymous alignment";
        }
        if (object == null) {
            this.writer.print("<h1>" + this.alid + "</h1>\n");
        } else {
            this.writer.print("<h1>" + this.alid + " (" + (String)object + ")</h1>\n");
        }
        this.writer.print("<div typeof=\"align:Alignment\">\n");
        this.writer.print("<h2>Alignment metadata</h2>\n");
        this.writer.print("<table border=\"0\">\n");
        this.writer.print("<tr><td>onto1</td><td><div rel=\"align:onto1\"><div typeof=\"align:Ontology\" about=\"" + alignment.getOntology1URI() + "\">");
        this.writer.print("<table>\n<tr><td>uri: </td><td>" + alignment.getOntology1URI() + "</td></tr>\n");
        if (alignment.getFile1() != null) {
            this.writer.print("<tr><td><span property=\"align:location\" content=\"" + alignment.getFile1() + "\"/>file:</td><td><a href=\"" + alignment.getFile1() + "\">" + alignment.getFile1() + "</a></td></tr>\n");
        }
        if (alignment instanceof BasicAlignment && ((BasicAlignment)alignment).getOntologyObject1().getFormalism() != null) {
            this.writer.print("<tr><td>type:</td><td><span rel=\"align:formalism\"><span typeof=\"align:Formalism\"><span property=\"align:name\">" + ((BasicAlignment)alignment).getOntologyObject1().getFormalism() + "</span><span property=\"align:uri\" content=\"" + ((BasicAlignment)alignment).getOntologyObject1().getFormURI() + "\"/></span></span></td></tr>");
        }
        this.writer.print("</table>\n</div></div></td></tr>\n");
        this.writer.print("<tr><td>onto2</td><td><div rel=\"align:onto2\"><div typeof=\"align:Ontology\" about=\"" + alignment.getOntology2URI() + "\">");
        this.writer.print("<table>\n<tr><td>uri: </td><td>" + alignment.getOntology2URI() + "</td></tr>\n");
        if (alignment.getFile2() != null) {
            this.writer.print("<tr><td><span property=\"align:location\" content=\"" + alignment.getFile2() + "\"/>file:</td><td><a href=\"" + alignment.getFile2() + "\">" + alignment.getFile2() + "</a></td></tr>\n");
        }
        if (alignment instanceof BasicAlignment && ((BasicAlignment)alignment).getOntologyObject2().getFormalism() != null) {
            this.writer.print("<tr><td>type:</td><td><span rel=\"align:formalism\"><span typeof=\"align:Formalism\"><span property=\"align:name\">" + ((BasicAlignment)alignment).getOntologyObject2().getFormalism() + "</span><span property=\"align:uri\" content=\"" + ((BasicAlignment)alignment).getOntologyObject2().getFormURI() + "\"/></span></span></td></tr>");
        }
        this.writer.print("</table>\n</div></div></td></tr>\n");
        this.writer.print("<tr><td>level</td><td property=\"align:level\">" + alignment.getLevel() + "</td></tr>\n");
        this.writer.print("<tr><td>type</td><td property=\"align:type\">" + alignment.getType() + "</td></tr>\n");
        for (Cell cell : alignment.getExtensions()) {
            this.writer.print("<tr><td>" + cell[0] + " : " + cell[1] + "</td><td property=\"" + this.nslist.get(cell[0]) + ":" + (String)cell[1] + "\">" + (String)cell[2] + "</td></tr>\n");
        }
        this.writer.print("</table>\n");
        this.writer.print("<h2>Correspondences</h2>\n");
        this.writer.print("<div rel=\"align:map\"><table><tr><td>object1</td><td>relation</td><td>strength</td><td>object2</td><td>Id</td></tr>\n");
        for (Cell cell : alignment) {
            cell.accept((AlignmentVisitor)this);
        }
        this.writer.print("</table>\n");
        this.writer.print("</div></div>\n");
        this.writer.print("</body>\n</html>\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        URI uRI = cell.getObject1AsURI(this.alignment);
        URI uRI2 = cell.getObject2AsURI(this.alignment);
        this.writer.print(" <tr typeof=\"align:Cell\">");
        this.writer.print("<td rel=\"align:entity1\" href=\"" + uRI + "\">" + uRI + "</td><td property=\"align:relation\">");
        cell.getRelation().accept((AlignmentVisitor)this);
        this.writer.print("</td><td property=\"align:measure\" datatype=\"xsd:float\">" + cell.getStrength() + "</td>");
        this.writer.print("<td rel=\"align:entity2\" href=\"" + uRI2 + "\">" + uRI2 + "</td>");
        if (cell.getId() != null) {
            String string = cell.getId();
            if (this.alid != null && string.startsWith(this.alid)) {
                this.writer.print("<td>" + string.substring(string.indexOf(35)) + "</td>");
            } else {
                this.writer.print("<td>" + string + "</td>");
            }
        } else {
            this.writer.print("<td></td>");
        }
        this.writer.println("</tr>");
    }

    public void visit(Relation relation) {
        relation.write(this.writer);
    }
}

