/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.Namespace;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Visitable;

public class HTMLMetadataRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Hashtable<String, String> nslist = null;
    boolean embedded = false;

    public HTMLMetadataRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void init(Properties properties) {
        if (properties.getProperty("embedded") != null && !properties.getProperty("embedded").equals("")) {
            this.embedded = true;
        }
    }

    public void visit(Visitable visitable) throws AlignmentException {
        if (visitable instanceof Alignment) {
            this.visit((Alignment)visitable);
        }
    }

    public void visit(Alignment alignment) throws AlignmentException {
        this.alignment = alignment;
        this.nslist = new Hashtable();
        this.nslist.put(Namespace.ALIGNMENT.uri, "align");
        this.nslist.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.nslist.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        int n = 0;
        for (Object object : alignment.getExtensions()) {
            String string = object[0];
            String string2 = object[1];
            String string3 = this.nslist.get(string);
            if (string3 == null) {
                string3 = "ns" + n++;
                this.nslist.put(string, string3);
            }
            if (string3.equals("align")) {
                string3 = string2;
                continue;
            }
            string3 = string3 + ":" + string2;
        }
        if (!this.embedded) {
            this.writer.print("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n");
            this.writer.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML+RDFa 1.0//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-rdfa-1.dtd\">\n");
        }
        this.writer.print("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\"");
        Iterator iterator = this.nslist.keys();
        while (iterator.hasMoreElements()) {
            Object object;
            object = (String)iterator.nextElement();
            this.writer.print("\n       xmlns:" + this.nslist.get(object) + "='" + (String)object + "'");
        }
        this.writer.print("<h1>Alignment metadata</h1>\n");
        this.writer.print("<h1></h1>\n");
        this.writer.print("<div typeof=\"align:Alignment\">\n");
        this.writer.print("<table border=\"0\">\n");
        this.writer.print("<tr><td>onto1</td><td><div rel=\"align:onto1\"><div typeof=\"align:Ontology\" about=\"" + alignment.getOntology1URI() + "\">");
        this.writer.print("<table>\n<tr><td>uri: </td><td>" + alignment.getOntology1URI() + "</td></tr>\n");
        if (alignment.getFile1() != null) {
            this.writer.print("<tr><td><span property=\"align:location\" content=\"" + alignment.getFile1() + "\"/>file:</td><td><a href=\"" + alignment.getFile1() + "\">" + alignment.getFile1() + "</a></td></tr>\n");
        }
        if (alignment instanceof BasicAlignment && ((BasicAlignment)alignment).getOntologyObject1().getFormalism() != null) {
            this.writer.print("<tr><td>type:</td><td><span rel=\"align:formalism\"><span typeof=\"align:Formalism\"><span property=\"align:name\">" + ((BasicAlignment)alignment).getOntologyObject1().getFormalism() + "</span><span property=\"align:uri\" content=\"" + ((BasicAlignment)alignment).getOntologyObject1().getFormURI() + "\"/></span></span></td></tr>");
        }
        this.writer.print("</table>\n</div></div></td></tr>\n");
        this.writer.print("<tr><td>onto2</td><td><div rel=\"align:onto2\"><div typeof=\"align:Ontology\" about=\"" + alignment.getOntology2URI() + "\">");
        this.writer.print("<table>\n<tr><td>uri: </td><td>" + alignment.getOntology2URI() + "</td></tr>\n");
        if (alignment.getFile2() != null) {
            this.writer.print("<tr><td><span property=\"align:location\" content=\"" + alignment.getFile2() + "\"/>file:</td><td><a href=\"" + alignment.getFile2() + "\">" + alignment.getFile2() + "</a></td></tr>\n");
        }
        if (alignment instanceof BasicAlignment && ((BasicAlignment)alignment).getOntologyObject2().getFormalism() != null) {
            this.writer.print("<tr><td>type:</td><td><span rel=\"align:formalism\"><span typeof=\"align:Formalism\"><span property=\"align:name\">" + ((BasicAlignment)alignment).getOntologyObject2().getFormalism() + "</span><span property=\"align:uri\" content=\"" + ((BasicAlignment)alignment).getOntologyObject2().getFormURI() + "\"/></span></span></td></tr>");
        }
        this.writer.print("</table>\n</div></div></td></tr>\n");
        this.writer.print("<tr><td>level</td><td property=\"align:level\">" + alignment.getLevel() + "</td></tr>\n");
        this.writer.print("<tr><td>type</td><td property=\"align:type\">" + alignment.getType() + "</td></tr>\n");
        for (Object object : alignment.getExtensions()) {
            this.writer.print("<tr><td>" + object[0] + " : " + object[1] + "</td><td property=\"" + this.nslist.get(object[0]) + ":" + object[1] + "\">" + object[2] + "</td></tr>\n");
        }
        this.writer.print("</table>\n");
        this.writer.print("</div>\n");
        this.writer.print("</body>\n</html>\n");
    }
}

