/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;

public class COWLMappingRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    LoadedOntology onto1 = null;
    LoadedOntology onto2 = null;
    Cell cell = null;

    public COWLMappingRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void init(Properties properties) {
    }

    public void visit(Visitable visitable) throws AlignmentException {
        if (visitable instanceof Alignment) {
            this.visit((Alignment)visitable);
        } else if (visitable instanceof Cell) {
            this.visit((Cell)visitable);
        } else if (visitable instanceof Relation) {
            this.visit((Relation)visitable);
        }
    }

    public void visit(Alignment alignment) throws AlignmentException {
        if (!(alignment instanceof ObjectAlignment)) {
            throw new AlignmentException("COWLMappingRenderer: cannot render simple alignment. Turn them into ObjectAlignment, by toObjectAlignement()");
        }
        this.alignment = alignment;
        this.onto1 = (LoadedOntology)((ObjectAlignment)this.alignment).getOntologyObject1();
        this.onto2 = (LoadedOntology)((ObjectAlignment)this.alignment).getOntologyObject2();
        this.writer.print("<rdf:RDF\n");
        this.writer.print("    xmlns:owl=\"http://www.w3.org/2002/07/owl#\"\n");
        this.writer.print("    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n");
        this.writer.print("    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" \n");
        this.writer.print("    xmlns:cowl=\"http://www.itc.it/cowl#\" \n");
        this.writer.print("    xml:base=\"http://www.itc.it/cowl#\" \n");
        this.writer.print("    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\">\n\n");
        this.writer.print("  <cowl:Mapping rdf:ID=\"\">\n");
        this.writer.print("    <rdfs:comment>Generated by fr.inrialpes.exmo.impl.renderer.COWLMappingRendererVisitor</rdfs:comment>\n");
        for (Cell cell : alignment.getExtensions()) {
            this.writer.print("    <rdfs:comment>" + cell[1] + ": " + cell[2] + "</rdfs:comment>\n");
        }
        this.writer.print("\n");
        this.writer.print("    <cowl:sourceOntology>\n");
        this.writer.print("      <owl:Ontology rdf:about=\"" + this.onto1.getURI() + "\"/>\n");
        this.writer.print("    </cowl:sourceOntology>\n");
        this.writer.print("    <cowl:targetOntology>\n");
        this.writer.print("      <owl:Ontology rdf:about=\"" + this.onto2.getURI() + "\"/>\n");
        this.writer.print("    </cowl:targetOntology>\n");
        for (Cell cell : alignment) {
            cell.accept((AlignmentVisitor)this);
        }
        this.writer.print("  </cowl:Mapping>\n");
        this.writer.print("</rdf:RDF>\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        this.writer.print("    <cowl:bridgeRule>\n");
        cell.getRelation().accept((AlignmentVisitor)this);
        this.writer.print("    </cowl:bridgeRule>\n");
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        this.writer.print("     <cowl:Equivalent>\n");
        this.writer.print("       <cowl:source>\n");
        this.printObject(this.cell.getObject1(), this.onto1);
        this.writer.print("       </cowl:source>\n");
        this.writer.print("       <cowl:target>\n");
        this.printObject(this.cell.getObject2(), this.onto2);
        this.writer.print("       </cowl:target>\n");
        this.writer.print("     </cowl:Equivalent>\n");
    }

    public void visit(SubsumeRelation subsumeRelation) throws AlignmentException {
        this.writer.print("     <cowl:Into>\n");
        this.writer.print("       <cowl:source>\n");
        this.printObject(this.cell.getObject1(), this.onto1);
        this.writer.print("       </cowl:source>\n");
        this.writer.print("       <cowl:target>\n");
        this.printObject(this.cell.getObject2(), this.onto2);
        this.writer.print("       </cowl:target>\n");
        this.writer.print("     </cowl:Into>\n");
    }

    public void visit(SubsumedRelation subsumedRelation) throws AlignmentException {
        this.writer.print("     <cowl:Onto>\n");
        this.writer.print("       <cowl:source>\n");
        this.printObject(this.cell.getObject1(), this.onto1);
        this.writer.print("       </cowl:source>\n");
        this.writer.print("       <cowl:target>\n");
        this.printObject(this.cell.getObject2(), this.onto2);
        this.writer.print("       </cowl:target>\n");
        this.writer.print("     </cowl:Onto>\n");
    }

    public void visit(IncompatRelation incompatRelation) throws AlignmentException {
        this.writer.print("     <cowl:INCOMPATIBLE>\n");
        this.writer.print("       <cowl:source>\n");
        this.printObject(this.cell.getObject1(), this.onto1);
        this.writer.print("       </cowl:source>\n");
        this.writer.print("       <cowl:target>\n");
        this.printObject(this.cell.getObject2(), this.onto2);
        this.writer.print("       </cowl:target>\n");
        this.writer.print("     </cowl:INCOMPATIBLE>\n");
    }

    public void visit(Relation relation) throws AlignmentException {
        try {
            Method method = null;
            if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
            }
            if (method != null) {
                method.invoke((Object)this, relation);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public void printObject(Object object, LoadedOntology loadedOntology) throws AlignmentException {
        try {
            if (loadedOntology.isClass(object)) {
                this.writer.print("         <owl:Class rdf:about=\"" + loadedOntology.getEntityURI(object) + "\"/>\n");
            } else if (loadedOntology.isDataProperty(object)) {
                this.writer.print("         <owl:DataProperty rdf:about=\"" + loadedOntology.getEntityURI(object) + "\"/>\n");
            } else if (loadedOntology.isObjectProperty(object)) {
                this.writer.print("         <owl:ObjectProperty rdf:about=\"" + loadedOntology.getEntityURI(object) + "\"/>\n");
            } else if (loadedOntology.isIndividual(object)) {
                this.writer.print("         <owl:Individual rdf:about=\"" + loadedOntology.getEntityURI(object) + "\"/>\n");
            }
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
        }
    }
}

