/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.eval;

import fr.inrialpes.exmo.align.impl.BasicEvaluator;
import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.parser.SyntaxElement;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;

public class SymMeanEvaluator
extends BasicEvaluator {
    private double classScore = 0.0;
    private double propScore = 0.0;
    private double indScore = 0.0;

    public SymMeanEvaluator(Alignment alignment, Alignment alignment2) throws AlignmentException {
        super(alignment, alignment2);
        if (!(alignment instanceof ObjectAlignment) || !(alignment2 instanceof ObjectAlignment)) {
            throw new AlignmentException("Alignments should be ObjectAlignments, try to ");
        }
    }

    public double eval(Properties properties) throws AlignmentException {
        return this.eval(properties, null);
    }

    public double eval(Properties properties, Object object) throws AlignmentException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.result = 0.0;
        this.classScore = 0.0;
        this.propScore = 0.0;
        this.indScore = 0.0;
        LoadedOntology loadedOntology = (LoadedOntology)((ObjectAlignment)this.align1).getOntologyObject1();
        LoadedOntology loadedOntology2 = (LoadedOntology)((ObjectAlignment)this.align2).getOntologyObject1();
        for (Cell cell : this.align1) {
            Set set;
            if (loadedOntology.isClass(cell.getObject1())) {
                ++n;
            } else if (loadedOntology.isProperty(cell.getObject1())) {
                ++n2;
            } else {
                ++n3;
            }
            if ((set = this.align2.getAlignCells1(cell.getObject1())) == null) continue;
            for (Cell cell2 : set) {
                if (cell.getObject2() != cell2.getObject2()) continue;
                if (loadedOntology2.isClass(cell.getObject2())) {
                    this.classScore = this.classScore + 1.0 - Math.abs(cell2.getStrength() - cell.getStrength());
                    continue;
                }
                if (loadedOntology2.isProperty(cell.getObject2())) {
                    this.propScore = this.propScore + 1.0 - Math.abs(cell2.getStrength() - cell.getStrength());
                    continue;
                }
                this.indScore = this.indScore + 1.0 - Math.abs(cell2.getStrength() - cell.getStrength());
            }
        }
        for (Cell cell : this.align2) {
            if (loadedOntology.isClass(cell.getObject1())) {
                ++n;
                continue;
            }
            if (loadedOntology.isProperty(cell.getObject1())) {
                ++n2;
                continue;
            }
            ++n3;
        }
        this.result = 2.0 * (this.classScore + this.propScore + this.indScore) / (double)(n + n2 + n3);
        this.classScore = 2.0 * this.classScore / (double)n;
        this.propScore = 2.0 * this.propScore / (double)n2;
        this.indScore = 2.0 * this.indScore / (double)n3;
        return this.result;
    }

    @Override
    public void write(PrintWriter printWriter) throws IOException {
        printWriter.print("<" + SyntaxElement.RDF.print() + ">\n  <Evaluation class=\"SymMeanEvaluator\">\n    <class>");
        printWriter.print(this.classScore);
        printWriter.print("</class>\n    <properties>");
        printWriter.print(this.propScore);
        printWriter.print("</properties>\n    <individuals>");
        printWriter.print(this.indScore);
        printWriter.print("</individuals>\n    <result>");
        printWriter.print(this.result);
        printWriter.print("</result>\n  </Evaluation>\n</" + SyntaxElement.RDF.print() + ">\n");
    }
}

