/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.eval;

import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.impl.eval.PRecEvaluator;
import fr.inrialpes.exmo.iddl.IDDLReasoner;
import fr.inrialpes.exmo.iddl.conf.Semantics;
import java.util.Properties;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;

public class SemPRecEvaluator
extends PRecEvaluator {
    private int nbfoundentailed = 0;
    private int nbexpectedentailed = 0;
    private Semantics semantics = Semantics.DL;

    public SemPRecEvaluator(Alignment alignment, Alignment alignment2) throws AlignmentException {
        super(((BasicAlignment)alignment).toURIAlignment(), ((BasicAlignment)alignment2).toURIAlignment());
    }

    public void init(Object object) {
        super.init();
        this.nbexpectedentailed = 0;
        this.nbfoundentailed = 0;
        if (object instanceof Semantics) {
            this.semantics = (Semantics)object;
        }
    }

    @Override
    public double eval(Properties properties, Object object) throws AlignmentException {
        ObjectAlignment objectAlignment;
        this.init(properties.getProperty("semantics"));
        this.nbfound = this.align2.nbCells();
        this.nbexpected = this.align1.nbCells();
        IDDLReasoner iDDLReasoner = new IDDLReasoner(this.semantics);
        iDDLReasoner.addOntology(this.align1.getOntology1URI());
        iDDLReasoner.addOntology(this.align1.getOntology2URI());
        iDDLReasoner.addAlignment(this.align1);
        iDDLReasoner.isConsistent();
        for (Cell cell : this.align2) {
            objectAlignment = new ObjectAlignment();
            objectAlignment.init(this.align2.getOntology1URI(), this.align2.getOntology2URI());
            objectAlignment.addAlignCell(cell.getObject1(), cell.getObject2(), cell.getRelation().getRelation(), 1.0);
            if (!iDDLReasoner.isEntailed((Alignment)objectAlignment)) continue;
            ++this.nbfoundentailed;
        }
        iDDLReasoner = new IDDLReasoner(this.semantics);
        iDDLReasoner.addOntology(this.align2.getOntology1URI());
        iDDLReasoner.addOntology(this.align2.getOntology2URI());
        iDDLReasoner.addAlignment(this.align2);
        iDDLReasoner.isConsistent();
        for (Cell cell : this.align1) {
            objectAlignment = new ObjectAlignment();
            objectAlignment.init(this.align2.getOntology1URI(), this.align2.getOntology2URI());
            objectAlignment.addAlignCell(cell.getObject1(), cell.getObject2(), cell.getRelation().getRelation(), 1.0);
            if (!iDDLReasoner.isEntailed((Alignment)objectAlignment)) continue;
            ++this.nbexpectedentailed;
        }
        this.precision = (double)this.nbfoundentailed / (double)this.nbfound;
        this.recall = (double)this.nbexpectedentailed / (double)this.nbexpected;
        return this.computeDerived();
    }

    public int getFoundEntailed() {
        return this.nbfoundentailed;
    }

    public int getExpectedEntailed() {
        return this.nbexpectedentailed;
    }
}

