/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.eval;

import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.BasicEvaluator;
import fr.inrialpes.exmo.align.impl.Namespace;
import fr.inrialpes.exmo.align.parser.SyntaxElement;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Evaluator;

public class PRecEvaluator
extends BasicEvaluator
implements Evaluator {
    protected double precision = 0.0;
    protected double recall = 0.0;
    protected double fallout = 0.0;
    protected double overall = 0.0;
    protected double fmeasure = 0.0;
    protected long time = 0L;
    protected int nbexpected = 0;
    protected int nbfound = 0;
    protected int nbcorrect = 0;

    public PRecEvaluator(Alignment alignment, Alignment alignment2) throws AlignmentException {
        super(((BasicAlignment)alignment).toURIAlignment(), ((BasicAlignment)alignment2).toURIAlignment());
    }

    public void init() {
        this.precision = 0.0;
        this.recall = 0.0;
        this.fallout = 0.0;
        this.overall = 0.0;
        this.fmeasure = 0.0;
        this.time = 0L;
        this.nbexpected = 0;
        this.nbfound = 0;
        this.nbcorrect = 0;
        this.result = 1.0;
    }

    public double eval(Properties properties) throws AlignmentException {
        this.init();
        this.nbfound = this.align2.nbCells();
        block0: for (Cell cell : this.align1) {
            URI uRI = cell.getObject2AsURI();
            ++this.nbexpected;
            Set set = this.align2.getAlignCells1(cell.getObject1());
            if (set == null) continue;
            for (Cell cell2 : set) {
                URI uRI2 = cell2.getObject2AsURI();
                if (!uRI.toString().equals(uRI2.toString())) continue;
                ++this.nbcorrect;
                continue block0;
            }
        }
        this.precision = (double)this.nbcorrect / (double)this.nbfound;
        this.recall = (double)this.nbcorrect / (double)this.nbexpected;
        return this.computeDerived();
    }

    public double eval(Properties properties, Object object) throws AlignmentException {
        return this.eval(properties);
    }

    protected double computeDerived() {
        this.fallout = (double)(this.nbfound - this.nbcorrect) / (double)this.nbfound;
        this.fmeasure = 2.0 * this.precision * this.recall / (this.precision + this.recall);
        this.overall = this.recall * (2.0 - 1.0 / this.precision);
        this.result = this.recall / this.precision;
        String string = this.align2.getExtension(Namespace.ALIGNMENT.uri, Annotations.TIME);
        if (string != null) {
            this.time = Long.parseLong(string);
        }
        return this.result;
    }

    public String HTMLString() {
        String string = "";
        string = string + "  <div  xmlns:" + Namespace.ATLMAP.shortCut + "='" + Namespace.ATLMAP.prefix + "' typeof=\"" + Namespace.ATLMAP.shortCut + ":output\" href=''>";
        string = string + "    <dl>";
        try {
            string = string + "    <dt>input1</dt><dd rel=\"" + Namespace.ATLMAP.shortCut + ":input1\" href=\"" + this.align1.getOntology1URI() + "\">" + this.align1.getOntology1URI() + "</dd>";
            string = string + "    <dt>input2</dt><dd rel=\"" + Namespace.ATLMAP.shortCut + ":input2\" href=\"" + this.align1.getOntology2URI() + "\">" + this.align1.getOntology2URI() + "</dd>";
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        string = string + "    <dt>precision</dt><dd property=\"" + Namespace.ATLMAP.shortCut + ":precision\">" + this.precision + "</dd>\n";
        string = string + "    <dt>recall</dt><dd property=\"" + Namespace.ATLMAP.shortCut + ":recall\">" + this.recall + "</dd>\n";
        string = string + "    <dt>fallout</dt><dd property=\"" + Namespace.ATLMAP.shortCut + ":fallout\">" + this.fallout + "</dd>\n";
        string = string + "    <dt>F-measure</dt><dd property=\"" + Namespace.ATLMAP.shortCut + ":fMeasure\">" + this.fmeasure + "</dd>\n";
        string = string + "    <dt>O-measure</dt><dd property=\"" + Namespace.ATLMAP.shortCut + ":oMeasure\">" + this.overall + "</dd>\n";
        if (this.time != 0L) {
            string = string + "    <dt>time</dt><dd property=\"" + Namespace.ATLMAP.shortCut + ":time\">" + this.time + "</dd>\n";
        }
        string = string + "    <dt>result</dt><dd property=\"" + Namespace.ATLMAP.shortCut + ":result\">" + string + "</dd>\n";
        string = string + "  </dl>\n  </div>\n";
        return string;
    }

    @Override
    public void write(PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version='1.0' encoding='utf-8' standalone='yes'?>");
        printWriter.println("<" + SyntaxElement.RDF.print() + " xmlns:" + Namespace.RDF.shortCut + "='" + Namespace.RDF.prefix + "'\n  xmlns:" + Namespace.ATLMAP.shortCut + "='" + Namespace.ATLMAP.prefix + "'>");
        printWriter.println("  <" + Namespace.ATLMAP.shortCut + ":output " + SyntaxElement.RDF_ABOUT.print() + "=''>");
        try {
            printWriter.println("    <" + Namespace.ATLMAP.shortCut + ":input1 " + SyntaxElement.RDF_RESOURCE.print() + "=\"" + this.align1.getOntology1URI() + "\"/>");
            printWriter.println("    <" + Namespace.ATLMAP.shortCut + ":input2 " + SyntaxElement.RDF_RESOURCE.print() + "=\"" + this.align1.getOntology2URI() + "\"/>");
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        printWriter.print("    <" + Namespace.ATLMAP.shortCut + ":precision>");
        printWriter.print(this.precision);
        printWriter.print("</" + Namespace.ATLMAP.shortCut + ":precision>\n    <" + Namespace.ATLMAP.shortCut + ":recall>");
        printWriter.print(this.recall);
        printWriter.print("</" + Namespace.ATLMAP.shortCut + ":recall>\n    <fallout>");
        printWriter.print(this.fallout);
        printWriter.print("</fallout>\n    <" + Namespace.ATLMAP.shortCut + ":fMeasure>");
        printWriter.print(this.fmeasure);
        printWriter.print("</" + Namespace.ATLMAP.shortCut + ":fMeasure>\n    <" + Namespace.ATLMAP.shortCut + ":oMeasure>");
        printWriter.print(this.overall);
        printWriter.print("</" + Namespace.ATLMAP.shortCut + ":oMeasure>\n");
        if (this.time != 0L) {
            printWriter.print("    <time>" + this.time + "</time>\n");
        }
        printWriter.print("    <result>" + this.result);
        printWriter.print("</result>\n  </" + Namespace.ATLMAP.shortCut + ":output>\n</" + SyntaxElement.RDF.print() + ">\n");
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public double getOverall() {
        return this.overall;
    }

    public double getFallout() {
        return this.fallout;
    }

    public double getFmeasure() {
        return this.fmeasure;
    }

    public int getExpected() {
        return this.nbexpected;
    }

    public int getFound() {
        return this.nbfound;
    }

    public int getCorrect() {
        return this.nbcorrect;
    }

    public long getTime() {
        return this.time;
    }
}

