/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.eval;

import fr.inrialpes.exmo.align.impl.eval.EvalCell;
import fr.inrialpes.exmo.align.impl.eval.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Comparator;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;

public abstract class GraphEvaluator {
    protected int STEP = 10;
    protected int nbexpected = 0;
    protected SortedSet<EvalCell> cellSet = null;
    public Vector<Pair> points;

    public abstract Vector<Pair> eval() throws AlignmentException;

    public abstract Vector<Pair> eval(Properties var1) throws AlignmentException;

    public abstract double getGlobalResult();

    public void setStep(int n) {
        if (0 < n && n <= 100) {
            this.STEP = n;
        }
    }

    public int getStep() {
        return this.STEP;
    }

    public GraphEvaluator() {
        this.initCellSet();
    }

    protected void initCellSet() {
        this.cellSet = new TreeSet<EvalCell>(new Comparator<EvalCell>(){

            @Override
            public int compare(EvalCell evalCell, EvalCell evalCell2) throws ClassCastException {
                if (evalCell.cell instanceof Cell && evalCell2.cell instanceof Cell) {
                    if (evalCell.cell.getStrength() > evalCell2.cell.getStrength()) {
                        return -1;
                    }
                    if (evalCell.cell.getStrength() < evalCell2.cell.getStrength()) {
                        return 1;
                    }
                    if (evalCell.correct) {
                        return -1;
                    }
                    return 1;
                }
                throw new ClassCastException();
            }
        });
    }

    public void ingest(Alignment alignment, Alignment alignment2) {
        this.nbexpected += alignment2.nbCells();
        if (alignment == null) {
            return;
        }
        for (Cell cell : alignment) {
            this.cellSet.add(new EvalCell(cell, this.isCorrect(cell, alignment2)));
        }
    }

    public int nbCells() {
        if (this.cellSet == null) {
            return 0;
        }
        return this.cellSet.size();
    }

    public boolean isCorrect(Cell cell, Alignment alignment) {
        try {
            Set set = alignment.getAlignCells1(cell.getObject1());
            if (set == null) {
                return false;
            }
            URI uRI = cell.getObject2AsURI();
            for (Cell cell2 : set) {
                URI uRI2 = cell2.getObject2AsURI();
                if (!uRI.toString().equals(uRI2.toString())) continue;
                return true;
            }
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        return false;
    }

    public void writeXMLMap(PrintWriter printWriter) throws IOException {
        for (Pair pair : this.points) {
            printWriter.print("    <step>\n      <x>");
            printWriter.print(pair.getX());
            printWriter.print("</x>\n      <y>");
            printWriter.print(pair.getY());
            printWriter.print("</y>\n    </step>\n");
        }
    }

    public void writePlot(PrintWriter printWriter) {
        for (Pair pair : this.points) {
            printWriter.println(pair.getX() / 10.0 + "\t" + pair.getY());
        }
    }
}

