/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.eval;

import fr.inrialpes.exmo.align.impl.BasicEvaluator;
import fr.inrialpes.exmo.align.impl.Namespace;
import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.parser.SyntaxElement;
import fr.inrialpes.exmo.ontowrap.HeavyLoadedOntology;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;

public class ExtPREvaluator
extends BasicEvaluator {
    private HeavyLoadedOntology<Object> onto1;
    private HeavyLoadedOntology<Object> onto2;
    private double symALPHA = 0.5;
    private double symprec = 1.0;
    private double symrec = 1.0;
    private double effprec = 1.0;
    private double effrec = 1.0;
    private double orientprec = 1.0;
    private double orientrec = 1.0;
    private int nbexpected = 0;
    private int nbfound = 0;
    private double symsimilarity = 0.0;
    private double effsimilarity = 0.0;
    private double orientsimilarity = 0.0;

    public ExtPREvaluator(Alignment alignment, Alignment alignment2) {
        super(alignment, alignment2);
    }

    public double getSymPrecision() {
        return this.symprec;
    }

    public double getSymRecall() {
        return this.symrec;
    }

    public double getSymSimilarity() {
        return this.symsimilarity;
    }

    public double getEffPrecision() {
        return this.effprec;
    }

    public double getEffRecall() {
        return this.effrec;
    }

    public double getEffSimilarity() {
        return this.effsimilarity;
    }

    public double getOrientPrecision() {
        return this.orientprec;
    }

    public double getOrientRecall() {
        return this.orientrec;
    }

    public double getOrientSimilarity() {
        return this.orientsimilarity;
    }

    public int getExpected() {
        return this.nbexpected;
    }

    public int getFound() {
        return this.nbfound;
    }

    public double eval(Properties properties) throws AlignmentException {
        return this.eval(properties, null);
    }

    public double eval(Properties properties, Object object) throws AlignmentException {
        if (!(this.align1 instanceof ObjectAlignment) || !(this.align2 instanceof ObjectAlignment)) {
            throw new AlignmentException("ExtPREvaluation: requires ObjectAlignments");
        }
        LoadedOntology loadedOntology = (LoadedOntology)((ObjectAlignment)this.align1).getOntologyObject1();
        LoadedOntology loadedOntology2 = (LoadedOntology)((ObjectAlignment)this.align1).getOntologyObject2();
        if (!(loadedOntology instanceof HeavyLoadedOntology) || !(loadedOntology2 instanceof HeavyLoadedOntology)) {
            throw new AlignmentException("ExtPREvaluation: requires HeavyLoadedOntology");
        }
        this.onto1 = (HeavyLoadedOntology)loadedOntology;
        this.onto2 = (HeavyLoadedOntology)loadedOntology2;
        this.nbexpected = this.align1.nbCells();
        this.nbfound = this.align2.nbCells();
        for (Cell cell : this.align1) {
            Set set = this.align2.getAlignCells1(cell.getObject1());
            if (set == null) continue;
            Object object2 = set.iterator();
            while (object2.hasNext() && cell != null) {
                Cell cell2 = (Cell)object2.next();
                try {
                    URI uRI = this.onto2.getEntityURI(cell.getObject2());
                    URI uRI2 = this.onto2.getEntityURI(cell2.getObject2());
                    if (!uRI.toString().equals(uRI2.toString())) continue;
                    this.symsimilarity += 1.0;
                    this.effsimilarity += 1.0;
                    this.orientsimilarity += 1.0;
                    cell = null;
                }
                catch (OntowrapException ontowrapException) {
                    throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
                }
            }
            object2 = this.align2.getElements();
            if (cell == null) continue;
            this.symsimilarity += this.computeSymSimilarity(cell, (Enumeration)object2);
            this.effsimilarity += this.computeEffSimilarity(cell, (Enumeration)object2);
            this.orientsimilarity += this.computeOrientSimilarity(cell, (Enumeration)object2);
        }
        if (this.nbfound != 0) {
            this.symprec = this.symsimilarity / (double)this.nbfound;
        }
        if (this.nbexpected != 0) {
            this.symrec = this.symsimilarity / (double)this.nbexpected;
        }
        this.effsimilarity = this.symsimilarity;
        if (this.nbfound != 0) {
            this.effprec = this.effsimilarity / (double)this.nbfound;
        }
        if (this.nbexpected != 0) {
            this.effrec = this.effsimilarity / (double)this.nbexpected;
        }
        this.orientsimilarity = this.symsimilarity;
        if (this.nbfound != 0) {
            this.orientprec = this.orientsimilarity / (double)this.nbfound;
        }
        if (this.nbexpected != 0) {
            this.orientrec = this.orientsimilarity / (double)this.nbexpected;
        }
        return this.result;
    }

    protected double computeSymSimilarity(Cell cell, Enumeration enumeration) {
        int n = 0;
        int n2 = 0;
        try {
            while (enumeration.hasMoreElements()) {
                Cell cell2 = (Cell)enumeration.nextElement();
                if (this.onto1.getEntityURI(cell.getObject1()).toString().equals(this.onto1.getEntityURI(cell2.getObject1()).toString())) {
                    n2 = this.relativePosition(cell.getObject2(), cell2.getObject2(), this.onto2);
                    if (n2 == 0 || n2 >= n) continue;
                    n = n2;
                    continue;
                }
                if (!this.onto2.getEntityURI(cell.getObject2()).toString().equals(this.onto2.getEntityURI(cell2.getObject2()).toString()) || (n2 = this.relativePosition(cell.getObject1(), cell2.getObject1(), this.onto1)) == 0 || n2 >= n) continue;
                n = n2;
            }
        }
        catch (OntowrapException ontowrapException) {
            return 0.0;
        }
        catch (AlignmentException alignmentException) {
            return 0.0;
        }
        return Math.pow(this.symALPHA, n);
    }

    protected double computeEffSimilarity(Cell cell, Enumeration enumeration) {
        return 0.0;
    }

    protected double computeOrientSimilarity(Cell cell, Enumeration enumeration) {
        return 0.0;
    }

    protected int relativePosition(Object object, Object object2, HeavyLoadedOntology<Object> heavyLoadedOntology) throws AlignmentException {
        if (heavyLoadedOntology.isClass(object) && heavyLoadedOntology.isClass(object2)) {
            this.isSuperClass(object2, object, heavyLoadedOntology);
        } else {
            if (heavyLoadedOntology.isProperty(object) && heavyLoadedOntology.isProperty(object2)) {
                if (this.isSuperProperty(object2, object, heavyLoadedOntology)) {
                    return -1;
                }
                if (this.isSuperProperty(object, object2, heavyLoadedOntology)) {
                    return 1;
                }
                return 0;
            }
            if (heavyLoadedOntology.isIndividual(object) && heavyLoadedOntology.isIndividual(object2)) {
                return 0;
            }
        }
        return 0;
    }

    public boolean isSuperProperty(Object object, Object object2, HeavyLoadedOntology<Object> heavyLoadedOntology) throws AlignmentException {
        return heavyLoadedOntology.getSuperProperties(object2, OntologyFactory.DIRECT, OntologyFactory.ANY, OntologyFactory.ANY).contains(object);
    }

    public int superClassPosition(Object object, Object object2, HeavyLoadedOntology<Object> heavyLoadedOntology) throws AlignmentException {
        int n = -this.isSuperClass(object2, object, heavyLoadedOntology);
        if (n == 0) {
            n = this.isSuperClass(object, object2, heavyLoadedOntology);
        }
        return n;
    }

    public int isSuperClass(Object object, Object object2, HeavyLoadedOntology<Object> heavyLoadedOntology) throws AlignmentException {
        try {
            URI uRI = heavyLoadedOntology.getEntityURI(object);
            HashSet hashSet = null;
            HashSet hashSet2 = heavyLoadedOntology.getSuperClasses(object, OntologyFactory.DIRECT, OntologyFactory.ANY, OntologyFactory.ANY);
            int n = 0;
            while (!hashSet2.isEmpty()) {
                hashSet = hashSet2;
                hashSet2 = new HashSet();
                ++n;
                for (Object e : hashSet) {
                    if (!heavyLoadedOntology.isClass(e)) continue;
                    URI uRI2 = heavyLoadedOntology.getEntityURI(e);
                    if (uRI.toString().equals(uRI2.toString())) {
                        return n;
                    }
                    hashSet2.addAll(heavyLoadedOntology.getSuperClasses(e, OntologyFactory.DIRECT, OntologyFactory.ANY, OntologyFactory.ANY));
                }
            }
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot find entity URI", (Exception)((Object)ontowrapException));
        }
        return 0;
    }

    @Override
    public void write(PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version='1.0' encoding='utf-8' standalone='yes'?>");
        printWriter.println("<" + SyntaxElement.RDF.print() + " xmlns:" + Namespace.RDF.shortCut + "='" + Namespace.RDF.prefix + "'\n  xmlns:" + Namespace.ATLMAP.shortCut + "='" + Namespace.ATLMAP.prefix + "'>");
        printWriter.println("  <" + Namespace.ATLMAP.shortCut + ":output " + SyntaxElement.RDF_ABOUT.print() + "=''>");
        printWriter.println("    <" + Namespace.ATLMAP.shortCut + ":input1 " + SyntaxElement.RDF_RESOURCE.print() + "=\"" + ((ObjectAlignment)this.align1).getOntologyObject1().getURI() + "\">");
        printWriter.println("    <" + Namespace.ATLMAP.shortCut + ":input2 " + SyntaxElement.RDF_RESOURCE.print() + "=\"" + ((ObjectAlignment)this.align1).getOntologyObject2().getURI() + "\">");
        printWriter.print("    <" + Namespace.ATLMAP.shortCut + ":symmetricprecision>");
        printWriter.print(this.symprec);
        printWriter.print("</" + Namespace.ATLMAP.shortCut + ":symmetricprecision>\n    <" + Namespace.ATLMAP.shortCut + ":symmetricrecall>");
        printWriter.print(this.symrec);
        printWriter.print("</" + Namespace.ATLMAP.shortCut + ":symmetricrecall>\n    <" + Namespace.ATLMAP.shortCut + ":effortbasedprecision>");
        printWriter.print(this.effprec);
        printWriter.print("</" + Namespace.ATLMAP.shortCut + ":effortbasedprecision>\n    <" + Namespace.ATLMAP.shortCut + ":effortbasedrecall>");
        printWriter.print(this.effrec);
        printWriter.print("</" + Namespace.ATLMAP.shortCut + ":effortbasedrecall>\n    <" + Namespace.ATLMAP.shortCut + ":orientedprecision>");
        printWriter.print(this.orientprec);
        printWriter.print("</" + Namespace.ATLMAP.shortCut + ":orientedprecision>\n    <" + Namespace.ATLMAP.shortCut + ":orientedrecall>");
        printWriter.print(this.orientrec);
        printWriter.print("</" + Namespace.ATLMAP.shortCut + ":orientedrecall>\n  </" + Namespace.ATLMAP.shortCut + ":output>\n</" + SyntaxElement.RDF.print() + ">\n");
    }
}

