/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.eval;

import fr.inrialpes.exmo.align.impl.eval.EvalCell;
import fr.inrialpes.exmo.align.impl.eval.GraphEvaluator;
import fr.inrialpes.exmo.align.impl.eval.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Vector;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;

public class AveragePRGraphEvaluator
extends GraphEvaluator {
    private int size = 0;
    private double[] precisions = new double[this.STEP + 1];
    private double map = 0.0;
    private double rawmap = 0.0;

    public AveragePRGraphEvaluator() {
        this.points = new Vector();
    }

    @Override
    public Vector<Pair> eval() {
        Vector<Pair> vector = new Vector<Pair>(this.STEP + 1);
        for (int i = 0; i <= this.STEP; ++i) {
            vector.add(new Pair((double)i / 10.0, this.precisions[i] / (double)this.size));
        }
        this.map = this.rawmap / (double)this.size;
        return vector;
    }

    @Override
    public Vector<Pair> eval(Properties properties) {
        return this.eval();
    }

    @Override
    public void ingest(Alignment alignment, Alignment alignment2) {
        ++this.size;
        try {
            this.evalAlignment(alignment2, alignment);
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
    }

    public void evalAlignment(Alignment alignment, Alignment alignment2) throws AlignmentException {
        double d;
        double d2;
        int n = alignment.nbCells();
        int n2 = 0;
        int n3 = 0;
        double d3 = 0.0;
        Vector<Pair> vector = new Vector<Pair>();
        this.initCellSet();
        if (alignment2 == null) {
            return;
        }
        for (Object object : alignment2) {
            this.cellSet.add(new EvalCell((Cell)object, this.isCorrect((Cell)object, alignment)));
        }
        vector.add(new Pair(0.0, 1.0));
        for (Object object : this.cellSet) {
            ++n2;
            if (!((EvalCell)object).correct()) continue;
            d2 = (double)(++n3) / (double)n;
            d = (double)n3 / (double)n2;
            d3 += d;
            vector.add(new Pair(d2, d));
            object = null;
        }
        vector.add(new Pair(1.0, 0.0));
        int n4 = this.STEP;
        d2 = (double)n4 / (double)this.STEP;
        d = 0.0;
        for (int i = vector.size() - 1; i >= 0; --i) {
            Pair pair = (Pair)vector.get(i);
            while (pair.getX() < d2) {
                int n5 = n4--;
                this.precisions[n5] = this.precisions[n5] + d;
                d2 = (double)n4 / (double)this.STEP;
            }
            if (!(pair.getY() > d)) continue;
            d = pair.getY();
        }
        this.precisions[0] = this.precisions[0] + d;
        this.rawmap += d3 / (double)n;
    }

    public void write(PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version='1.0' encoding='utf-8' standalone='yes'?>");
        printWriter.println("<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>");
        printWriter.println("  <output rdf:about=''>");
        for (int i = 0; i <= this.STEP; ++i) {
            printWriter.print("    <step>\n      <recall>");
            printWriter.print((double)i / (double)this.STEP);
            printWriter.print("</recall>\n      <precision>");
            printWriter.print(this.precisions[i]);
            printWriter.print("</precision>\n    </step>\n");
        }
        printWriter.print("    <MAP>" + this.map + "</MAP>\n");
        printWriter.print("  </output>\n</rdf:RDF>\n");
    }

    @Override
    public void writePlot(PrintWriter printWriter) {
        for (int i = 0; i < this.STEP + 1; ++i) {
            printWriter.println((double)i / 10.0 + "\t" + this.precisions[i]);
        }
    }

    public double getPrecision(int n) {
        return this.precisions[n];
    }

    public double getMAP() {
        return this.map;
    }

    @Override
    public double getGlobalResult() {
        return this.map;
    }
}

