/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.edoal;

import fr.inrialpes.exmo.align.impl.edoal.Id;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Visitable;

public class TransfService
implements Cloneable,
Visitable {
    private URI res;
    private URI id;
    private Set<Id> params;

    public TransfService(URI uRI, Collection<Id> collection) {
        this(uRI, null, collection);
    }

    public void accept(AlignmentVisitor alignmentVisitor) throws AlignmentException {
        alignmentVisitor.visit((Visitable)this);
    }

    public TransfService(URI uRI, URI uRI2, Collection<Id> collection) {
        if (uRI == null) {
            throw new NullPointerException("The resource must not be null");
        }
        this.res = uRI;
        this.id = uRI2;
        if (collection == null) {
            this.params = Collections.EMPTY_SET;
        } else {
            this.params = new HashSet<Id>(collection);
            this.params.remove(null);
        }
    }

    public URI getRes() {
        return this.res;
    }

    public URI getId() {
        return this.id;
    }

    public Set<Id> getParameters() {
        return Collections.unmodifiableSet(this.params);
    }

    public boolean hasId() {
        return this.id != null;
    }

    public String toString() {
        return "transf: " + this.res + (this.id != null ? " id: " + this.id : "") + " params: " + this.params;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TransfService)) {
            return false;
        }
        TransfService transfService = (TransfService)object;
        return this.res.equals(transfService.res) && (this.id == transfService.id || this.id != null && this.id.equals(transfService.id)) && this.params.size() == transfService.params.size() && this.params.containsAll(transfService.params);
    }

    public int hashCode() {
        int n = 17;
        n = n * 37 + this.res.hashCode();
        n = n * 37 + (this.id != null ? this.id.hashCode() : 0);
        n = n * 37 + ((Object)this.params).hashCode();
        return n;
    }

    public Object clone() {
        try {
            TransfService transfService = (TransfService)super.clone();
            transfService.res = this.res;
            transfService.params = this.params.isEmpty() ? Collections.EMPTY_SET : new HashSet<Id>(this.params);
            transfService.id = this.id == null ? null : this.id;
            return transfService;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

