/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.edoal;

import fr.inrialpes.exmo.align.impl.edoal.Id;
import fr.inrialpes.exmo.align.impl.edoal.RelationExpression;
import java.net.URI;
import java.net.URISyntaxException;
import org.semanticweb.owl.align.AlignmentException;

public class RelationId
extends RelationExpression
implements Id {
    private String id;
    URI uri;

    public RelationId() {
    }

    public RelationId(String string) throws AlignmentException {
        if (string == null) {
            throw new NullPointerException("The id must not be null");
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException("The id must be longer than 0 characters");
        }
        this.id = string;
        try {
            this.uri = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AlignmentException("Not an URI " + string, (Exception)uRISyntaxException);
        }
    }

    public RelationId(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("The URI must not be null");
        }
        this.uri = uRI;
        this.id = uRI.toString();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String plainText() {
        return this.id;
    }

    public String toString() {
        return "RelationId: " + this.id;
    }

    public int hashCode() {
        int n = 17;
        n = n * 37 + this.uri.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RelationId)) {
            return false;
        }
        RelationId relationId = (RelationId)object;
        return this.id.equals(relationId.id);
    }
}

