/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.edoal;

import fr.inrialpes.exmo.align.parser.TypeCheckingVisitor;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;
import org.xml.sax.ContentHandler;

public class EDOALRelation
implements Relation {
    protected String type = null;
    protected Direction direction = null;

    public void accept(AlignmentVisitor alignmentVisitor) throws AlignmentException {
        alignmentVisitor.visit((Visitable)this);
    }

    public void accept(TypeCheckingVisitor typeCheckingVisitor) throws AlignmentException {
        typeCheckingVisitor.visit(this);
    }

    public EDOALRelation(String string) throws AlignmentException {
        this.direction = Direction.getRelation(string);
        if (this.direction == null) {
            throw new AlignmentException("Unknown EDOALRelation : " + string);
        }
        this.type = string;
    }

    public EDOALRelation(Direction direction) {
        this.type = direction.toString();
        this.direction = direction;
    }

    public EDOALRelation(String string, Direction direction) {
        this.direction = direction;
        this.type = string;
    }

    public String getRelation() {
        return this.type;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Relation compose(Relation relation) {
        String string = null;
        Direction direction = null;
        if (!(relation instanceof EDOALRelation)) {
            return null;
        }
        String string2 = ((EDOALRelation)relation).getRelation();
        if (this.type.startsWith("Class")) {
            string = "Class";
        } else if (this.type.startsWith("Relation")) {
            string = "Relation";
        } else if (this.type.startsWith("Attribute")) {
            string = "Attribute";
        } else if (this.type.startsWith("Instance")) {
            string = "Instance";
        }
        if (this.type.endsWith("Class") && !string2.startsWith("Class") || this.type.endsWith("Relation") && !string2.startsWith("Relation") || this.type.endsWith("Attribute") && !string2.startsWith("Attribute") || this.type.endsWith("Instance") && !string2.startsWith("Instance")) {
            return null;
        }
        if (string2.endsWith("Class")) {
            string = string + "Class";
        } else if (string2.endsWith("Relation")) {
            string = string + "Relation";
        } else if (string2.endsWith("Attribute")) {
            string = string + "Attribute";
        } else if (string2.endsWith("Instance")) {
            string = string + "Instance";
        }
        Direction direction2 = ((EDOALRelation)relation).getDirection();
        if (this.direction == Direction.GENERIC || direction2 == Direction.GENERIC || this.direction == null || direction2 == null) {
            return null;
        }
        if (this.direction == Direction.EQUIVALENCE) {
            direction = direction2;
        } else if (this.direction == Direction.SUBSUMES) {
            if (direction2 == Direction.SUBSUMES || direction2 == Direction.EQUIVALENCE) {
                direction = Direction.SUBSUMES;
            } else if (direction2 == Direction.HASINSTANCE) {
                direction = Direction.HASINSTANCE;
            }
        } else if (this.direction == Direction.SUBSUMEDBY) {
            if (direction2 == Direction.SUBSUMEDBY || direction2 == Direction.EQUIVALENCE) {
                direction = Direction.SUBSUMEDBY;
            }
        } else if (this.direction == Direction.INSTANCEOF) {
            if (direction2 == Direction.SUBSUMEDBY || direction2 == Direction.EQUIVALENCE) {
                direction = Direction.INSTANCEOF;
            }
        } else if (this.direction == Direction.HASINSTANCE && direction2 == Direction.EQUIVALENCE) {
            direction = Direction.HASINSTANCE;
        }
        if (string != null && direction != null) {
            return new EDOALRelation(string, direction);
        }
        return null;
    }

    public Relation inverse() {
        if (this.type.equals("Class")) {
            return new EDOALRelation("Class", this.direction);
        }
        if (this.type.equals("ClassRelation")) {
            return new EDOALRelation("RelationClass", this.direction);
        }
        if (this.type.equals("ClassAttribute")) {
            return new EDOALRelation("AttributeClass", this.direction);
        }
        if (this.type.equals("ClassInstance")) {
            return new EDOALRelation("InstanceClass", this.direction);
        }
        if (this.type.equals("RelationClass")) {
            return new EDOALRelation("ClassRelation", this.direction);
        }
        if (this.type.equals("Relation")) {
            return new EDOALRelation("Relation", this.direction);
        }
        if (this.type.equals("RelationAttribute")) {
            return new EDOALRelation("AttributeRelation", this.direction);
        }
        if (this.type.equals("RelationInstance")) {
            return new EDOALRelation("InstanceRelation", this.direction);
        }
        if (this.type.equals("AttributeClass")) {
            return new EDOALRelation("ClassAttribute", this.direction);
        }
        if (this.type.equals("AttributeRelation")) {
            return new EDOALRelation("RelationAttribute", this.direction);
        }
        if (this.type.equals("Attribute")) {
            return new EDOALRelation("Attribute", this.direction);
        }
        if (this.type.equals("AttributeInstance")) {
            return new EDOALRelation("InstanceAttribute", this.direction);
        }
        if (this.type.equals("InstanceClass")) {
            return new EDOALRelation("ClassInstance", this.direction);
        }
        if (this.type.equals("InstanceRelation")) {
            return new EDOALRelation("RelationInstance", this.direction);
        }
        if (this.type.equals("InstanceAttribute")) {
            return new EDOALRelation("AttributeInstance", this.direction);
        }
        if (this.type.equals("Instance")) {
            return new EDOALRelation("Instance", this.direction);
        }
        return null;
    }

    public boolean equals(Relation relation) {
        if (relation instanceof EDOALRelation) {
            return this.type.equals(((EDOALRelation)relation).getRelation()) && this.direction.equals((Object)((EDOALRelation)relation).getDirection());
        }
        return false;
    }

    public int hashCode() {
        return 5 + 3 * this.type.hashCode() + 7 * this.direction.hashCode();
    }

    public void dump(ContentHandler contentHandler) {
    }

    public void write(PrintWriter printWriter) {
        printWriter.print(this.direction.toString());
    }

    public static enum Direction {
        GENERIC("Generic", null),
        EQUIVALENCE("Equivalence", "="),
        DISJOINTFROM("DisjointFrom", "><"),
        SUBSUMES("Subsumes", ">"),
        SUBSUMEDBY("SubsumedBy", "<"),
        INSTANCEOF("InstanceOf", null),
        HASINSTANCE("HasInstance", null);

        private final String EDOALRepr;
        private final String abbrev;
        private final URI uri;
        private static Map<String, Direction> nameIndex;

        private Direction(String string2, String string3) {
            this.EDOALRepr = string2;
            this.abbrev = string3;
            this.uri = null;
        }

        public String toString() {
            return this.EDOALRepr;
        }

        public static Direction getRelation(String string) {
            if (nameIndex == null) {
                nameIndex = new HashMap<String, Direction>();
                nameIndex.put("Equivalence", EQUIVALENCE);
                nameIndex.put("=", EQUIVALENCE);
                nameIndex.put("equivalence", EQUIVALENCE);
                nameIndex.put("ClassMapping", EQUIVALENCE);
                nameIndex.put("Subsumes", SUBSUMES);
                nameIndex.put(">", SUBSUMES);
                nameIndex.put("SubsumedBy", SUBSUMEDBY);
                nameIndex.put("<", SUBSUMEDBY);
                nameIndex.put("><", DISJOINTFROM);
                nameIndex.put("DisjointFrom", DISJOINTFROM);
                nameIndex.put("Disjoint", DISJOINTFROM);
                nameIndex.put("disjointFrom", DISJOINTFROM);
                nameIndex.put("disjoint", DISJOINTFROM);
                nameIndex.put("InstanceOf", INSTANCEOF);
                nameIndex.put("HasInstance", HASINSTANCE);
            }
            if (string == null) {
                throw new NullPointerException("The string to search must not be null");
            }
            return nameIndex.get(string);
        }

        static {
            nameIndex = null;
        }
    }
}

