/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.edoal;

import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.Extensions;
import fr.inrialpes.exmo.align.impl.Namespace;
import fr.inrialpes.exmo.align.impl.edoal.EDOALCell;
import fr.inrialpes.exmo.align.impl.edoal.EDOALRelation;
import fr.inrialpes.exmo.align.impl.edoal.Expression;
import fr.inrialpes.exmo.align.impl.edoal.Variable;
import fr.inrialpes.exmo.align.parser.TypeCheckingVisitor;
import fr.inrialpes.exmo.ontowrap.Ontology;
import java.net.URI;
import java.util.Hashtable;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;

public class EDOALAlignment
extends BasicAlignment {
    protected EDOALAlignment init = null;
    protected Hashtable<String, Variable> variables;

    public EDOALAlignment() {
        this.setLevel("2EDOAL");
        this.setXNamespace(Namespace.EDOAL.shortCut, Namespace.EDOAL.prefix);
        this.variables = new Hashtable();
    }

    public void accept(TypeCheckingVisitor typeCheckingVisitor) throws AlignmentException {
        typeCheckingVisitor.visit(this);
    }

    @Override
    public void init(Object object, Object object2) throws AlignmentException {
        if (object == null || object2 == null) {
            throw new AlignmentException("The source and target ontologies must not be null");
        }
        if (!(object instanceof Ontology) || !(object2 instanceof Ontology)) {
            throw new AlignmentException("arguments must be LoadedOntology");
        }
        super.init(object, object2);
    }

    public void loadInit(Alignment alignment) throws AlignmentException {
        if (!(alignment instanceof EDOALAlignment)) {
            throw new AlignmentException("EDOAL required as initial alignment");
        }
        this.init = (EDOALAlignment)alignment;
    }

    public Variable recordVariable(String string, Expression expression) {
        Variable variable = this.variables.get(string);
        if (variable == null) {
            variable = new Variable(string);
            this.variables.put(string, variable);
        }
        variable.addOccurence(expression);
        return variable;
    }

    public Cell addAlignCell(EDOALCell eDOALCell) throws AlignmentException {
        this.addCell(eDOALCell);
        return eDOALCell;
    }

    @Override
    public Cell addAlignCell(String string, Object object, Object object2, Relation relation, double d, Extensions extensions) throws AlignmentException {
        if (!(object instanceof Expression) || !(object2 instanceof Expression)) {
            throw new AlignmentException("arguments must be Expressions");
        }
        return super.addAlignCell(string, object, object2, relation, d, extensions);
    }

    @Override
    public Cell addAlignCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        if (!(object instanceof Expression) || !(object2 instanceof Expression)) {
            throw new AlignmentException("arguments must be Expressions");
        }
        return super.addAlignCell(string, object, object2, relation, d);
    }

    @Override
    public Cell addAlignCell(Object object, Object object2, String string, double d) throws AlignmentException {
        if (!(object instanceof Expression) || !(object2 instanceof Expression)) {
            throw new AlignmentException("arguments must be Expressions");
        }
        return super.addAlignCell(object, object2, string, d);
    }

    @Override
    public Cell addAlignCell(Object object, Object object2) throws AlignmentException {
        if (!(object instanceof Expression) || !(object2 instanceof Expression)) {
            throw new AlignmentException("arguments must be Expressions");
        }
        return super.addAlignCell(object, object2);
    }

    @Override
    public Cell createCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        return new EDOALCell(string, (Expression)object, (Expression)object2, (EDOALRelation)relation, d);
    }

    @Override
    public Set<Cell> getAlignCells1(Object object) throws AlignmentException {
        if (object instanceof Expression) {
            return super.getAlignCells1(object);
        }
        throw new AlignmentException("argument must be Expression");
    }

    @Override
    public Set<Cell> getAlignCells2(Object object) throws AlignmentException {
        if (object instanceof Expression) {
            return super.getAlignCells2(object);
        }
        throw new AlignmentException("argument must be Expression");
    }

    @Override
    public Cell getAlignCell1(Object object) throws AlignmentException {
        if (Annotations.STRICT_IMPLEMENTATION) {
            throw new AlignmentException("deprecated (use getAlignCells1 instead)");
        }
        if (object instanceof Expression) {
            return super.getAlignCell1(object);
        }
        throw new AlignmentException("argument must be Expression");
    }

    @Override
    public Cell getAlignCell2(Object object) throws AlignmentException {
        if (Annotations.STRICT_IMPLEMENTATION) {
            throw new AlignmentException("deprecated (use getAlignCells2 instead)");
        }
        if (object instanceof Expression) {
            return super.getAlignCell2(object);
        }
        throw new AlignmentException("argument must be Expression");
    }

    @Override
    public URI getOntology1URI() {
        return this.onto1.getURI();
    }

    @Override
    public URI getOntology2URI() {
        return this.onto2.getURI();
    }

    @Override
    public void setOntology1(Object object) throws AlignmentException {
        if (!(object instanceof Ontology)) {
            throw new AlignmentException("arguments must be Ontology");
        }
        super.setOntology1(object);
    }

    @Override
    public void setOntology2(Object object) throws AlignmentException {
        if (!(object instanceof Ontology)) {
            throw new AlignmentException("arguments must be Ontology");
        }
        super.setOntology2(object);
    }

    @Override
    public Object clone() {
        EDOALAlignment eDOALAlignment = new EDOALAlignment();
        try {
            eDOALAlignment.init((Ontology)this.getOntology1(), (Ontology)this.getOntology2());
        }
        catch (AlignmentException alignmentException) {
            // empty catch block
        }
        eDOALAlignment.setType(this.getType());
        eDOALAlignment.setLevel(this.getLevel());
        eDOALAlignment.setFile1(this.getFile1());
        eDOALAlignment.setFile2(this.getFile2());
        for (String[] stringArray : this.extensions.getValues()) {
            eDOALAlignment.setExtension(stringArray[0], stringArray[1], stringArray[2]);
        }
        eDOALAlignment.setExtension(Namespace.ALIGNMENT.getUriPrefix(), "id", null);
        try {
            eDOALAlignment.ingest(this);
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        return eDOALAlignment;
    }
}

