/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.edoal;

import fr.inrialpes.exmo.align.impl.edoal.ClassExpression;
import fr.inrialpes.exmo.align.impl.edoal.Id;
import java.net.URI;
import java.net.URISyntaxException;
import org.semanticweb.owl.align.AlignmentException;

public class ClassId
extends ClassExpression
implements Id {
    private String id;
    URI uri;

    public ClassId() {
    }

    public ClassId(String string) throws AlignmentException {
        if (string == null) {
            throw new NullPointerException("The id must not be null");
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException("The id must be longer than 0 characters");
        }
        this.id = string;
        try {
            this.uri = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AlignmentException("Not an URI " + string, (Exception)uRISyntaxException);
        }
    }

    public ClassId(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("The URI must not be null");
        }
        this.uri = uRI;
        this.id = uRI.toString();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String plainText() {
        return this.id;
    }

    public String toString() {
        return "classId: " + this.id;
    }

    public int hashCode() {
        int n = 17;
        n = n * 37 + this.id.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ClassId)) {
            return false;
        }
        ClassId classId = (ClassId)object;
        return this.id.equals(classId.id);
    }
}

