/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.BasicCell;
import fr.inrialpes.exmo.align.impl.Namespace;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.Ontology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.net.URI;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.xml.sax.ContentHandler;

public class ObjectCell
extends BasicCell {
    public ObjectCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        super(string, object, object2, relation, d);
    }

    @Override
    public URI getObject1AsURI(Alignment alignment) throws AlignmentException {
        Ontology<Object> ontology;
        if (alignment instanceof BasicAlignment && (ontology = ((BasicAlignment)alignment).getOntologyObject1()) instanceof LoadedOntology) {
            try {
                return ((LoadedOntology)ontology).getEntityURI(this.object1);
            }
            catch (OntowrapException ontowrapException) {
                throw new AlignmentException("Cannot find entity URI(1)", (Exception)((Object)ontowrapException));
            }
        }
        if (this.object1 instanceof URI) {
            return (URI)this.object1;
        }
        throw new AlignmentException("Cannot find URI for " + this.object1);
    }

    @Override
    public URI getObject2AsURI(Alignment alignment) throws AlignmentException {
        Ontology<Object> ontology;
        if (alignment instanceof BasicAlignment && (ontology = ((BasicAlignment)alignment).getOntologyObject2()) instanceof LoadedOntology) {
            try {
                return ((LoadedOntology)ontology).getEntityURI(this.object2);
            }
            catch (OntowrapException ontowrapException) {
                throw new AlignmentException("Cannot find entity URI(2)", (Exception)((Object)ontowrapException));
            }
        }
        if (this.object2 instanceof URI) {
            return (URI)this.object2;
        }
        throw new AlignmentException("Cannot find URI for " + this.object2);
    }

    @Override
    public Cell inverse() throws AlignmentException {
        ObjectCell objectCell = new ObjectCell(null, this.object2, this.object1, this.relation.inverse(), this.strength);
        if (this.extensions != null) {
            for (String[] stringArray : this.extensions.getValues()) {
                objectCell.setExtension(stringArray[0], stringArray[1], stringArray[2]);
            }
            objectCell.setExtension(Namespace.ALIGNMENT.getUriPrefix(), Annotations.ID, null);
        }
        return objectCell;
    }

    @Override
    public Cell compose(Cell cell) throws AlignmentException {
        if (!this.object2.equals(cell.getObject1()) && this.relation.compose(cell.getRelation()) == null) {
            return null;
        }
        ObjectCell objectCell = new ObjectCell(null, this.object1, cell.getObject2(), this.relation.compose(cell.getRelation()), this.strength * cell.getStrength());
        return objectCell;
    }

    @Override
    public void dump(ContentHandler contentHandler) {
    }
}

