/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.ObjectCell;
import fr.inrialpes.exmo.align.impl.URIAlignment;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.xml.sax.SAXException;

public class ObjectAlignment
extends BasicAlignment {
    protected ObjectAlignment init = null;

    @Override
    public void init(Object object, Object object2) throws AlignmentException {
        if (object instanceof LoadedOntology && object2 instanceof LoadedOntology) {
            super.init(object, object2);
        } else if (object instanceof URI && object2 instanceof URI) {
            super.init(ObjectAlignment.loadOntology((URI)object), ObjectAlignment.loadOntology((URI)object2));
        } else {
            throw new AlignmentException("Arguments must be LoadedOntology or URI");
        }
    }

    public LoadedOntology<Object> ontology1() {
        return (LoadedOntology)this.onto1;
    }

    public LoadedOntology<Object> ontology2() {
        return (LoadedOntology)this.onto2;
    }

    public void loadInit(Alignment alignment) throws AlignmentException {
        if (alignment instanceof URIAlignment) {
            try {
                this.init = ObjectAlignment.toObjectAlignment((URIAlignment)alignment);
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
        } else if (alignment instanceof ObjectAlignment) {
            this.init = (ObjectAlignment)alignment;
        }
    }

    @Override
    public URI getOntology1URI() {
        return this.onto1.getURI();
    }

    @Override
    public URI getOntology2URI() {
        return this.onto2.getURI();
    }

    @Override
    public Cell createCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        return new ObjectCell(string, object, object2, relation, d);
    }

    @Override
    public ObjectAlignment createNewAlignment(Object object, Object object2) throws AlignmentException {
        ObjectAlignment objectAlignment = new ObjectAlignment();
        objectAlignment.init(object, object2);
        return objectAlignment;
    }

    @Override
    public URIAlignment toURIAlignment() throws AlignmentException {
        URIAlignment uRIAlignment = new URIAlignment();
        uRIAlignment.init(this.getOntology1URI(), this.getOntology2URI());
        uRIAlignment.setType(this.getType());
        uRIAlignment.setLevel(this.getLevel());
        uRIAlignment.setFile1(this.getFile1());
        uRIAlignment.setFile2(this.getFile2());
        for (String[] cell : this.extensions.getValues()) {
            uRIAlignment.setExtension(cell[0], cell[1], cell[2]);
        }
        Enumeration<Cell> enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            try {
                uRIAlignment.addAlignCell(cell.getId(), cell.getObject1AsURI((Alignment)this), cell.getObject2AsURI((Alignment)this), cell.getRelation(), cell.getStrength());
            }
            catch (AlignmentException alignmentException) {}
        }
        return uRIAlignment;
    }

    public static ObjectAlignment toObjectAlignment(URIAlignment uRIAlignment) throws AlignmentException, SAXException {
        ObjectAlignment objectAlignment = new ObjectAlignment();
        objectAlignment.init(uRIAlignment.getFile1(), uRIAlignment.getFile2());
        objectAlignment.setType(uRIAlignment.getType());
        objectAlignment.setLevel(uRIAlignment.getLevel());
        for (String[] loadedOntology2 : uRIAlignment.getExtensions()) {
            objectAlignment.setExtension(loadedOntology2[0], loadedOntology2[1], loadedOntology2[2]);
        }
        LoadedOntology loadedOntology3 = (LoadedOntology)objectAlignment.getOntologyObject1();
        LoadedOntology loadedOntology = (LoadedOntology)objectAlignment.getOntologyObject2();
        try {
            Iterator<Cell> ontowrapException = uRIAlignment.iterator();
            while (ontowrapException.hasNext()) {
                Cell cell = ontowrapException.next();
                Cell cell2 = objectAlignment.addAlignCell(cell.getId(), loadedOntology3.getEntity(cell.getObject1AsURI((Alignment)objectAlignment)), loadedOntology.getEntity(cell.getObject2AsURI((Alignment)objectAlignment)), cell.getRelation(), cell.getStrength());
                Collection collection = cell.getExtensions();
                if (collection == null) continue;
                for (String[] stringArray : collection) {
                    cell2.setExtension(stringArray[0], stringArray[1], stringArray[2]);
                }
            }
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot dereference entity", (Exception)((Object)ontowrapException));
        }
        return objectAlignment;
    }

    static LoadedOntology loadOntology(URI uRI) throws AlignmentException {
        OntologyFactory ontologyFactory = OntologyFactory.getFactory();
        try {
            return ontologyFactory.loadOntology(uRI);
        }
        catch (OntowrapException ontowrapException) {
            throw new AlignmentException("Cannot load ontology " + uRI, (Exception)((Object)ontowrapException));
        }
    }
}

