/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.ConcatenatedIterator;
import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.impl.Similarity;
import fr.inrialpes.exmo.align.impl.URIAlignment;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;

public abstract class MatrixMeasure
implements Similarity {
    public LoadedOntology onto1 = null;
    public LoadedOntology onto2 = null;
    public int nbclass1 = 0;
    public int nbclass2 = 0;
    public int nbprop1 = 0;
    public int nbprop2 = 0;
    public int nbind1 = 0;
    public int nbind2 = 0;
    public int i;
    public int j = 0;
    public int l1;
    public int l2 = 0;
    public HashMap<Object, Integer> classlist2 = null;
    public HashMap<Object, Integer> classlist1 = null;
    public HashMap<Object, Integer> proplist2 = null;
    public HashMap<Object, Integer> proplist1 = null;
    public HashMap<Object, Integer> indlist2 = null;
    public HashMap<Object, Integer> indlist1 = null;
    private NumberFormat numFormat = null;
    public double[][] clmatrix;
    public double[][] prmatrix;
    public double[][] indmatrix;

    public void initialize(LoadedOntology loadedOntology, LoadedOntology loadedOntology2, Alignment alignment) {
        this.initialize(loadedOntology, loadedOntology2);
        try {
            ObjectAlignment objectAlignment;
            if (alignment instanceof URIAlignment) {
                objectAlignment = ObjectAlignment.toObjectAlignment((URIAlignment)alignment);
            } else if (alignment instanceof ObjectAlignment) {
                objectAlignment = (ObjectAlignment)alignment;
            } else {
                throw new AlignmentException("");
            }
            Iterator<Cell> iterator = objectAlignment.iterator();
            while (iterator.hasNext()) {
                Integer n;
                Integer n2;
                Cell cell = iterator.next();
                Object object = cell.getObject1();
                if (loadedOntology.isClass(object)) {
                    n2 = this.classlist1.get(object);
                    n = this.classlist2.get(cell.getObject2());
                    if (n2 == null || n == null) continue;
                    this.clmatrix[n2.intValue()][n.intValue()] = cell.getStrength();
                    continue;
                }
                if (loadedOntology.isProperty(object)) {
                    n2 = this.proplist1.get(object);
                    n = this.proplist2.get(cell.getObject2());
                    if (n2 == null || n == null) continue;
                    this.prmatrix[n2.intValue()][n.intValue()] = cell.getStrength();
                    continue;
                }
                n2 = this.indlist1.get(object);
                n = this.indlist2.get(cell.getObject2());
                if (n2 == null || n == null) continue;
                this.indmatrix[n2.intValue()][n.intValue()] = cell.getStrength();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(LoadedOntology loadedOntology, LoadedOntology loadedOntology2) {
        this.onto1 = loadedOntology;
        this.onto2 = loadedOntology2;
        this.classlist2 = new HashMap();
        this.classlist1 = new HashMap();
        this.proplist2 = new HashMap();
        this.proplist1 = new HashMap();
        this.indlist2 = new HashMap();
        this.indlist1 = new HashMap();
        try {
            for (Object e : this.onto2.getClasses()) {
                this.classlist2.put(e, new Integer(this.nbclass2++));
            }
            for (Object e : this.onto1.getClasses()) {
                this.classlist1.put(e, new Integer(this.nbclass1++));
            }
            this.clmatrix = new double[this.nbclass1 + 1][this.nbclass2 + 1];
            for (Object e : this.onto2.getObjectProperties()) {
                this.proplist2.put(e, new Integer(this.nbprop2++));
            }
            for (Object e : this.onto2.getDataProperties()) {
                this.proplist2.put(e, new Integer(this.nbprop2++));
            }
            for (Object e : this.onto1.getObjectProperties()) {
                this.proplist1.put(e, new Integer(this.nbprop1++));
            }
            for (Object e : this.onto1.getDataProperties()) {
                this.proplist1.put(e, new Integer(this.nbprop1++));
            }
            this.prmatrix = new double[this.nbprop1 + 1][this.nbprop2 + 1];
            for (Object e : this.onto2.getIndividuals()) {
                if (this.onto2.getEntityURI(e) == null) continue;
                this.indlist2.put(e, new Integer(this.nbind2++));
            }
            for (Object e : this.onto1.getIndividuals()) {
                if (this.onto1.getEntityURI(e) == null) continue;
                this.indlist1.put(e, new Integer(this.nbind1++));
            }
            this.indmatrix = new double[this.nbind1 + 1][this.nbind2 + 1];
        }
        catch (OntowrapException ontowrapException) {
            ontowrapException.printStackTrace();
        }
    }

    @Override
    public void compute(Properties properties) {
        try {
            Object object2;
            for (Object object2 : this.onto2.getClasses()) {
                for (Object object3 : this.onto1.getClasses()) {
                    this.clmatrix[this.classlist1.get(object3).intValue()][this.classlist2.get((Object)object2).intValue()] = this.classMeasure(object3, object2);
                }
            }
            for (Object object2 : this.onto2.getIndividuals()) {
                if (this.indlist2.get(object2) == null) continue;
                for (Object object3 : this.onto1.getIndividuals()) {
                    if (this.indlist1.get(object3) == null) continue;
                    this.indmatrix[this.indlist1.get(object3).intValue()][this.indlist2.get((Object)object2).intValue()] = this.individualMeasure(object3, object2);
                }
            }
            Iterator iterator = new ConcatenatedIterator(this.onto2.getObjectProperties().iterator(), this.onto2.getDataProperties().iterator());
            object2 = ((ConcatenatedIterator)iterator).iterator();
            while (object2.hasNext()) {
                Object object3;
                Iterator iterator2 = object2.next();
                object3 = new ConcatenatedIterator(this.onto1.getObjectProperties().iterator(), this.onto1.getDataProperties().iterator());
                for (Object o : object3) {
                    this.prmatrix[this.proplist1.get(o).intValue()][this.proplist2.get(iterator2).intValue()] = this.propertyMeasure(o, iterator2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public double getIndividualSimilarity(Object object, Object object2) {
        return this.indmatrix[this.indlist1.get(object)][this.indlist2.get(object2)];
    }

    @Override
    public double getClassSimilarity(Object object, Object object2) {
        return this.clmatrix[this.classlist1.get(object)][this.classlist2.get(object2)];
    }

    @Override
    public double getPropertySimilarity(Object object, Object object2) {
        return this.prmatrix[this.proplist1.get(object)][this.proplist2.get(object2)];
    }

    private void printMatrix(int n, HashMap<Object, Integer> hashMap, HashMap<Object, Integer> hashMap2, double[][] dArray) {
        this.numFormat = NumberFormat.getInstance();
        this.numFormat.setMinimumFractionDigits(2);
        this.numFormat.setMaximumFractionDigits(2);
        System.out.print("\\begin{tabular}{r|");
        for (int i = 0; i < n; ++i) {
            System.out.print("c");
        }
        System.out.println("}");
        try {
            Set<Object> set = hashMap.keySet();
            for (Object object : set) {
                System.out.print(" & \\rotatebox{90}{" + this.onto1.getEntityName(object) + "}");
            }
            System.out.println(" \\\\ \\hline");
            for (Object object : hashMap2.keySet()) {
                System.out.print(this.onto2.getEntityName(object));
                for (Object object2 : set) {
                    System.out.print(" & " + this.numFormat.format(dArray[hashMap.get(object2)][hashMap2.get(object)]));
                }
                System.out.println("\\\\");
            }
        }
        catch (OntowrapException ontowrapException) {
            ontowrapException.printStackTrace();
        }
        System.out.println("\n\\end{tabular}");
    }

    @Override
    public void printClassSimilarityMatrix(String string) {
        this.printMatrix(this.nbclass1, this.classlist1, this.classlist2, this.clmatrix);
    }

    @Override
    public void printPropertySimilarityMatrix(String string) {
        this.printMatrix(this.nbprop1, this.proplist1, this.proplist2, this.prmatrix);
    }

    @Override
    public void printIndividualSimilarityMatrix(String string) {
        this.printMatrix(this.nbind1, this.indlist1, this.indlist2, this.indmatrix);
    }
}

