/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.BasicOntologyNetwork;
import fr.inrialpes.exmo.iddl.IDDLReasoner;
import fr.inrialpes.exmo.iddl.conf.Semantics;
import java.net.URI;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.LogicOntologyNetwork;

public class IDDLOntologyNetwork
extends BasicOntologyNetwork
implements LogicOntologyNetwork {
    IDDLReasoner reasoner = null;
    String semantics = "";

    protected void init() {
        if (this.reasoner == null) {
            this.reasoner = this.semantics.equals("DL") ? new IDDLReasoner(Semantics.DL) : new IDDLReasoner(Semantics.IDDL);
            for (URI uRI : this.getOntologies()) {
                this.reasoner.addOntology(uRI);
            }
            for (URI uRI : this.alignments) {
                this.reasoner.addAlignment((Alignment)uRI);
            }
        }
    }

    public void setSemantics(String string) {
        this.semantics = string;
        if (this.reasoner != null) {
            if (this.semantics.equals("DL")) {
                this.reasoner.setSemantics(Semantics.DL);
            } else {
                this.reasoner.setSemantics(Semantics.IDDL);
            }
        }
    }

    public String getSemantics() {
        return this.semantics;
    }

    public boolean isConsistent() {
        this.init();
        return this.reasoner.isConsistent();
    }

    public boolean isEntailed(Alignment alignment) {
        this.init();
        return this.reasoner.isEntailed(alignment);
    }
}

