/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.BasicRelation;
import fr.inrialpes.exmo.align.impl.ConcatenatedIterator;
import fr.inrialpes.exmo.align.impl.ObjectAlignment;
import fr.inrialpes.exmo.align.impl.ObjectCell;
import fr.inrialpes.exmo.align.impl.Similarity;
import fr.inrialpes.exmo.ontosim.util.HungarianAlgorithm;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentProcess;
import org.semanticweb.owl.align.Cell;

public class DistanceAlignment
extends ObjectAlignment
implements AlignmentProcess {
    Similarity sim;

    public void setSimilarity(Similarity similarity) {
        this.sim = similarity;
    }

    public Similarity getSimilarity() {
        return this.sim;
    }

    public void addAlignDistanceCell(Object object, Object object2, String string, double d) throws AlignmentException {
        this.addAlignCell(object, object2, string, 1.0 - d);
    }

    public double getAlignedDistance1(Object object) throws AlignmentException {
        return 1.0 - this.getAlignedStrength1(object);
    }

    public double getAlignedDistance2(Object object) throws AlignmentException {
        return 1.0 - this.getAlignedStrength2(object);
    }

    public void align(Alignment alignment, Properties properties) throws AlignmentException {
        this.loadInit(alignment);
        if (properties.getProperty("type") != null) {
            this.setType(properties.getProperty("type"));
        } else {
            this.setType("11");
        }
        if (this.sim == null) {
            throw new AlignmentException("DistanceAlignment: requires a similarity measure");
        }
        this.sim.initialize(this.ontology1(), this.ontology2(), this.init);
        this.sim.compute(properties);
        if (properties.getProperty("printMatrix") != null) {
            this.printDistanceMatrix(properties);
        }
        this.extract(this.getType(), properties);
    }

    public void printDistanceMatrix(Properties properties) {
        System.out.println("\\documentclass{article}\n");
        System.out.println("\\usepackage{graphics}\n");
        System.out.println("\\begin{document}\n");
        System.out.println("\\begin{table}");
        this.sim.printClassSimilarityMatrix("tex");
        System.out.println("\\caption{Class distance with measure " + properties.getProperty("stringFunction") + "}");
        System.out.println("\\end{table}");
        System.out.println();
        System.out.println("\\begin{table}");
        this.sim.printPropertySimilarityMatrix("tex");
        System.out.println("\\caption{Property distance with measure " + properties.getProperty("stringFunction") + "}");
        System.out.println("\\end{table}");
        System.out.println();
        System.out.println("\\begin{table}");
        this.sim.printIndividualSimilarityMatrix("tex");
        System.out.println("\\caption{Individual distance with measure " + properties.getProperty("stringFunction") + "}");
        System.out.println("\\end{table}");
        System.out.println("\n\\end{document}");
    }

    @Override
    public void cleanUp() {
        this.sim = null;
    }

    public Alignment extract(String string, Properties properties) throws AlignmentException {
        double d = 0.0;
        if (properties.getProperty("threshold") != null) {
            d = Double.parseDouble(properties.getProperty("threshold"));
        }
        if (string.equals("?*") || string.equals("1*") || string.equals("?+") || string.equals("1+")) {
            return this.extractqs(d, properties);
        }
        if (string.equals("??") || string.equals("1?") || string.equals("?1") || string.equals("11")) {
            return this.extractqq(d, properties);
        }
        if (string.equals("*?") || string.equals("+?") || string.equals("*1") || string.equals("+1")) {
            return this.extractqs(d, properties);
        }
        if (string.equals("**") || string.equals("+*") || string.equals("*+") || string.equals("++")) {
            return this.extractqs(d, properties);
        }
        throw new AlignmentException("Unknown alignment type: " + string);
    }

    public Alignment extractqs(double d, Properties properties) {
        double d2 = 0.0;
        boolean bl = false;
        double d3 = 0.0;
        try {
            Iterator iterator;
            ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(this.ontology1().getObjectProperties().iterator(), this.ontology1().getDataProperties().iterator());
            for (Object e : concatenatedIterator) {
                bl = false;
                d2 = d;
                d3 = 0.0;
                iterator = null;
                Iterator iterator2 = new ConcatenatedIterator(this.ontology2().getObjectProperties().iterator(), this.ontology2().getDataProperties().iterator());
                Iterator iterator3 = ((ConcatenatedIterator)iterator2).iterator();
                while (iterator3.hasNext()) {
                    Object e2 = iterator3.next();
                    d3 = 1.0 - this.sim.getPropertySimilarity(e, e2);
                    if (!(d3 > d2)) continue;
                    bl = true;
                    d2 = d3;
                    iterator = e2;
                }
                if (!bl) continue;
                this.addAlignCell(e, iterator, "=", d2);
            }
            for (Object e : this.ontology1().getClasses()) {
                bl = false;
                d2 = d;
                d3 = 0.0;
                iterator = null;
                for (Iterator iterator3 : this.ontology2().getClasses()) {
                    d3 = 1.0 - this.sim.getClassSimilarity(e, iterator3);
                    if (!(d3 > d2)) continue;
                    bl = true;
                    d2 = d3;
                    iterator = iterator3;
                }
                if (!bl) continue;
                this.addAlignCell(e, iterator, "=", d2);
            }
            if (properties.getProperty("noinst") == null) {
                for (Object e : this.ontology1().getIndividuals()) {
                    if (this.ontology1().getEntityURI(e) == null) continue;
                    bl = false;
                    d2 = d;
                    d3 = 0.0;
                    iterator = null;
                    for (Iterator iterator3 : this.ontology2().getIndividuals()) {
                        if (this.ontology2().getEntityURI(iterator3) == null || !((d3 = 1.0 - this.sim.getIndividualSimilarity(e, iterator3)) > d2)) continue;
                        bl = true;
                        d2 = d3;
                        iterator = iterator3;
                    }
                    if (!bl) continue;
                    this.addAlignCell(e, iterator, "=", d2);
                }
            }
        }
        catch (OntowrapException ontowrapException) {
            ontowrapException.printStackTrace();
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        return this;
    }

    public Alignment extractqq(double d, Properties properties) {
        int n;
        Object object;
        Object[] objectArray;
        double[][] dArray;
        int n2;
        int n3;
        try {
            Object object22;
            n3 = this.ontology1().nbClasses();
            n2 = this.ontology2().nbClasses();
            dArray = new double[n3][n2];
            objectArray = new Object[n3];
            object = new Object[n2];
            n = 0;
            for (Object object22 : this.ontology1().getClasses()) {
                objectArray[n++] = object22;
            }
            int n4 = 0;
            for (Object e : this.ontology2().getClasses()) {
                object[n4++] = e;
            }
            for (n = 0; n < n3; ++n) {
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray[n][n4] = 1.0 - this.sim.getClassSimilarity(objectArray[n], object[n4]);
                }
            }
            object22 = HungarianAlgorithm.hgAlgorithm((double[][])dArray, (String)"max");
            for (n = 0; n < ((E)object22).length; ++n) {
                double d2 = 1.0 - this.sim.getClassSimilarity(objectArray[object22[n][0]], object[object22[n][1]]);
                if (!(d2 > d)) continue;
                this.addCell(new ObjectCell(null, objectArray[object22[n][0]], object[object22[n][1]], BasicRelation.createRelation("="), d2));
            }
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        try {
            n3 = this.ontology1().nbProperties();
            n2 = this.ontology2().nbProperties();
            dArray = new double[n3][n2];
            objectArray = new Object[n3];
            object = new Object[n2];
            n = 0;
            ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(this.ontology1().getObjectProperties().iterator(), this.ontology1().getDataProperties().iterator());
            for (Object e : concatenatedIterator) {
                objectArray[n++] = e;
            }
            int n5 = 0;
            ConcatenatedIterator concatenatedIterator2 = new ConcatenatedIterator(this.ontology2().getObjectProperties().iterator(), this.ontology2().getDataProperties().iterator());
            for (Object e : concatenatedIterator2) {
                object[n5++] = e;
            }
            for (n = 0; n < n3; ++n) {
                for (n5 = 0; n5 < n2; ++n5) {
                    dArray[n][n5] = 1.0 - this.sim.getPropertySimilarity(objectArray[n], object[n5]);
                }
            }
            Object object3 = HungarianAlgorithm.hgAlgorithm((double[][])dArray, (String)"max");
            for (n = 0; n < ((Object)object3).length; ++n) {
                double d3 = 1.0 - this.sim.getPropertySimilarity(objectArray[object3[n][0]], object[object3[n][1]]);
                if (!(d3 > d)) continue;
                this.addCell(new ObjectCell(null, objectArray[object3[n][0]], object[object3[n][1]], BasicRelation.createRelation("="), d3));
            }
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        if (properties.getProperty("noinst") == null) {
            try {
                int n6;
                Object[] objectArray2 = new Object[this.ontology1().nbIndividuals()];
                Object[] objectArray3 = new Object[this.ontology2().nbIndividuals()];
                int n7 = 0;
                int n8 = 0;
                for (Object e : this.ontology2().getIndividuals()) {
                    if (this.ontology2().getEntityURI(e) == null) continue;
                    objectArray3[n8++] = e;
                }
                for (Object e : this.ontology1().getIndividuals()) {
                    if (this.ontology1().getEntityURI(e) == null) continue;
                    objectArray2[n7++] = e;
                }
                object = new double[n7][n8];
                for (n6 = 0; n6 < n7; ++n6) {
                    for (int i = 0; i < n8; ++i) {
                        object[n6][i] = 1.0 - this.sim.getIndividualSimilarity(objectArray2[n6], objectArray3[i]);
                    }
                }
                int[][] nArray = HungarianAlgorithm.hgAlgorithm((double[][])object, (String)"max");
                for (n6 = 0; n6 < nArray.length; ++n6) {
                    double d4 = 1.0 - this.sim.getIndividualSimilarity(objectArray2[nArray[n6][0]], objectArray3[nArray[n6][1]]);
                    if (!(d4 > d)) continue;
                    this.addCell(new ObjectCell(null, objectArray2[nArray[n6][0]], objectArray3[nArray[n6][1]], BasicRelation.createRelation("="), d4));
                }
            }
            catch (AlignmentException alignmentException) {
                alignmentException.printStackTrace();
            }
            catch (OntowrapException ontowrapException) {
                ontowrapException.printStackTrace();
            }
        }
        return this;
    }

    public Alignment extractqqgreedy(double d, Properties properties) {
        double d2 = 0.0;
        TreeSet<Cell> treeSet = new TreeSet<Cell>(new Comparator<Cell>(){

            @Override
            public int compare(Cell cell, Cell cell2) throws ClassCastException {
                try {
                    if (cell.getStrength() > cell2.getStrength()) {
                        return -1;
                    }
                    if (cell.getStrength() < cell2.getStrength()) {
                        return 1;
                    }
                    if (DistanceAlignment.this.ontology1().getEntityName(cell.getObject1()) == null || DistanceAlignment.this.ontology2().getEntityName(cell2.getObject1()) == null) {
                        return -1;
                    }
                    if (DistanceAlignment.this.ontology1().getEntityName(cell.getObject1()).compareTo(DistanceAlignment.this.ontology2().getEntityName(cell2.getObject1())) > 0) {
                        return -1;
                    }
                    if (DistanceAlignment.this.ontology1().getEntityName(cell.getObject1()).compareTo(DistanceAlignment.this.ontology2().getEntityName(cell2.getObject1())) < 0) {
                        return 1;
                    }
                    if (DistanceAlignment.this.ontology1().getEntityName(cell.getObject2()) == null || DistanceAlignment.this.ontology2().getEntityName(cell2.getObject2()) == null) {
                        return -1;
                    }
                    if (DistanceAlignment.this.ontology1().getEntityName(cell.getObject2()).compareTo(DistanceAlignment.this.ontology2().getEntityName(cell2.getObject2())) > 0) {
                        return -1;
                    }
                    return 1;
                }
                catch (OntowrapException ontowrapException) {
                    ontowrapException.printStackTrace();
                    return 0;
                }
            }
        });
        try {
            Object object3;
            Object object22;
            for (Object object22 : this.ontology1().getClasses()) {
                for (Object object3 : this.ontology2().getClasses()) {
                    d2 = 1.0 - this.sim.getClassSimilarity(object22, object3);
                    if (!(d2 > d)) continue;
                    treeSet.add(new ObjectCell(null, object22, object3, BasicRelation.createRelation("="), d2));
                }
            }
            Iterator iterator = new ConcatenatedIterator(this.ontology1().getObjectProperties().iterator(), this.ontology1().getDataProperties().iterator());
            object22 = ((ConcatenatedIterator)iterator).iterator();
            while (object22.hasNext()) {
                Object object4 = object22.next();
                object3 = new ConcatenatedIterator(this.ontology2().getObjectProperties().iterator(), this.ontology2().getDataProperties().iterator());
                for (Object e : object3) {
                    d2 = 1.0 - this.sim.getPropertySimilarity(object4, e);
                    if (!(d2 > d)) continue;
                    treeSet.add(new ObjectCell(null, object4, e, BasicRelation.createRelation("="), d2));
                }
            }
            if (properties.getProperty("noinst") == null) {
                for (Object object4 : this.ontology1().getIndividuals()) {
                    if (this.ontology1().getEntityURI(object4) == null) continue;
                    for (Object object5 : this.ontology2().getIndividuals()) {
                        if (this.ontology2().getEntityURI(object5) == null || !((d2 = 1.0 - this.sim.getIndividualSimilarity(object4, object5)) > d)) continue;
                        treeSet.add(new ObjectCell(null, object4, object5, BasicRelation.createRelation("="), d2));
                    }
                }
            }
            for (Object object4 : treeSet) {
                Object object5;
                object3 = object4.getObject1();
                object5 = object4.getObject2();
                if (this.getAlignCells1(object3) != null || this.getAlignCells2(object5) != null) continue;
                this.addCell((Cell)object4);
            }
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        catch (OntowrapException ontowrapException) {
            ontowrapException.printStackTrace();
        }
        return this;
    }
}

