/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.NonTransitiveImplicationRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;
import org.xml.sax.ContentHandler;

public class BasicRelation
implements Relation {
    protected String relation = null;

    public void accept(AlignmentVisitor alignmentVisitor) throws AlignmentException {
        alignmentVisitor.visit((Visitable)this);
    }

    public BasicRelation(String string) {
        this.relation = string;
    }

    public String getRelation() {
        return this.relation;
    }

    public static Relation createRelation(String string) {
        BasicRelation basicRelation = null;
        if (string.equals("=")) {
            basicRelation = new EquivRelation();
        } else if (string.equals("<") || string.equals("&lt;")) {
            basicRelation = new SubsumedRelation();
        } else if (string.equals(">") || string.equals("&gt;")) {
            basicRelation = new SubsumeRelation();
        } else if (string.equals("%")) {
            basicRelation = new IncompatRelation();
        } else if (string.equals("~>") || string.equals("~&gt;")) {
            basicRelation = new NonTransitiveImplicationRelation();
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(null);
                basicRelation = (Relation)constructor.newInstance(null);
            }
            catch (Exception exception) {
                basicRelation = new BasicRelation(string);
            }
        }
        return basicRelation;
    }

    public Relation inverse() {
        return this;
    }

    public Relation compose(Relation relation) {
        return null;
    }

    public boolean equals(Relation relation) {
        if (relation instanceof BasicRelation) {
            return this.relation.equals(((BasicRelation)relation).getRelation());
        }
        return false;
    }

    public int hashCode() {
        return 19 + this.relation.hashCode();
    }

    public void dump(ContentHandler contentHandler) {
    }

    public void write(PrintWriter printWriter) {
        printWriter.print(this.relation);
    }
}

