/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.OntologyTriple;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.OntologyNetwork;

public class BasicOntologyNetwork
implements OntologyNetwork {
    protected Hashtable<URI, OntologyTriple> ontologies = new Hashtable();
    protected HashSet<Alignment> alignments = new HashSet();

    public void addOntology(URI uRI) {
        if (this.ontologies.get(uRI) == null) {
            this.ontologies.put(uRI, new OntologyTriple(uRI));
        }
    }

    public void remOntology(URI uRI) throws AlignmentException {
        OntologyTriple ontologyTriple = this.ontologies.get(uRI);
        if (ontologyTriple != null) {
            for (Alignment alignment : ontologyTriple.sourceAlignments) {
                this.remAlignment(alignment);
            }
            for (Alignment alignment : ontologyTriple.targettingAlignments) {
                this.remAlignment(alignment);
            }
            this.ontologies.remove(uRI);
        }
    }

    public void addAlignment(Alignment alignment) throws AlignmentException {
        URI uRI = alignment.getOntology1URI();
        this.addOntology(uRI);
        this.ontologies.get((Object)uRI).sourceAlignments.add(alignment);
        URI uRI2 = alignment.getOntology2URI();
        this.addOntology(uRI2);
        this.ontologies.get((Object)uRI2).targettingAlignments.add(alignment);
        this.alignments.add(alignment);
    }

    public void remAlignment(Alignment alignment) throws AlignmentException {
        this.ontologies.get((Object)alignment.getOntology1URI()).sourceAlignments.remove(alignment);
        this.ontologies.get((Object)alignment.getOntology2URI()).targettingAlignments.remove(alignment);
        this.alignments.remove(alignment);
    }

    public Set<Alignment> getAlignments() {
        return this.alignments;
    }

    public Set<URI> getOntologies() {
        return this.ontologies.keySet();
    }

    public Set<Alignment> getTargetingAlignments(URI uRI) {
        if (!this.ontologies.containsKey(uRI)) {
            return Collections.emptySet();
        }
        return this.ontologies.get((Object)uRI).targettingAlignments;
    }

    public Set<Alignment> getSourceAlignments(URI uRI) {
        if (!this.ontologies.containsKey(uRI)) {
            return Collections.emptySet();
        }
        return this.ontologies.get((Object)uRI).sourceAlignments;
    }

    public void invert() throws AlignmentException {
        HashSet<Alignment> hashSet = new HashSet<Alignment>();
        for (Alignment alignment : this.alignments) {
            hashSet.add(alignment.inverse());
        }
        for (Alignment alignment : hashSet) {
            this.addAlignment(alignment);
        }
    }
}

