/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.Extensions;
import fr.inrialpes.exmo.align.impl.Namespace;
import java.net.URI;
import java.util.Collection;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;
import org.xml.sax.ContentHandler;

public class BasicCell
implements Cell,
Comparable<Cell> {
    protected String id = null;
    protected String semantics = null;
    protected Object object1 = null;
    protected Object object2 = null;
    protected Relation relation = null;
    protected double strength = 0.0;
    protected Extensions extensions = null;

    public void accept(AlignmentVisitor alignmentVisitor) throws AlignmentException {
        alignmentVisitor.visit((Visitable)this);
    }

    public BasicCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        this.setId(string);
        this.object1 = object;
        this.object2 = object2;
        this.relation = relation;
        if (d >= 0.0 && d <= 1.0) {
            this.strength = d;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Cell) {
            return this.equals((Cell)object);
        }
        return false;
    }

    public boolean equals(Cell cell) {
        if (cell == null) {
            return false;
        }
        return this.object1.equals(((BasicCell)cell).getObject1()) && this.object2.equals(((BasicCell)cell).getObject2()) && this.strength == ((BasicCell)cell).getStrength() && this.relation.equals(((BasicCell)cell).getRelation());
    }

    public int hashCode() {
        return 17 + 7 * this.object1.hashCode() + 11 * this.object2.hashCode() + this.relation.hashCode() + (int)(this.strength * 150.0);
    }

    @Override
    public int compareTo(Cell cell) {
        if (cell.getStrength() > this.getStrength()) {
            return 1;
        }
        if (this.getStrength() > cell.getStrength()) {
            return -1;
        }
        return 0;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getSemantics() {
        if (this.semantics != null) {
            return this.semantics;
        }
        return "first-order";
    }

    public void setSemantics(String string) {
        this.semantics = string;
    }

    public Object getObject1() {
        return this.object1;
    }

    public Object getObject2() {
        return this.object2;
    }

    public URI getObject1AsURI() throws AlignmentException {
        return this.getObject1AsURI(null);
    }

    public URI getObject1AsURI(Alignment alignment) throws AlignmentException {
        if (this.object1 instanceof URI) {
            return (URI)this.object1;
        }
        throw new AlignmentException("Cannot find URI for " + this.object1);
    }

    public URI getObject2AsURI() throws AlignmentException {
        return this.getObject2AsURI(null);
    }

    public URI getObject2AsURI(Alignment alignment) throws AlignmentException {
        if (this.object2 instanceof URI) {
            return (URI)this.object2;
        }
        throw new AlignmentException("Cannot find URI for " + this.object2);
    }

    public void setObject1(Object object) throws AlignmentException {
        this.object1 = object;
    }

    public void setObject2(Object object) throws AlignmentException {
        this.object2 = object;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public double getStrength() {
        return this.strength;
    }

    public void setStrength(double d) {
        this.strength = d;
    }

    public Collection<String[]> getExtensions() {
        if (this.extensions != null) {
            return this.extensions.getValues();
        }
        return null;
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public void setExtension(String string, String string2, String string3) {
        if (this.extensions == null) {
            this.extensions = new Extensions();
        }
        this.extensions.setExtension(string, string2, string3);
    }

    public String getExtension(String string, String string2) {
        if (this.extensions != null) {
            return this.extensions.getExtension(string, string2);
        }
        return null;
    }

    public Cell inverse() throws AlignmentException {
        BasicCell basicCell = new BasicCell(null, this.object2, this.object1, this.relation.inverse(), this.strength);
        if (this.extensions != null) {
            Extensions extensions = (Extensions)this.extensions.clone();
            extensions.unsetExtension(Namespace.ALIGNMENT.getUriPrefix(), Annotations.ID);
            basicCell.setExtensions(extensions);
        }
        return basicCell;
    }

    public Cell compose(Cell cell) throws AlignmentException {
        if (!this.object2.equals(cell.getObject1()) && this.relation.compose(cell.getRelation()) == null) {
            return null;
        }
        BasicCell basicCell = new BasicCell(null, this.object1, cell.getObject2(), this.relation.compose(cell.getRelation()), this.strength * cell.getStrength());
        return basicCell;
    }

    public void dump(ContentHandler contentHandler) {
    }
}

